/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.baseobjects.User;
import de.memtext.rights.NewPasswordChecker;
import de.memtext.util.CryptUtils;
import de.memtext.util.DSAHandler;
import de.memtext.util.NumberUtils;
import de.memtext.util.StringUtils;
import de.memtext.widgets.WarningMessage;
import de.superx.applet.SxDate;
import de.superx.applet.SxDefaults;
import de.superx.applet.SxPasswdChangeDlg;
import de.superx.applet.SxSQLMetaData;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.TemplateProcessor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SxSQL {
    static URL superXDbServletUrl;
    static HttpURLConnection servletConnection;
    private static Integer userID;
    static DSAHandler dsaHandler;
    static boolean isClosed;
    static Statement statement;
    static ResultSet resultSet;
    static String aktuelleNachricht;
    static int updateCount;
    static int numberOfColumns;
    static Class[] columnTpyes;
    static SxResultSet rows;
    static Vector rows_ret;
    static SuperX_el gesamt;
    static SxSQLMetaData metaData;
    private static String logToKonsole;
    static StringBuffer prot_sql;
    static InetAddress client_addr;
    static String client_ip;
    static InetAddress client_dns;
    static int proto_fkt_id;
    static int proto_id_pos;
    static int user_id_pos;
    static String errorString;
    static Short adminUserInt;
    static String sx_db;
    static ObjectInputStream inputFromServlet;
    static ObjectOutputStream outputToServlet;
    static TemplateProcessor templateProcessor;
    static String mandantenID;
    static String jsessionid;
    static NewPasswordChecker newPasswordChecker;

    static {
        userID = new Integer(-1);
        isClosed = true;
        statement = null;
        resultSet = null;
        aktuelleNachricht = null;
        updateCount = -1;
        numberOfColumns = -1;
        columnTpyes = new Class[0];
        rows = new SxResultSet();
        rows_ret = new Vector();
        gesamt = new SuperX_el();
        logToKonsole = "";
        prot_sql = new StringBuffer();
        client_addr = null;
        client_ip = null;
        client_dns = null;
        proto_fkt_id = 2;
        proto_id_pos = -1;
        user_id_pos = -1;
        errorString = null;
        adminUserInt = new Short(0);
        sx_db = (String)SxDefaults.getPropertyValue("SxDB");
        inputFromServlet = null;
        outputToServlet = null;
        templateProcessor = new TemplateProcessor();
        mandantenID = "default";
    }

    private SxSQL() {
    }

    static void check(User user) throws Exception {
        SxSQL.initProtokolEntry();
        try {
            isClosed = false;
            SxSQL.checkPwd(user);
            proto_fkt_id = 1;
            prot_sql.replace(proto_id_pos, proto_id_pos + 1, new Integer(proto_fkt_id).toString());
            isClosed = false;
        }
        catch (Exception ex) {
            String msg = ex.toString();
            user_id_pos = prot_sql.toString().indexOf("%");
            if (user_id_pos > 0) {
                prot_sql.replace(user_id_pos, user_id_pos + 1, "-1");
            }
            throw new SQLException(msg);
        }
    }

    private static void initProtokolEntry() throws UnknownHostException {
        client_addr = InetAddress.getLocalHost();
        client_ip = client_addr.getHostAddress();
        client_dns = InetAddress.getByName(client_ip);
        prot_sql.append("insert into protokoll (proto_fkt_id, userinfo_id, ");
        prot_sql.append("ip_adresse, client_name, zeitpunkt) values (");
        prot_sql.append("?, ");
        prot_sql.append("% , '" + client_ip);
        prot_sql.append("', '" + client_dns.getHostName() + "'");
        if (sx_db.equals("Postgres")) {
            prot_sql.append(", now());");
        } else {
            prot_sql.append(", current);");
        }
        proto_id_pos = prot_sql.toString().indexOf("?");
        prot_sql.replace(proto_id_pos, proto_id_pos + 1, new Integer(proto_fkt_id).toString());
    }

    static void readFMTemplates() throws SQLException {
        SxSQL.executeQuery("readFMBasics");
        if (gesamt.getRawFmTemplates() == null) {
            throw new SQLException("Servlet hat keine FreeMarker Templates geschickt");
        }
        templateProcessor.setTemplates(gesamt.getRawFmTemplates());
        if (gesamt.getRepository() == null) {
            throw new SQLException("Servlet hat keine Sx_Repository Daten geschickt");
        }
        templateProcessor.setRepositoryMap(gesamt.getRepository());
        gesamt.setRepository(null);
    }

    static synchronized void checkPwd(User user) throws Exception {
        boolean login_ok = false;
        try {
            Short maxVersuch;
            Short dummy2;
            Integer dummy;
            Short aktVersuch;
            String auth_sql = "Anmeldung|" + user.getName() + "|" + user.getPasswd();
            SxSQL.executeQuery(auth_sql);
            if (SxSQL.getRowCount() == 0) {
                throw new Exception("Die Anmeldung des Users '" + user.getName() + "' war nicht erfolgreich");
            }
            SxResultRow V_row = (SxResultRow)rows.first();
            try {
                aktVersuch = (Short)V_row.get(3);
            }
            catch (ClassCastException e2) {
                dummy = (Integer)V_row.get(3);
                aktVersuch = dummy2 = new Short(dummy.shortValue());
            }
            try {
                maxVersuch = (Short)V_row.get(4);
            }
            catch (ClassCastException e3) {
                dummy = (Integer)V_row.get(4);
                maxVersuch = dummy2 = new Short(dummy.shortValue());
            }
            if (aktVersuch > maxVersuch || aktVersuch <= maxVersuch * -1) {
                throw new Exception("Die Zahl maximaler Login-Versuche f\u00fcr Benutzer '" + user.getName() + "' ist \u00fcberschritten.");
            }
            userID = (Integer)V_row.get(0);
            user.setId(userID);
            try {
                adminUserInt = (Short)V_row.get(2);
            }
            catch (ClassCastException e4) {
                dummy = (Integer)V_row.get(2);
                adminUserInt = dummy2 = new Short(dummy.shortValue());
            }
            user.setAdmin(SxSQL.isAdmin());
            user_id_pos = prot_sql.toString().indexOf("%");
            if (user_id_pos > 0) {
                prot_sql.replace(user_id_pos, user_id_pos + 1, userID.toString());
            }
            String passwd_sha = (String)V_row.get(1);
            Object kennwortSpalte = V_row.get(5);
            if (kennwortSpalte != null && kennwortSpalte.toString().trim().equals("\u00e4ndern")) {
                try {
                    login_ok = SxSQL.changePwd(user);
                }
                catch (Exception e5) {
                    String msg = e5.toString();
                    msg = msg.substring(msg.lastIndexOf(":") + 1);
                    e5.printStackTrace();
                    JOptionPane.showMessageDialog(null, msg, "Fehler", 0);
                    login_ok = false;
                    throw new RuntimeException("Fehler bei Passwort\u00e4nderung:" + e5);
                }
            }
            if (!(login_ok = true)) {
                String operator = "+";
                if (aktVersuch < 0) {
                    operator = "-";
                }
                throw new Exception("Fehlerhaftes Kennwort f\u00fcr Benutzer '" + user.getName() + "'");
            }
            SxSQL.initParams();
        }
        catch (SQLException e6) {
            e6.printStackTrace();
            String msg = "Datenbankverbindung konnte nicht aufgebaut werden. " + e6.toString();
            msg = msg.replace(':', '-');
            if (msg.indexOf("NichtAngemeldetException") > -1) {
                throw new IllegalStateException("Anmeldung fehlerhaft oder abgelaufen");
            }
            throw new Exception(msg);
        }
    }

    private static boolean changePwd(User user) throws Exception {
        SxPasswdChangeDlg dlg = new SxPasswdChangeDlg(null, "Bitte \u00e4ndern Sie Ihr Passwort ");
        dlg.setUsername(user.getName());
        dlg.setNewPasswordChecker(newPasswordChecker);
        dlg.setOldPassword(user.getPasswd());
        dlg.setUsernameFieldEnabled(false);
        dlg.setCheckOldPasswdWanted(false);
        dlg.show();
        if (!dlg.wasOkSelected()) {
            boolean login_ok = false;
            WarningMessage.show(null, "Sie k\u00f6nnen mit SuperX nur arbeiten,wenn Sie Ihr Passwort \u00e4ndern.\nBitte melden Sie dazu sich neu an.", "SuperX");
            throw new RuntimeException("Passwort\u00e4nderung n\u00f6tig");
        }
        SxSQL.storePwd(user, dlg.getNewPasswd(), false);
        boolean login_ok = true;
        SxSQL.execute("update userinfo set kennwort=null where tid=" + userID);
        return login_ok;
    }

    public static Integer getUserID() {
        if (userID != null) {
            return new Integer(userID);
        }
        System.out.println("Achtung! userID d\u00fcrfte eigentlich nicht null sein!!");
        return new Integer(-1);
    }

    public static final synchronized void storePwd(User user, String newpasswd, boolean isCheckOldPasswdWanted) throws Exception {
        if (isCheckOldPasswdWanted && !SxSQL.isAdmin()) {
            SxSQL.checkPwd(user);
        }
        SxSQL.execute("userchange|" + NumberUtils.getRandomInt(9) + CryptUtils.encodeSHA(String.valueOf(newpasswd) + CryptUtils.geheimnis1) + "|" + user.getName());
        if (gesamt.getUpdateCount() != 1) {
            throw new Exception("Benutzer '" + user.getName() + "'" + " nicht gefunden !");
        }
        user.setPasswd(newpasswd);
        proto_fkt_id = 6;
        SxSQL.execute("update userinfo set akt_versuch=0 where benutzer = '" + user.getName() + "'");
    }

    public static boolean isAdmin() {
        return adminUserInt.intValue() > 0;
    }

    public static synchronized void executeAll(String stmt) throws SQLException {
        StringTokenizer st = new StringTokenizer(stmt, ";");
        int n = 0;
        while (st.hasMoreTokens()) {
            ++n;
            String sqlstmt = st.nextToken().trim();
            if (sqlstmt.length() < 10) break;
        }
        if (n < 2) {
            SxSQL.executeQuery(stmt);
        } else {
            SxSQL.executeQuery("multi:" + stmt);
        }
    }

    private static synchronized void execute(String stmt) throws SQLException {
        SxSQL.applet_servlet_connection("single" + stmt);
    }

    static synchronized void executeQuery(String query) throws SQLException {
        if (!query.trim().equals("") && !query.trim().equals("null")) {
            SxSQL.applet_servlet_connection(query);
        }
    }

    public static int getUpdateCount() throws SQLException {
        return updateCount;
    }

    public static String getAktuelleNachricht() {
        return aktuelleNachricht;
    }

    public static int getColumnCount() {
        return numberOfColumns;
    }

    public static int getRowCount() {
        return rows.size();
    }

    public static Vector getResultVector() {
        Vector v = new Vector();
        for (SxResultRow r : rows) {
            Vector row = new Vector();
            Iterator it2 = r.iterator();
            while (it2.hasNext()) {
                row.add(it2.next());
            }
            v.add(row);
        }
        return v;
    }

    public static SxResultSet getResult() {
        return rows;
    }

    public static SxSQLMetaData getResultSetMetaData() {
        Object meta = null;
        return metaData;
    }

    public static void cancel() throws Exception {
        try {
            System.err.println("SxSQL: Cancel statement");
            Object inputFromServlet = null;
            Object outputToServlet = null;
            servletConnection.disconnect();
        }
        catch (Exception e2) {
            System.err.println("SxSQL: Error canceling statement: " + e2);
        }
    }

    public static synchronized void close() {
        int proto_fkt_id = 4;
        System.out.println("in close");
        try {
            System.err.println("SxSQL: Closing db connection");
            if (!isClosed) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                Object inputFromServlet = null;
                Object outputToServlet = null;
                servletConnection.disconnect();
                isClosed = true;
            }
        }
        catch (SQLException e2) {
            System.err.println("SxSQL: Error closing db connection: " + e2);
        }
    }

    public static boolean isActive() {
        return !isClosed;
    }

    static synchronized void specialExecute(String query, Hashtable htable) throws SQLException {
        Object outTest = null;
        Object inTest = null;
        Vector superX_elVector = new Vector();
        htable.put("query", query);
        try {
            servletConnection = (HttpURLConnection)superXDbServletUrl.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
        }
        catch (Exception e2) {
            System.out.println(e2.toString());
            throw new SQLException(e2.toString());
        }
        rows_ret = new Vector();
        try {
            outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(htable);
            outputToServlet.flush();
            outputToServlet.close();
        }
        catch (IOException e3) {
            System.out.println(e3.toString());
            throw new SQLException(e3.toString());
        }
        catch (Exception e4) {
            e4.printStackTrace();
            throw new SQLException(e4.toString());
        }
        ObjectInputStream inputFromServlet = null;
        try {
            inputFromServlet = new ObjectInputStream(servletConnection.getInputStream());
            gesamt = (SuperX_el)inputFromServlet.readObject();
            aktuelleNachricht = gesamt.getAktuelleNachricht();
            numberOfColumns = gesamt.getColumnCount();
            rows = gesamt.getResultSet();
            metaData = new SxSQLMetaData(gesamt);
            inputFromServlet.close();
        }
        catch (Exception e5) {
            e5.printStackTrace();
            System.err.println(gesamt.getError_String());
            throw new SQLException(gesamt.getError_String());
        }
        errorString = gesamt.getError_String();
        if (errorString != null && errorString.trim().length() > 1) {
            if ((logToKonsole.equals("errors") || logToKonsole.equals("all")) && aktuelleNachricht != null) {
                System.out.println("----------------------------------------------------");
                System.out.println("Folgender Select ergab einen Fehler: ");
                System.out.println(aktuelleNachricht);
                System.out.println("----------------------------------------------------");
            }
            servletConnection.disconnect();
            throw new SQLException("im Servlet " + gesamt.getError_String());
        }
    }

    private static synchronized void applet_servlet_connection(String query) throws SQLException {
        String logquery = query.trim();
        if (logquery.substring(0, 6).equals("single")) {
            logquery = query.substring(6);
        }
        if (logquery.substring(0, 6).equals("multi:")) {
            logquery = query.substring(6);
        }
        if (logquery.startsWith("Anmeldung")) {
            logquery = "Anmeldung";
        }
        if (logToKonsole.equals("all")) {
            System.out.println("----------------Select-Stmt, gestartet am " + SxDate.getNowString() + "-----------------");
            System.out.println(logquery);
        }
        Object outTest = null;
        Object inTest = null;
        Vector superX_elVector = new Vector();
        rows_ret = new Vector();
        if (query.startsWith("Anmeldung")) {
            LinkedList l2 = StringUtils.getStringTokenizedList(query, "|");
            try {
                servletConnection = (HttpURLConnection)new URL(superXDbServletUrl.toString()).openConnection();
                query = "Anmeldung";
                servletConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                servletConnection.setDoInput(true);
                servletConnection.setDoOutput(true);
                servletConnection.setUseCaches(false);
                DataOutputStream printout = new DataOutputStream(servletConnection.getOutputStream());
                String content = "kennung=" + l2.get(1) + "&passwort=" + l2.get(2) + "&MandantenID=" + mandantenID + "&query=" + query;
                printout.writeBytes(content);
                printout.flush();
                printout.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new SQLException(e2.toString());
            }
        }
        try {
            servletConnection = (HttpURLConnection)new URL(String.valueOf(superXDbServletUrl.toString()) + ";jsessionid=" + jsessionid).openConnection();
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(mandantenID);
            String queryCode = CryptUtils.encryptStringDES(query);
            outputToServlet.writeObject(queryCode);
            String signature = null;
            if (dsaHandler != null) {
                signature = dsaHandler.sign(queryCode);
            }
            outputToServlet.writeObject(signature);
            outputToServlet.flush();
            outputToServlet.close();
        }
        catch (IOException e3) {
            System.out.println(e3.toString());
            throw new SQLException(e3.toString());
        }
        catch (Exception e4) {
            e4.printStackTrace();
            throw new SQLException(e4.toString());
        }
        ObjectInputStream inputFromServlet = null;
        try {
            inputFromServlet = new ObjectInputStream(servletConnection.getInputStream());
            gesamt = (SuperX_el)inputFromServlet.readObject();
            jsessionid = gesamt.getJsessionid();
            aktuelleNachricht = gesamt.getAktuelleNachricht();
            numberOfColumns = gesamt.getColumnCount();
            rows = gesamt.getResultSet();
            metaData = new SxSQLMetaData(gesamt);
            inputFromServlet.close();
        }
        catch (Exception e5) {
            String msg = gesamt.getError_String();
            if (e5 instanceof StreamCorruptedException) {
                msg = "Anmeldefehler (falsche jsessionid?!) " + msg;
            }
            e5.printStackTrace();
            System.err.println();
            throw new SQLException(msg);
        }
        errorString = gesamt.getError_String();
        if (errorString != null && errorString.trim().length() > 1) {
            if ((logToKonsole.equals("errors") || logToKonsole.equals("all")) && aktuelleNachricht != null) {
                System.out.println("----------------------------------------------------");
                System.out.println("Folgender Select ergab einen Fehler: ");
                System.out.println(aktuelleNachricht);
                System.out.println("----------------------------------------------------");
            }
            servletConnection.disconnect();
            throw new SQLException("im Servlet " + gesamt.getError_String());
        }
    }

    static void setUrl(String url) throws MalformedURLException {
        superXDbServletUrl = new URL(url);
    }

    public static String getErrorString() {
        return errorString;
    }

    public static void setUserID(Integer userID) {
        SxSQL.userID = userID;
    }

    public static void setLogMode(String logParam) {
        logToKonsole = logParam;
    }

    public static String getUserFromServlet() throws SQLException {
        SxSQL.executeQuery("get_user");
        SxResultRow row = (SxResultRow)gesamt.getResultSet().first();
        String user = (String)row.get(0);
        return user;
    }

    public static void initParams() throws Exception {
        SxSQL.executeQuery("get_params");
        String privateKeyEncoded = gesamt.getCheckval();
        if (privateKeyEncoded != null && !privateKeyEncoded.trim().equals("")) {
            privateKeyEncoded = CryptUtils.decryptStringDES(privateKeyEncoded);
            dsaHandler = new DSAHandler(privateKeyEncoded);
        } else {
            dsaHandler = null;
        }
        newPasswordChecker = SxSQL.gesamt.newPasswordChecker;
    }
}

