/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SxSqlHelper {
    private String mandantenID = "default";

    public synchronized void execute(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        StringTokenizer st = new StringTokenizer(query, ";");
        int numberOfColumns = -1;
        int updateCount = -1;
        int n = 0;
        while (st.hasMoreTokens()) {
            ++n;
            String sqlstmt = st.nextToken().trim();
            if (sqlstmt.length() < 5) continue;
            try {
                if (statement.execute(sqlstmt)) {
                    int column;
                    ResultSet resultSet = statement.getResultSet();
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    numberOfColumns = metaData.getColumnCount();
                    String[] columnNames = new String[numberOfColumns];
                    String[] columnLabel = new String[numberOfColumns];
                    int[] columnDisplaySize = new int[numberOfColumns];
                    int[] columnType = new int[numberOfColumns];
                    int[] Scale = new int[numberOfColumns];
                    boolean[] isWritable = new boolean[numberOfColumns];
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnNames[column] = metaData.getColumnName(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnLabel[column] = metaData.getColumnLabel(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnDisplaySize[column] = metaData.getColumnDisplaySize(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnType[column] = this.adaptColumType(metaData.getColumnType(column + 1));
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        Scale[column] = metaData.getScale(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        isWritable[column] = metaData.isWritable(column + 1);
                    }
                    int naturalOrderNo = 1;
                    while (resultSet.next()) {
                        SxResultRow newRow = this.addRow(metaData, numberOfColumns, naturalOrderNo++, resultSet, columnNames);
                        rows.add(newRow);
                    }
                    gesamt.setColumnCount(numberOfColumns);
                    gesamt.setAndAdaptColumnNames(columnNames);
                    gesamt.setColumnLabels(columnLabel);
                    gesamt.setColumnDisplaySizes(columnDisplaySize);
                    gesamt.setColumnTypes(columnType);
                    gesamt.setScales(Scale);
                    gesamt.setisWritable(isWritable);
                    gesamt.setRows(rows);
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    updateCount = -1;
                } else {
                    updateCount = statement.getUpdateCount();
                }
            }
            catch (SQLException e) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, e.toString());
                gesamt.setError_String(e.toString());
            }
            catch (Exception e) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Allgemeiner Fehler beim DB-Zugriff:" + e.toString());
                gesamt.setError_String(e.toString());
            }
            gesamt.setUpdateCount(updateCount);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private SxResultRow addRow(ResultSetMetaData metaData, int numberOfColumns, int naturalOrderNo, ResultSet resultSet, String[] columnName) throws SQLException {
        SxResultRow newRow = new SxResultRow(numberOfColumns, naturalOrderNo);
        block22: for (int i = 0; i < numberOfColumns; ++i) {
            switch (metaData.getColumnType(i + 1)) {
                case 1: 
                case 12: {
                    String value;
                    try {
                        value = resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Textfeld " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                    }
                    if (value == null || value.equals("null")) {
                        newRow.add(new String(""));
                        continue block22;
                    }
                    newRow.add(value.trim());
                    continue block22;
                }
                case -1: {
                    String value;
                    try {
                        value = "" + resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Blob " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                    }
                    if (value == null || value.equals("null")) {
                        newRow.add(new String(""));
                        continue block22;
                    }
                    newRow.add(value.trim());
                    continue block22;
                }
                case 4: {
                    try {
                        newRow.add(resultSet.getObject(i + 1));
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Integer " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                    continue block22;
                }
                case 2: {
                    try {
                        BigDecimal myNum = resultSet.getBigDecimal(i + 1);
                        newRow.add(myNum);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Numeric " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                    continue block22;
                }
                case 93: {
                    Object myObj;
                    try {
                        myObj = resultSet.getObject(i + 1);
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Objekt: " + myObj.toString());
                        newRow.add(myObj);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Timestamp " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add("");
                    }
                    continue block22;
                }
                case 91: {
                    Object myObj = null;
                    try {
                        myObj = resultSet.getDate(i + 1);
                        newRow.add(myObj);
                    }
                    catch (Exception e) {
                        System.out.println("myObj " + myObj + " i:" + i + " columncount:" + resultSet.getMetaData().getColumnCount());
                        for (int ix = 0; ix < resultSet.getMetaData().getColumnCount(); ++ix) {
                            System.out.println(resultSet.getMetaData().getColumnName(ix + 1) + " " + resultSet.getMetaData().getColumnTypeName(ix + 1));
                        }
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Datum " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add("Fehler beim Datum einlesen");
                    }
                    continue block22;
                }
                default: {
                    try {
                        newRow.add(resultSet.getObject(i + 1));
                        continue block22;
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Unbekanntes Objekt " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                }
            }
        }
        return newRow;
    }

    public int adaptColumType(int rsColType) {
        int returnType;
        switch (rsColType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                returnType = 4;
                break;
            }
            case 16: {
                returnType = -7;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                returnType = 3;
                break;
            }
            case 91: {
                returnType = 6;
                break;
            }
            case 93: {
                returnType = 8;
                break;
            }
            case 92: {
                returnType = 9;
                break;
            }
            default: {
                returnType = 1;
            }
        }
        return returnType;
    }
}

