/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.TreeUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.Field;
import de.superx.common.SelectableItemNode;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FieldXmlEncoder {
    public static String toXml(Field f, boolean isFullXMLRequired, int rownr) {
        StringBuffer result = new StringBuffer("<feld " + FieldXmlEncoder.dynamic(f) + ">\n");
        result.append(FieldXmlEncoder.getBasics(f));
        FieldXmlEncoder.appendSichtgruppe(f, result);
        FieldXmlEncoder.appendRelation(f, isFullXMLRequired, result);
        result.append("<rownr>" + rownr + "</rownr>\n");
        result.append("</feld>\n");
        return result.toString();
    }

    private static String dynamic(Field f) {
        String result = " isDynamic=\"false\"";
        if (f.isDynamic()) {
            result = " isDynamic=\"true\"";
        }
        return result;
    }

    public static String toXml(Field f, String param) {
        if (param == null) {
            throw new IllegalArgumentException("Param null");
        }
        StringBuffer result = new StringBuffer();
        if (param.equalsIgnoreCase("!all")) {
            result.append(FieldXmlEncoder.toXml(f, true, 0));
        } else {
            result.append("<feld " + FieldXmlEncoder.dynamic(f) + ">\n<relation>");
            if (!f.getSelectableItemsTree().containsItemWithId(param)) {
                throw new IllegalArgumentException("Im Feld " + f.getName() + " (" + f.getId() + ") gibt es kein Element " + param);
            }
            SelectableItemNode startnode = f.getSelectableItemsTree().getById(param);
            Enumeration<TreeNode> en = startnode.children();
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                node.toXml(f.getArt() == 9, result);
            }
            result.append("\n</relation>\n</feld>");
        }
        return result.toString();
    }

    private static void appendRelation(Field f, boolean isFullXMLRequired, StringBuffer result) {
        result.append("  <relation>\n");
        if (isFullXMLRequired || f.getArt() != 12 && (f.getArt() != 1 || f.getZeilenanzahl() <= 1 && !f.isDynamic())) {
            int maxLevel = -1;
            if (f.getSichtgruppe() != null && f.getSichtgruppe().getSelectedSicht().getXmlMaxEntries() != null) {
                maxLevel = TreeUtils.getMaxLevel(f.getSelectableItemsTree().getRoot(), f.getSichtgruppe().getSelectedSicht().getXmlMaxEntries());
            }
            Enumeration<TreeNode> en = f.getSelectableItemsTree().getRoot().preorderEnumeration();
            while (en.hasMoreElements()) {
                TreeNode anode = en.nextElement();
                SelectableItemNode node = (SelectableItemNode)anode;
                if (!FieldXmlEncoder.isNodeWanted(f, node, maxLevel)) continue;
                node.toXml(f.getArt() == 9, result);
            }
        } else {
            result.append("<!-- wegen dynamischen Nachladens der Eintr\u00e4ge per Ajax(dojo) werden Einzelitems nicht ausgegeben-->\n");
        }
        result.append("  </relation>\n");
        if (f.getDefaultValue() != null) {
            String name = f.getDefaultValue().getName().toString();
            if (f.getTyp().equals("date") && f.getArt() == 0) {
                if (name.startsWith("'")) {
                    name = name.substring(1);
                }
                if (name.endsWith("'")) {
                    name = name.substring(0, name.length() - 1);
                }
            }
            String hasDefaultValueInDB = "false";
            if (f.getDefaultwertString() != null && !f.getDefaultwertString().equals("")) {
                hasDefaultValueInDB = "true";
            }
            result.append("<defaultwert hasDbValue=\"" + hasDefaultValueInDB + "\"><key><![CDATA[" + f.getDefaultValue().getId() + "]]></key><name><![CDATA[" + name + "]]></name></defaultwert>\n");
        }
    }

    private static boolean isNodeWanted(Field f, SelectableItemNode node, int maxLevel) {
        boolean dummy = true;
        boolean isWanted = true;
        if (node.isRoot() || node.isTemporary()) {
            isWanted = false;
        }
        if (isWanted && f.getSichtgruppe() != null) {
            AbstractSicht sicht = f.getSichtgruppe().getSelectedSicht();
            if (maxLevel > -1 && node.getLevel() > maxLevel) {
                isWanted = false;
            }
            if (isWanted && sicht.isAltHier() && !sicht.isVisible(new TreePath(node.getPath()))) {
                isWanted = false;
            }
        }
        return isWanted;
    }

    private static void appendSichtgruppe(Field f, StringBuffer result) {
        if (f.isOldOrganigrammArt() || f.isSicht()) {
            if (f.getSichtgruppe() == null) {
                throw new IllegalStateException("Kann Feld " + f.getName() + "(" + f.getId() + ") nicht als XML darstellen, solange variable sichtgruppe null ist");
            }
            result.append(f.getSichtgruppe().toXml(f.isOldOrganigrammArt()));
        }
    }

    private static StringBuffer getBasics(Field f) {
        StringBuffer result = new StringBuffer("");
        result.append("  <tid>" + f.getId() + "</tid>\n");
        result.append("  <name>" + f.getName() + "</name>\n");
        if (f.getCaptionShort() != null) {
            result.append("  <caption_short>" + f.getCaptionShort() + "</caption_short>\n");
        }
        if (f.getCaptionLong() != null) {
            result.append("  <caption_long><![CDATA[");
            if (f.getCaptionLong() != null && f.getCaptionLong().startsWith("<html>")) {
                result.append(f.getCaptionLong().substring(6));
            } else {
                result.append(f.getCaptionLong());
            }
            result.append("]]></caption_long>\n");
        }
        result.append("  <nummer>" + f.getNummer() + "</nummer>\n");
        result.append("  <x>" + f.getX() + "</x>\n");
        result.append("  <y>" + f.getY() + "</y>\n");
        result.append("  <buttonbreite>" + f.getButtonbreite() + "</buttonbreite>\n");
        result.append("  <feldbreite>" + f.getFeldbreite() + "</feldbreite>\n");
        result.append("  <zeilenanzahl>" + f.getZeilenanzahl() + "</zeilenanzahl>\n");
        result.append("  <typ>" + f.getTyp() + "</typ>\n");
        result.append("  <laenge>" + f.getLaenge() + "</laenge>\n");
        result.append("  <obligatorisch>" + (f.isObligatorisch() ? "1" : "0") + "</obligatorisch>\n");
        result.append("  <art>" + f.getArt() + "</art>\n");
        result.append(" <attribut hasDynamicSichtDefault=\"" + (f.hasDynamicDefaultSicht() ? "true" : "false") + "\"><![CDATA[" + (f.hasDynamicDefaultSicht() ? "" : f.getAttribut()) + "]]></attribut>");
        return result;
    }
}

