/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.hbt;

import clover.com.atlassian.extras.common.org.springframework.util.StringUtils;
import de.memtext.db.DbUtils;
import de.memtext.hbt.AbstractAriel;
import de.memtext.util.FileUtils;
import de.memtext.util.MailUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxMail;
import de.superx.servlet.SxPools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;

public class NewHeartBeatAriel
extends AbstractAriel {
    private static final Pattern pHbtId = Pattern.compile("@hbt:\\d*@");

    public NewHeartBeatAriel(SxMail sxmail) throws IOException {
        this.sxmail = sxmail;
        this.initLogging();
    }

    @Override
    void processNewMessages(Message[] newMessages) throws MessagingException, IOException, SQLException {
        this.logger.log(Level.INFO, "  found " + newMessages.length + " new messages");
        for (Message aNewMessage : newMessages) {
            String content = MailUtils.getContent(aNewMessage);
            if (content.indexOf("@hbt:") == -1) {
                this.createNewHeartBeat(aNewMessage, content);
            } else {
                this.appendToHeartBeat(aNewMessage, content);
            }
            aNewMessage.setFlag(Flags.Flag.DELETED, true);
        }
    }

    private void appendToHeartBeat(Message message, String content) throws SQLException, IOException, MessagingException {
        StringBuffer result = new StringBuffer();
        int hbtTid = -1;
        Connection con = SxPools.getConnection(this.sxmail.getMandantenID());
        Statement stm = con.createStatement();
        boolean isHbtFoundInDb = false;
        String feedbackSubject = "";
        Matcher m = pHbtId.matcher(content);
        boolean foundHbtTag = m.find();
        if (foundHbtTag) {
            String hbtIdString = content.substring(m.start() + 5, m.end() - 1);
            content = content.replaceAll("@hbt:\\d*@", "");
            try {
                hbtTid = Integer.parseInt(hbtIdString);
                if (DbUtils.getInt(con, "select count(*) from hbt_heartbeat where tid=?", hbtTid) > 0) {
                    isHbtFoundInDb = true;
                }
            }
            catch (NumberFormatException e) {
                result.append(" hbt:" + hbtIdString + " konnte nicht in integer transformiert werden, Nachricht wird zwischengespeichert");
                isHbtFoundInDb = false;
            }
            if (isHbtFoundInDb) {
                int maxTopic = DbUtils.getInt(con, "select max(tid) from hbt_topic where hbt_id=?", hbtTid);
                int newNoteId = this.createNote(con, stm, hbtTid, maxTopic, message, content);
                feedbackSubject = "Your new note was added to Heartbeat " + hbtTid;
                result.append("Feel free to view this HeartBeat by visiting " + this.sxmail.getWTFAI() + "/edit/hbt/hbt_viewer.jsp?tid=" + hbtTid + " \n\nAlways at your service: \n your HeartBeatAriel @ SuperX");
            }
        }
        if (!foundHbtTag || !isHbtFoundInDb) {
            feedbackSubject = "Sorry, target hbt found found ...";
            PreparedStatement pst = con.prepareStatement("insert into hbt_tmp_note (note) values (?)");
            pst.setString(1, content);
            pst.execute();
            pst.close();
            int newNoteId = DbUtils.getInt(stm, "select max(tid) from hbt_tmp_note");
            result.append("you can select the right hbt_id by visiting  " + this.sxmail.getWTFAI() + "/servlet/SuperXmlMaske?tid=60040?note_id=" + newNoteId);
        }
        stm.close();
        con.close();
        this.sendFeedbackEmail(feedbackSubject, result.toString(), message);
    }

    private void createNewHeartBeat(Message inMessage, String content) throws SQLException, MessagingException, IOException {
        int newHbtTid = this.performHbtInsert(inMessage, content);
        String text = "Feel free to complete this heartbeat's details by visiting " + this.sxmail.getWTFAI() + "/edit/hbt/hbt_edit.jsp?tid=" + newHbtTid + " \n\nAlways at your service: \n your HeartBeatAriel @ SuperX";
        this.sendFeedbackEmail("Your new digital heartbeat has been created ...", text, inMessage);
    }

    private int performHbtInsert(Message m, String content) throws SQLException, IOException, MessagingException {
        Connection con = SxPools.getConnection(this.sxmail.getMandantenID());
        Statement stm = con.createStatement();
        int newHbtTid = this.createHbt(con, stm, content, m.getSubject());
        int newTopicId = this.createTopic(stm, newHbtTid);
        this.createNote(con, stm, newHbtTid, newTopicId, m, content);
        con.close();
        return newHbtTid;
    }

    private int createHbt(Connection dbConnection, Statement stm, String content, String subject) throws IOException, MessagingException, SQLException {
        String primary_customer_id = this.identifyPrimaryCustomerId(dbConnection, stm, content);
        String name = StringUtils.replace((String)subject, (String)"'", (String)"''");
        stm.execute("select sp_update_sequence('hbt_heartbeat')");
        String insertSql = "INSERT INTO hbt_heartbeat \n( primary_customer_id,name,  created_at, \n  status \n) \nVALUES \n( " + primary_customer_id + ",'" + name + "',   today(), \n  1 \n) ";
        stm.execute(insertSql);
        int newHbtTid = DbUtils.getInt(stm, "select max(tid) from hbt_heartbeat");
        return newHbtTid;
    }

    private String identifyPrimaryCustomerId(Connection con, Statement stm, String content) throws IOException, MessagingException, SQLException {
        String result = "null";
        int pos1 = content.indexOf("@@");
        int pos2 = content.substring(pos1 + 2).indexOf("@@");
        if (pos1 > -1 && pos2 > -1) {
            String absender = content.substring(pos1 + 2);
            absender = absender.substring(0, absender.lastIndexOf("@@"));
            this.logger.log(Level.INFO, "  checking customer " + absender);
            int userinfo_id = DbUtils.getInt(con, "select tid from userinfo where email=?", absender);
            result = DbUtils.getString(stm, "select min(ch110_institut) from user_institution where userid=" + userinfo_id);
            result = result == null ? "null" : "'" + result + "'";
        }
        return result;
    }

    private int createTopic(Statement stm, int newHbtTid) throws SQLException {
        stm.execute("select sp_update_sequence('hbt_topic')");
        String insertSql = "INSERT INTO hbt_topic \n( hbt_id,name, created_at)VALUES (" + newHbtTid + ",'Start',now() )";
        stm.execute(insertSql);
        int newTopicId = DbUtils.getInt(stm, "select max(tid) from hbt_topic");
        return newTopicId;
    }

    private int createNote(Connection con, Statement stm, int hbtId, int topicId, Message m, String content) throws IOException, MessagingException, SQLException {
        stm.execute("select sp_update_sequence('hbt_note')");
        PreparedStatement pst = con.prepareStatement(" INSERT INTO hbt_note (hbt_id,hbt_topic_id,note, created_at) VALUES (?,?,?,now());");
        pst.setInt(1, hbtId);
        pst.setInt(2, topicId);
        pst.setString(3, content);
        pst.execute();
        pst.close();
        int newNoteId = DbUtils.getInt(stm, "select max(tid) from hbt_note");
        this.saveAttachments(stm, hbtId, topicId, newNoteId, m);
        return newNoteId;
    }

    private void saveAttachments(Statement stm, int newHbtTid, int newTopicId, int newNoteId, Message m) throws IOException, MessagingException, SQLException {
        Object content = m.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < multipart.getCount(); ++i) {
                int bytesRead;
                BodyPart part = multipart.getBodyPart(i);
                this.logger.log(Level.INFO, part.getFileName() + " " + part.getContentType() + " " + part.getDisposition());
                if (part.getDisposition() == null || !part.getDisposition().equalsIgnoreCase("attachment")) continue;
                String filename = SuperXManager.getWEB_INFPfad() + "/downloads/hbt_" + newHbtTid + "_" + newNoteId + "_" + FileUtils.removeProblemChars(part.getFileName());
                this.sxDownloadsInsert(stm, newHbtTid, newTopicId, newNoteId, filename, part.getContentType());
                InputStream is = part.getInputStream();
                File f = new File(filename);
                FileOutputStream fos = new FileOutputStream(f);
                byte[] buf = new byte[4096];
                while ((bytesRead = is.read(buf)) != -1) {
                    fos.write(buf, 0, bytesRead);
                }
                fos.close();
                this.logger.log(Level.INFO, " saving attachment " + i++ + " as " + filename);
            }
        }
    }

    private void sxDownloadsInsert(Statement stm, int newHbtTid, int newTopicId, int newNoteId, String filename, String contenttype) throws SQLException {
        stm.execute("select sp_update_sequence('sx_downloads')");
        String filenameShort = filename.substring(filename.indexOf(File.separator + "hbt") + 1);
        String insertSQLSxDownloads = "INSERT INTO sx_downloads \n( \n  name, \n  importdatum, \n  kommentar, \n  kommentar_url, \n  contenttype, \n  datei, \n  gueltig_seit, \n  gueltig_bis \n) \nVALUES \n( \n  '" + filenameShort + "', \n  today(), \n  'kommentar_value', \n  'kommentar_url_value', \n  '" + contenttype + "', \n  '" + filenameShort + "', \n  today(), \n  date_val('1.1.3000') \n) \n";
        stm.execute(insertSQLSxDownloads);
        int newDownloadTid = DbUtils.getInt(stm, "select max(tid) from sx_downloads");
        stm.executeUpdate("insert into hbt_attachment (hbt_id,topic_id,note_id,download_id) values (" + newHbtTid + "," + newTopicId + "," + newNoteId + "," + newDownloadTid + ")");
    }

    private void sendFeedbackEmail(String subject, String text, Message inMessage) throws AddressException, MessagingException {
        MimeMessage reply = this.sxmail.createMessage();
        reply.setRecipients(Message.RecipientType.TO, inMessage.getFrom());
        reply.setSubject(subject);
        reply.setText(text);
        this.sxmail.setMessage(reply);
        this.logger.log(Level.INFO, "Reply message happily sent...");
    }
}

