/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.afterinvocation;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.acls.afterinvocation.AbstractAclProvider;
import org.springframework.security.acls.afterinvocation.ArrayFilterer;
import org.springframework.security.acls.afterinvocation.CollectionFilterer;
import org.springframework.security.acls.afterinvocation.Filterer;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclEntryAfterInvocationCollectionFilteringProvider
extends AbstractAclProvider {
    protected static final Log logger = LogFactory.getLog(AclEntryAfterInvocationCollectionFilteringProvider.class);

    public AclEntryAfterInvocationCollectionFilteringProvider(AclService aclService, List<Permission> requirePermission) {
        super(aclService, "AFTER_ACL_COLLECTION_READ", requirePermission);
    }

    public Object decide(Authentication authentication, Object object, Collection<ConfigAttribute> config, Object returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Return object is null, skipping");
            }
            return null;
        }
        for (ConfigAttribute attr : config) {
            Filterer<Object> filterer;
            if (!this.supports(attr)) continue;
            if (returnedObject instanceof Collection) {
                filterer = new CollectionFilterer((Collection)returnedObject);
            } else if (returnedObject.getClass().isArray()) {
                filterer = new ArrayFilterer<Object>((Object[])returnedObject);
            } else {
                throw new AuthorizationServiceException("A Collection or an array (or null) was required as the returnedObject, but the returnedObject was: " + returnedObject);
            }
            for (Object t : filterer) {
                if (t == null || !this.getProcessDomainObjectClass().isAssignableFrom(t.getClass()) || this.hasPermission(authentication, t)) continue;
                filterer.remove(t);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Principal is NOT authorised for element: " + t));
            }
            return filterer.getFilteredObject();
        }
        return returnedObject;
    }
}

