/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnZipper {
    File zipFile = null;
    String targetDirectoryPath = null;

    public UnZipper(String zipFilePath, String targetDirectoryPath) {
        this.init(new File(zipFilePath), targetDirectoryPath);
    }

    public UnZipper(File zipFile, String targetDirectoryPath) {
        this.init(zipFile, targetDirectoryPath);
    }

    private void init(File zipFile, String targetDirectoryPath) {
        this.zipFile = zipFile;
        this.targetDirectoryPath = targetDirectoryPath;
        if (!zipFile.exists() || zipFile.isDirectory()) {
            throw new IllegalArgumentException("The given zipFile does not exist.");
        }
        if (!this.targetDirectoryPath.endsWith("/") && !this.targetDirectoryPath.endsWith("\\")) {
            this.targetDirectoryPath = this.targetDirectoryPath + System.getProperty("file.separator");
        }
    }

    public String[] unzip() {
        String[] result = null;
        byte[] buffer = new byte[4096];
        ZipFile zipped = null;
        FileOutputStream out = null;
        try {
            zipped = new ZipFile(this.zipFile);
            Enumeration<? extends ZipEntry> entries = zipped.entries();
            result = new String[zipped.size()];
            int i = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                result[i] = entry.getName();
                if (System.getProperty("file.separator").equals("\\")) {
                    result[i] = result[i].replace('/', '\\');
                }
                if (entry.isDirectory()) {
                    new File(this.targetDirectoryPath + result[i]).mkdirs();
                } else {
                    int separatorIndex = result[i].lastIndexOf(System.getProperty("file.separator"));
                    String relativePath = result[i].substring(0, separatorIndex + 1);
                    File targetDirectory = new File(this.targetDirectoryPath + relativePath);
                    if (!targetDirectory.exists()) {
                        targetDirectory.mkdirs();
                    }
                    out = new FileOutputStream(this.targetDirectoryPath + result[i]);
                    InputStream in = zipped.getInputStream(entry);
                    int len = 0;
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                    in.close();
                }
                ++i;
            }
            zipped.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (zipped != null) {
                try {
                    zipped.close();
                }
                catch (Throwable e1) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            return null;
        }
        return result;
    }
}

