/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.objects.acl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.VFS;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.saiku.web.rest.objects.acl.AclEntry;
import org.saiku.web.rest.objects.acl.enumeration.AclMethod;
import org.saiku.web.rest.resources.BasicRepositoryResource2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acl {
    private Map<String, AclEntry> acl = new TreeMap<String, AclEntry>();
    private static final Logger logger = LoggerFactory.getLogger(Acl.class);
    private static final String SAIKUACCESS_FILE = ".saikuaccess";
    private List<String> adminRoles;
    private AclMethod rootMethod = AclMethod.WRITE;
    private FileObject repoRoot;
    private static final Logger log = LoggerFactory.getLogger(BasicRepositoryResource2.class);

    public void setPath(String path) throws Exception {
        try {
            FileSystemManager fileSystemManager;
            FileObject fileObject;
            if (!path.endsWith("" + File.separatorChar)) {
                path = path + File.separatorChar;
            }
            if ((fileObject = (fileSystemManager = VFS.getManager()).resolveFile(path)) == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            this.repoRoot = fileObject;
            String rootPath = this.getPath(this.repoRoot);
            this.readAclTree(rootPath);
        }
        catch (Exception e) {
            log.error("Error setting path for acl: " + path, (Throwable)e);
        }
    }

    public void setAdminRoles(List<String> adminRoles) {
        this.adminRoles = adminRoles;
    }

    public void setRootAcl(String rootAcl) {
        try {
            if (StringUtils.isNotBlank((String)rootAcl)) {
                this.rootMethod = AclMethod.valueOf(rootAcl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<AclMethod> getMethods(String path, String username, List<String> roles) {
        try {
            AclMethod method;
            AclEntry entry = this.acl.get(path);
            if (path.startsWith("..")) {
                return this.getAllAcls(AclMethod.NONE);
            }
            if (this.isAdminRole(roles)) {
                return this.getAllAcls(AclMethod.GRANT);
            }
            if (entry != null) {
                switch (entry.getType()) {
                    case PRIVATE: {
                        if (!entry.getOwner().equals(username)) {
                            method = AclMethod.NONE;
                            break;
                        }
                        method = AclMethod.GRANT;
                        break;
                    }
                    case SECURED: {
                        ArrayList<AclMethod> allMethods = new ArrayList<AclMethod>();
                        if (StringUtils.isNotBlank((String)entry.getOwner()) && entry.getOwner().equals(username)) {
                            allMethods.add(AclMethod.GRANT);
                        }
                        ArrayList userMethods = entry.getUsers() != null && entry.getUsers().containsKey(username) ? entry.getUsers().get(username) : new ArrayList();
                        ArrayList roleMethods = new ArrayList();
                        for (String role : roles) {
                            ArrayList r = entry.getRoles() != null && entry.getRoles().containsKey(role) ? entry.getRoles().get(role) : new ArrayList();
                            roleMethods.addAll(r);
                        }
                        allMethods.addAll(userMethods);
                        allMethods.addAll(roleMethods);
                        if (allMethods.size() == 0) {
                            method = AclMethod.NONE;
                            break;
                        }
                        method = AclMethod.max(allMethods);
                        break;
                    }
                    default: {
                        method = AclMethod.WRITE;
                        break;
                    }
                }
            } else {
                FileObject resource = this.repoRoot.resolveFile(path);
                if (resource.getParent() == null) {
                    method = AclMethod.NONE;
                } else {
                    if (resource.equals(this.repoRoot)) {
                        return this.getAllAcls(this.rootMethod);
                    }
                    FileObject parent = resource.getParent();
                    String parentPath = this.repoRoot.getName().getRelativeName(parent.getName());
                    List<AclMethod> parentMethods = this.getMethods(parentPath, username, roles);
                    method = AclMethod.max(parentMethods);
                }
            }
            return this.getAllAcls(method);
        }
        catch (Exception e) {
            logger.error("Cannot get methods for: " + path, (Throwable)e);
            ArrayList<AclMethod> noMethod = new ArrayList<AclMethod>();
            noMethod.add(AclMethod.NONE);
            return noMethod;
        }
    }

    private List<AclMethod> getAllAcls(AclMethod maxMethod) {
        ArrayList<AclMethod> methods = new ArrayList<AclMethod>();
        if (maxMethod != null) {
            for (AclMethod m : AclMethod.values()) {
                if (m.ordinal() <= 0 || m.ordinal() > maxMethod.ordinal()) continue;
                methods.add(m);
            }
        }
        return methods;
    }

    public void addEntry(String path, AclEntry entry) {
        try {
            if (entry != null) {
                this.acl.put(path, entry);
                this.writeAcl(path, entry);
            }
        }
        catch (Exception e) {
            logger.error("Cannot add entry for resource: " + path, (Throwable)e);
        }
    }

    public AclEntry getEntry(String path) {
        return this.acl.containsKey(path) ? this.acl.get(path) : null;
    }

    public boolean canRead(String path, String username, List<String> roles) {
        if (path == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(path, username, roles);
        return acls.contains((Object)AclMethod.READ);
    }

    public boolean canWrite(String path, String username, List<String> roles) {
        if (path == null) {
            return false;
        }
        List<AclMethod> acls = this.getMethods(path, username, roles);
        return acls.contains((Object)AclMethod.WRITE);
    }

    public boolean canGrant(String path, String username, List<String> roles) {
        List<AclMethod> acls = this.getMethods(path, username, roles);
        return acls.contains((Object)AclMethod.GRANT);
    }

    private void readAclTree(String path) {
        try {
            FileObject resource = this.repoRoot.resolveFile(path);
            FileObject folder = resource.getType().equals(FileType.FOLDER) ? resource : resource.getParent();
            FileObject jsonFile = this.getAccessFile(path);
            if (jsonFile.exists() && jsonFile.isReadable()) {
                Map<String, AclEntry> folderAclMap = this.deserialize(jsonFile);
                TreeMap<String, AclEntry> aclMap = new TreeMap<String, AclEntry>();
                for (String key : folderAclMap.keySet()) {
                    AclEntry entry = folderAclMap.get(key);
                    FileName fn = folder.resolveFile(key).getName();
                    String childPath = this.repoRoot.getName().getRelativeName(fn);
                    aclMap.put(childPath, entry);
                }
                this.acl.putAll(aclMap);
            }
            for (FileObject file : folder.getChildren()) {
                if (!file.getType().equals(FileType.FOLDER)) continue;
                String childPath = this.getPath(file);
                this.readAclTree(childPath);
            }
        }
        catch (Exception e) {
            logger.error("Error while reading ACL files at path: " + path, (Throwable)e);
        }
    }

    private void writeAcl(String path, AclEntry entry) throws Exception {
        FileObject accessFile = this.getAccessFile(path);
        Map<String, AclEntry> map = this.deserialize(accessFile);
        FileObject f = this.repoRoot.resolveFile(path);
        String relativeKey = accessFile.getParent().getName().getRelativeName(f.getName());
        map.put(relativeKey, entry);
        this.serialize(accessFile, map);
    }

    private void serialize(FileObject accessFile, Map<String, AclEntry> map) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            accessFile.delete();
            mapper.writeValue(accessFile.getContent().getOutputStream(), map);
        }
        catch (Exception e) {
            logger.error("Error writing data to file", (Throwable)e);
        }
    }

    private Map<String, AclEntry> deserialize(FileObject accessFile) {
        ObjectMapper mapper = new ObjectMapper();
        Map<String, AclEntry> acl = new TreeMap<String, AclEntry>();
        try {
            if (accessFile != null && accessFile.exists()) {
                InputStreamReader reader = new InputStreamReader(accessFile.getContent().getInputStream());
                BufferedReader br = new BufferedReader(reader);
                acl = (Map)mapper.readValue((Reader)br, TypeFactory.mapType(HashMap.class, String.class, AclEntry.class));
            }
        }
        catch (Exception e) {
            logger.error("Error reading the json file:" + accessFile, (Throwable)e);
        }
        return acl;
    }

    public List<String> getAdminRoles() {
        return this.adminRoles;
    }

    private boolean isAdminRole(String role) {
        return this.adminRoles.contains(role);
    }

    private boolean isAdminRole(List<String> roles) {
        for (String role : roles) {
            if (!this.isAdminRole(role)) continue;
            return true;
        }
        return false;
    }

    private String getPath(FileObject resource) throws FileSystemException {
        return this.repoRoot.getName().getRelativeName(resource.getName());
    }

    private FileObject getAccessFile(String path) {
        FileObject accessFile = null;
        try {
            FileObject resource = this.repoRoot.resolveFile(path);
            if (resource != null && resource.exists()) {
                FileObject jsonFile = null;
                jsonFile = resource.getType().equals(FileType.FOLDER) ? resource.resolveFile(SAIKUACCESS_FILE, NameScope.FILE_SYSTEM) : resource.getParent().resolveFile(SAIKUACCESS_FILE, NameScope.FILE_SYSTEM);
                if (jsonFile != null && jsonFile.isWriteable()) {
                    accessFile = jsonFile;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error getting hold of the access file for " + path, (Throwable)e);
        }
        return accessFile;
    }
}

