/*
 * $RCSfile: HighlightScanner.flex,v $
 * 
 * created by sks on 19.11.2002
 *
 * $Revision: 1.30 $
 *
 * $Date: 2010/12/20 10:28:18 $
 *
 * copyright:
 * Werum Software & Systems AG
 * Wulf-Werum-Strasse 3
 * 21337 Lueneburg
 *
 * $Log: HighlightScanner.flex,v $
 */


/*--------------------------------
 * Scanner specification
 *-------------------------------- */


/*
 * Java preamble
 */
package de.statspez.pleditor.generator.parser.speclanguage.ui;

%%

%class HighlightScanner
%public
%cupsym SyntaxSegment
%unicode
%char

%{
   /**
    * Startzeichen einer Zeichenkette oder eines Kommentars.
    **/
   private int textSegmentStart;

   private boolean eofReached = false;

   public boolean isEofReached()
   {
      return this.eofReached;
   }

   /**
    * Return a symbol that represents the specified type.
    * The value of the symbol is undefined.
    **/
   private SyntaxSegment symbol(int type)
   {
      return new SyntaxSegment(type, yychar, yychar + yylength() - 1);
   }


   /**
    * Return a symbol that represents the specified type.
    * The value of the symbol is undefined.
    **/
   private SyntaxSegment textSegmentSymbol(int type)
   {
      return new SyntaxSegment(type, textSegmentStart, yychar);
   }

%}



/* 
 * JLex definitions: 
 */

%function next_segment
%type SyntaxSegment
%char

zeilenende      = \r | \n | \r\n
string_zeichen  = [^\r\n\'\\]
white_space     = {zeilenende} | [ \t\f]

ziffer  = [0-9]
/* zeichen = [a-z] | [A-Z] */
zeichen = [:letter:]

bezeichner = ({zeichen} | [_]) ({zeichen} | {ziffer} | [_])*
ganzzahl   = {ziffer} {ziffer}*
zahl       = {ganzzahl} ("." {ganzzahl}+)?


%state ZEICHENKETTE, KOMMENTAR


%%

/*
 * regular expressions and actions
 */

/* Terminal Symbols */

// keywords
<YYINITIAL>
{
   "ABBRUCH"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "ABLAUF"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "ALLE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "AUS"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "BIS"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "DANN"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "DATUMSWERT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "EIGENSCHAFT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "ENDE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "FALSCH"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "FELD"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "WERT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "FEHLER"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }
   
   "GILT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "FUER"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "FUNKTION"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "GIB"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "HAT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "IST"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "JEDES"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MATERIAL"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MIT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "PRUEFE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "REIHE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "RUECKGABE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "THEMENBEREICH"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "SCHRITTWEITE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "SOLANGE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "SONST"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "TYP"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "VAR"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "VON"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "ANLEGEN"
   {
 		return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "LOESCHEN"
   {
 		return symbol(SyntaxSegment.TYPE_KEYWORD);
   }
   
   "SATZ"
   {
       return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "WAHR"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "WENN"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "WIEDERHOLE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "LEER"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "KOMMAZAHL"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "ZEICHENKETTE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "KATEGORIE"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "DATUM"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "ZEIT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "GANZZAHL"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "WAHRHEITSWERT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "ANZAHL"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "INDEX"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MAPPEN"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "NACH"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "EXISTIERT"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MINDESTENS"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "GENAU"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "HOECHSTENS"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "IDENTISCH"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MIN"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MAX"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "SUMME"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MITTEL"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "MEDIAN"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "VARIANZ"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "STABW"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }

   "GLOBAL"
   {
      return symbol(SyntaxSegment.TYPE_KEYWORD);
   }
}

// operators
<YYINITIAL>
{
   "*"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   "/"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   "+"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   "-"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   "="
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }


   "<"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   ">"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   "<="
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   ">="
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   "/="
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_SYMBOL);
   }

   "IN"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_KEYWORD);
   }

   "UND"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_KEYWORD);
   }

   "ODER"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_KEYWORD);
   }

   "NICHT"
   {
      return symbol(SyntaxSegment.TYPE_OPERATOR_KEYWORD);
   }
}


// misc. terminal syms
<YYINITIAL>
{
   "#"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }
   
   ","
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   ";"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   ".."
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "--"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "-+"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "+-"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "++"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   ":="
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "("
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   ")"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }


   "["
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "]"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "{"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "}"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "&"
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }

   "."
   {
      return symbol(SyntaxSegment.TYPE_MISC_SYMBOL);
   }
}


/* non-terminals */
<YYINITIAL>
{
   {bezeichner}
   { 
      //return symbol(SyntaxSegment.TYPE_IDENTIFIER); 
   }

   {ganzzahl}
   {
      return symbol(SyntaxSegment.TYPE_NUMBER);
   }

   {zahl}
   {
      return symbol(SyntaxSegment.TYPE_NUMBER);
   }
   
   {white_space}
   {
      //trace("ignore <white_space>");
   }

   \'
   {
      textSegmentStart = yychar;
      yybegin(ZEICHENKETTE);
   }

   \"
   {
      textSegmentStart = yychar;
      yybegin(KOMMENTAR);
   }
}


<ZEICHENKETTE> 
{
   \'                      
   { 
      yybegin(YYINITIAL); 
      return textSegmentSymbol(SyntaxSegment.TYPE_STRING);
   }

   {string_zeichen}+       
   { 
   }

   \\.                     
   { 
   }

   {zeilenende}
   { 
      yybegin(YYINITIAL); 
      return textSegmentSymbol(SyntaxSegment.TYPE_STRING);
   }
   
   <<EOF>>
   { 
      this.eofReached = true;
      return textSegmentSymbol(SyntaxSegment.TYPE_STRING);
   }
}

<KOMMENTAR> 
{
   \"                      
   { 
      yybegin(YYINITIAL); 
      return textSegmentSymbol(SyntaxSegment.TYPE_COMMENT);
   }

   .       
   { 
   }

   <<EOF>>
   { 
      this.eofReached = true;
      return textSegmentSymbol(SyntaxSegment.TYPE_COMMENT);
   }
}

/* error fallback */
. | \n
{
   // ignore
}
   
<<EOF>>
{
   this.eofReached = true;
   return null;
}
