/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractBooleanCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.GenericIterCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

public class IifFunDef
extends FunDefBase {
    static final FunDefBase STRING_INSTANCE = new FunDefBase("IIf", "Returns one of two string values determined by a logical test.", "fSbSS"){

        @Override
        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            final BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
            final StringCalc calc1 = compiler.compileString(call.getArg(1));
            final StringCalc calc2 = compiler.compileString(call.getArg(2));
            return new AbstractStringCalc(call, new Calc[]{booleanCalc, calc1, calc2}){

                @Override
                public String evaluateString(Evaluator evaluator) {
                    boolean b = booleanCalc.evaluateBoolean(evaluator);
                    StringCalc calc = b ? calc1 : calc2;
                    return calc.evaluateString(evaluator);
                }
            };
        }
    };
    static final FunDefBase NUMERIC_INSTANCE = new IifFunDef("IIf", "Returns one of two numeric values determined by a logical test.", "fnbnn"){

        @Override
        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            final BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
            final Calc calc1 = compiler.compileScalar(call.getArg(1), true);
            final Calc calc2 = compiler.compileScalar(call.getArg(2), true);
            return new GenericCalc(call){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    boolean b = booleanCalc.evaluateBoolean(evaluator);
                    Calc calc = b ? calc1 : calc2;
                    return calc.evaluate(evaluator);
                }

                @Override
                public Calc[] getCalcs() {
                    return new Calc[]{booleanCalc, calc1, calc2};
                }
            };
        }
    };
    static final FunDefBase TUPLE_INSTANCE = new IifFunDef("IIf", "Returns one of two tuples determined by a logical test.", "ftbtt"){

        @Override
        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            final BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
            final TupleCalc calc1 = compiler.compileTuple(call.getArg(1));
            final TupleCalc calc2 = compiler.compileTuple(call.getArg(2));
            return new GenericCalc(call){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    boolean b = booleanCalc.evaluateBoolean(evaluator);
                    Calc calc = b ? calc1 : calc2;
                    return calc.evaluate(evaluator);
                }

                @Override
                public Calc[] getCalcs() {
                    return new Calc[]{booleanCalc, calc1, calc2};
                }
            };
        }
    };
    static final FunDefBase BOOLEAN_INSTANCE = new FunDefBase("IIf", "Returns boolean determined by a logical test.", "fbbbb"){

        @Override
        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            final BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
            final BooleanCalc booleanCalc1 = compiler.compileBoolean(call.getArg(1));
            final BooleanCalc booleanCalc2 = compiler.compileBoolean(call.getArg(2));
            Calc[] calcs = new Calc[]{booleanCalc, booleanCalc1, booleanCalc2};
            return new AbstractBooleanCalc(call, calcs){

                @Override
                public boolean evaluateBoolean(Evaluator evaluator) {
                    boolean condition = booleanCalc.evaluateBoolean(evaluator);
                    if (condition) {
                        return booleanCalc1.evaluateBoolean(evaluator);
                    }
                    return booleanCalc2.evaluateBoolean(evaluator);
                }
            };
        }
    };
    static final IifFunDef MEMBER_INSTANCE = new IifFunDef("IIf", "Returns one of two member values determined by a logical test.", "fmbmm");
    static final IifFunDef LEVEL_INSTANCE = new IifFunDef("IIf", "Returns one of two level values determined by a logical test.", "flbll");
    static final IifFunDef HIERARCHY_INSTANCE = new IifFunDef("IIf", "Returns one of two hierarchy values determined by a logical test.", "fhbhh");
    static final IifFunDef DIMENSION_INSTANCE = new IifFunDef("IIf", "Returns one of two dimension values determined by a logical test.", "fdbdd");
    static final IifFunDef SET_INSTANCE = new IifFunDef("IIf", "Returns one of two set values determined by a logical test.", "fxbxx");

    protected IifFunDef(String name, String description, String flags) {
        super(name, description, flags);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        switch (this.returnCategory) {
            case 7: {
                return new NumericType();
            }
            case 9: {
                return new StringType();
            }
            case 5: {
                return new BooleanType();
            }
        }
        return TypeUtil.computeCommonType(true, args[1].getType(), args[2].getType());
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final BooleanCalc booleanCalc = compiler.compileBoolean(call.getArg(0));
        final Calc calc1 = compiler.compileAs(call.getArg(1), call.getType(), ResultStyle.ANY_LIST);
        final Calc calc2 = compiler.compileAs(call.getArg(2), call.getType(), ResultStyle.ANY_LIST);
        if (call.getType() instanceof SetType) {
            return new GenericIterCalc(call){

                @Override
                public Object evaluate(Evaluator evaluator) {
                    boolean b = booleanCalc.evaluateBoolean(evaluator);
                    Calc calc = b ? calc1 : calc2;
                    return calc.evaluate(evaluator);
                }

                @Override
                public Calc[] getCalcs() {
                    return new Calc[]{booleanCalc, calc1, calc2};
                }
            };
        }
        return new GenericCalc(call){

            @Override
            public Object evaluate(Evaluator evaluator) {
                boolean b = booleanCalc.evaluateBoolean(evaluator);
                Calc calc = b ? calc1 : calc2;
                return calc.evaluate(evaluator);
            }

            @Override
            public Calc[] getCalcs() {
                return new Calc[]{booleanCalc, calc1, calc2};
            }
        };
    }
}

