/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractTupleCursor;
import mondrian.calc.impl.AbstractTupleIterable;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.calc.impl.ListTupleList;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapEvaluator;
import mondrian.util.CartesianProductList;

public class CrossJoinFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Crossjoin", "Crossjoin(<Set1>, <Set2>)", "Returns the cross product of two sets.", new String[]{"fxxx"}, CrossJoinFunDef.class);
    static final StarCrossJoinResolver StarResolver = new StarCrossJoinResolver();
    private static int counterTag = 0;
    private final int ctag = counterTag++;

    public CrossJoinFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        ArrayList<MemberType> list = new ArrayList<MemberType>();
        for (Exp arg : args) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            if (this.getName().equals("*")) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            throw Util.newInternal("arg to crossjoin must be a set");
        }
        Type[] types = list.toArray(new MemberType[list.size()]);
        TupleType.checkHierarchies((MemberType[])types);
        TupleType tupleType = new TupleType(types);
        return new SetType(tupleType);
    }

    private static void addTypes(Type type, List<MemberType> list) {
        if (type instanceof SetType) {
            SetType setType = (SetType)type;
            CrossJoinFunDef.addTypes(setType.getElementType(), list);
        } else if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (Type elementType : tupleType.elementTypes) {
                CrossJoinFunDef.addTypes(elementType, list);
            }
        } else if (type instanceof MemberType) {
            list.add((MemberType)type);
        } else {
            throw Util.newInternal("Unexpected type: " + type);
        }
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        for (ResultStyle r : compiler.getAcceptableResultStyles()) {
            switch (r) {
                case ITERABLE: 
                case ANY: {
                    return this.compileCallIterable(call, compiler);
                }
                case LIST: {
                    return this.compileCallImmutableList(call, compiler);
                }
                case MUTABLE_LIST: {
                    return this.compileCallMutableList(call, compiler);
                }
            }
        }
        throw ResultStyleException.generate(ResultStyle.ITERABLE_LIST_MUTABLELIST_ANY, compiler.getAcceptableResultStyles());
    }

    protected IterCalc compileCallIterable(ResolvedFunCall call, ExpCompiler compiler) {
        Calc calc1 = this.toIter(compiler, call.getArg(0));
        Calc calc2 = this.toIter(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{calc1, calc2};
        CrossJoinFunDef.checkIterListResultStyles(calc1);
        CrossJoinFunDef.checkIterListResultStyles(calc2);
        return new CrossJoinIterCalc(call, calcs);
    }

    private Calc toIter(ExpCompiler compiler, Exp exp) {
        Type type = exp.getType();
        if (type instanceof SetType) {
            return compiler.compileAs(exp, null, ResultStyle.ITERABLE_LIST_MUTABLELIST);
        }
        return new SetFunDef.ExprIterCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler, ResultStyle.ITERABLE_LIST_MUTABLELIST);
    }

    protected ListCalc compileCallImmutableList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc1 = this.toList(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toList(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{listCalc1, listCalc2};
        CrossJoinFunDef.checkListResultStyles(listCalc1);
        CrossJoinFunDef.checkListResultStyles(listCalc2);
        return new ImmutableListCalc(call, calcs);
    }

    private ListCalc toList(ExpCompiler compiler, Exp exp) {
        Type type = exp.getType();
        if (type instanceof SetType) {
            Calc calc = compiler.compileAs(exp, null, ResultStyle.LIST_MUTABLELIST);
            if (calc == null) {
                return compiler.compileList(exp, false);
            }
            return (ListCalc)calc;
        }
        return new SetFunDef.SetListCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler, ResultStyle.LIST_MUTABLELIST);
    }

    protected ListCalc compileCallMutableList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc1 = this.toList(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toList(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{listCalc1, listCalc2};
        CrossJoinFunDef.checkListResultStyles(listCalc1);
        CrossJoinFunDef.checkListResultStyles(listCalc2);
        return new MutableListCalc(call, calcs);
    }

    protected TupleList nonEmptyOptimizeList(Evaluator evaluator, TupleList list, ResolvedFunCall call) {
        int opSize = MondrianProperties.instance().CrossJoinOptimizerSize.get();
        if (list.isEmpty()) {
            return list;
        }
        try {
            Object o = list.get(0);
            if (o instanceof Member && ((Member)o).getDimension().isHighCardinality()) {
                return list;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            return TupleCollections.emptyList(list.getArity());
        }
        int size = list.size();
        if (size > opSize && evaluator.isNonEmpty()) {
            int missCount = evaluator.getMissCount();
            size = (list = this.nonEmptyList(evaluator, list, call)).size();
            if (size == 0) {
                return TupleCollections.emptyList(list.getArity());
            }
            int missCount2 = evaluator.getMissCount();
            int puntMissCountListSize = 1000;
            if (missCount2 > missCount && size > 1000) {
                return TupleCollections.emptyList(list.getArity());
            }
        }
        return list;
    }

    public static TupleList mutableCrossJoin(TupleList list1, TupleList list2) {
        return CrossJoinFunDef.mutableCrossJoin(Arrays.asList(list1, list2));
    }

    public static TupleList mutableCrossJoin(List<TupleList> lists) {
        long size = 1L;
        int arity = 0;
        for (TupleList list : lists) {
            size *= (long)list.size();
            arity += list.getArity();
        }
        if (size == 0L) {
            return TupleCollections.emptyList(arity);
        }
        Util.checkCJResultLimit(size);
        ArrayList<Member> result = new ArrayList<Member>((int)size * arity);
        Member[] partialArray = new Member[arity];
        List<Member> partial = Arrays.asList(partialArray);
        CrossJoinFunDef.cartesianProductRecurse(0, lists, partial, partialArray, 0, result);
        return new ListTupleList(arity, result);
    }

    private static void cartesianProductRecurse(int i, List<TupleList> lists, List<Member> partial, Member[] partialArray, int partialSize, List<Member> result) {
        TupleList tupleList = lists.get(i);
        int partialSizeNext = partialSize + tupleList.getArity();
        int iNext = i + 1;
        TupleCursor cursor = tupleList.tupleCursor();
        while (cursor.forward()) {
            cursor.currentToArray(partialArray, partialSize);
            if (i == lists.size() - 1) {
                result.addAll(partial);
                continue;
            }
            CrossJoinFunDef.cartesianProductRecurse(iNext, lists, partial, partialArray, partialSizeNext, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleList nonEmptyList(Evaluator evaluator, TupleList list, ResolvedFunCall call) {
        String measureSetKey;
        if (list.isEmpty()) {
            return list;
        }
        TupleList result = TupleCollections.createList(list.getArity(), list.size() + 2 >> 1);
        Query query = evaluator.getQuery();
        Set<Member> measureSet = Util.cast((Set)query.getEvalCache(measureSetKey = "MEASURE_SET-" + this.ctag));
        if (measureSet == null) {
            measureSet = new HashSet();
            Set<Member> queryMeasureSet = query.getMeasuresMembers();
            MeasureVisitor visitor = new MeasureVisitor(measureSet, call);
            for (Member m : queryMeasureSet) {
                if (m.isCalculated()) {
                    Exp exp = m.getExpression();
                    exp.accept(visitor);
                    continue;
                }
                measureSet.add(m);
            }
            Formula[] formula = query.getFormulas();
            if (formula != null) {
                for (Formula f : formula) {
                    f.accept(visitor);
                }
            }
            query.putEvalCache(measureSetKey, measureSet);
        }
        String allMemberListKey = "ALL_MEMBER_LIST-" + this.ctag;
        List<Member> allMemberList = Util.cast((List)query.getEvalCache(allMemberListKey));
        String nonAllMembersKey = "NON_ALL_MEMBERS-" + this.ctag;
        Member[][] nonAllMembers = (Member[][])query.getEvalCache(nonAllMembersKey);
        if (nonAllMembers == null) {
            Member em;
            Member[] evalMembers = (Member[])evaluator.getMembers().clone();
            List listMembers = (List)list.get(0);
            for (Member lm : listMembers) {
                Hierarchy h = lm.getHierarchy();
                for (int i = 0; i < evalMembers.length; ++i) {
                    em = evalMembers[i];
                    if (em == null || !h.equals(em.getHierarchy())) continue;
                    evalMembers[i] = null;
                }
            }
            List<Member> slicerMembers = null;
            if (evaluator instanceof RolapEvaluator) {
                RolapEvaluator rev = (RolapEvaluator)evaluator;
                slicerMembers = rev.getSlicerMembers();
            }
            HashMap mapOfSlicerMembers = new HashMap();
            if (slicerMembers != null) {
                for (Member slicerMember : slicerMembers) {
                    Hierarchy hierarchy = slicerMember.getHierarchy();
                    if (!mapOfSlicerMembers.containsKey(hierarchy)) {
                        mapOfSlicerMembers.put(hierarchy, new HashSet());
                    }
                    ((Set)mapOfSlicerMembers.get(hierarchy)).add(slicerMember);
                }
            }
            SchemaReader schemaReader = evaluator.getSchemaReader();
            allMemberList = new ArrayList<Member>();
            ArrayList<Member[]> nonAllMemberList = new ArrayList<Member[]>();
            Member[] arr$ = evalMembers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                boolean isSlicerMember;
                Member evalMember;
                em = evalMember = arr$[i$];
                boolean bl = isSlicerMember = slicerMembers != null && slicerMembers.contains(em);
                if (em == null || em.isMeasure()) continue;
                if (isSlicerMember && !em.isCalculated() || !isSlicerMember && em.isCalculated()) {
                    Set hierarchySlicerMembers;
                    if (!isSlicerMember || (hierarchySlicerMembers = (Set)mapOfSlicerMembers.get(em.getHierarchy())).size() <= 1) continue;
                    nonAllMemberList.add(hierarchySlicerMembers.toArray(new Member[hierarchySlicerMembers.size()]));
                    continue;
                }
                if (!isSlicerMember && em.isAll()) continue;
                Hierarchy h = em.getHierarchy();
                List<Member> rootMemberList = schemaReader.getHierarchyRootMembers(h);
                if (h.hasAll()) {
                    boolean found = false;
                    for (Member m : rootMemberList) {
                        if (!m.isAll()) continue;
                        allMemberList.add(m);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    System.out.println("CrossJoinFunDef.nonEmptyListNEW: ERROR");
                    continue;
                }
                Member[] rootMembers = rootMemberList.toArray(new Member[rootMemberList.size()]);
                nonAllMemberList.add(rootMembers);
            }
            nonAllMembers = (Member[][])nonAllMemberList.toArray((T[])new Member[nonAllMemberList.size()][]);
            query.putEvalCache(allMemberListKey, allMemberList);
            query.putEvalCache(nonAllMembersKey, nonAllMembers);
        }
        int savepoint = evaluator.savepoint();
        try {
            evaluator.setContext(allMemberList);
            TupleCursor cursor = list.tupleCursor();
            while (cursor.forward()) {
                cursor.setContext(evaluator);
                if (!CrossJoinFunDef.checkData(nonAllMembers, nonAllMembers.length - 1, measureSet, evaluator)) continue;
                result.addCurrent(cursor);
            }
            TupleList tupleList = result;
            return tupleList;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    private static boolean checkData(Member[][] nonAllMembers, int cnt, Set<Member> measureSet, Evaluator evaluator) {
        if (cnt < 0) {
            if (measureSet.isEmpty()) {
                Object value = evaluator.evaluateCurrent();
                return value != null && !(value instanceof Throwable);
            }
            boolean found = false;
            for (Member measure : measureSet) {
                evaluator.setContext(measure);
                Object value = evaluator.evaluateCurrent();
                if (value == null || value instanceof Throwable) continue;
                found = true;
            }
            return found;
        }
        boolean found = false;
        for (Member m : nonAllMembers[cnt]) {
            evaluator.setContext(m);
            if (!CrossJoinFunDef.checkData(nonAllMembers, cnt - 1, measureSet, evaluator)) continue;
            found = true;
        }
        return found;
    }

    private static class StarCrossJoinResolver
    extends MultiResolver {
        public StarCrossJoinResolver() {
            super("*", "<Set1> * <Set2>", "Returns the cross product of two sets.", new String[]{"ixxx", "ixmx", "ixxm", "ixmm"});
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (validator.requiresExpression()) {
                return null;
            }
            return super.resolve(args, validator, conversions);
        }

        @Override
        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new CrossJoinFunDef(dummyFunDef);
        }
    }

    private static class MeasureVisitor
    extends MdxVisitorImpl {
        private final Set<Member> queryMeasureSet;
        private final ResolvedFunCallFinder finder;
        private final Set<Member> activeMeasures = new HashSet<Member>();

        MeasureVisitor(Set<Member> queryMeasureSet, ResolvedFunCall crossJoinCall) {
            this.queryMeasureSet = queryMeasureSet;
            this.finder = new ResolvedFunCallFinder(crossJoinCall);
        }

        @Override
        public Object visit(ParameterExpr parameterExpr) {
            Object value;
            Parameter parameter = parameterExpr.getParameter();
            Type type = parameter.getType();
            if (type instanceof MemberType && (value = parameter.getValue()) instanceof Member) {
                Member member = (Member)value;
                this.process(member);
            }
            return null;
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            this.process(member);
            return null;
        }

        private void process(Member member) {
            if (member.isMeasure()) {
                if (member.isCalculated()) {
                    if (this.activeMeasures.add(member)) {
                        Exp exp = member.getExpression();
                        this.finder.found = false;
                        exp.accept(this.finder);
                        if (!this.finder.found) {
                            exp.accept(this);
                        }
                        this.activeMeasures.remove(member);
                    }
                } else {
                    this.queryMeasureSet.add(member);
                }
            }
        }
    }

    private static class ResolvedFunCallFinder
    extends MdxVisitorImpl {
        private final ResolvedFunCall call;
        public boolean found;
        private final Set<Member> activeMembers = new HashSet<Member>();

        public ResolvedFunCallFinder(ResolvedFunCall call) {
            this.call = call;
            this.found = false;
        }

        @Override
        public Object visit(ResolvedFunCall funCall) {
            if (funCall == this.call) {
                this.found = true;
            }
            return null;
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            if (member.isCalculated() && this.activeMembers.add(member)) {
                Exp memberExp = member.getExpression();
                memberExp.accept(this);
                this.activeMembers.remove(member);
            }
            return null;
        }
    }

    class MutableListCalc
    extends BaseListCalc {
        MutableListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected TupleList makeList(TupleList l1, TupleList l2) {
            int arity = l1.getArity() + l2.getArity();
            ArrayList<Member> members = new ArrayList<Member>(arity * l1.size() * l2.size());
            for (List ma1 : l1) {
                for (List ma2 : l2) {
                    members.addAll(ma1);
                    members.addAll(ma2);
                }
            }
            return new ListTupleList(arity, members);
        }
    }

    class ImmutableListCalc
    extends BaseListCalc {
        ImmutableListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected TupleList makeList(final TupleList l1, final TupleList l2) {
            final int arity = l1.getArity() + l2.getArity();
            return new DelegatingTupleList(arity, (List<List<Member>>)new AbstractList<List<Member>>(){
                final List<List<List<Member>>> lists;
                final Member[] members;
                final CartesianProductList cartesianProductList;
                {
                    this.lists = Arrays.asList(l1, l2);
                    this.members = new Member[arity];
                    this.cartesianProductList = new CartesianProductList(this.lists);
                }

                @Override
                public List<Member> get(int index) {
                    this.cartesianProductList.getIntoArray(index, this.members);
                    return Util.flatList(this.members);
                }

                @Override
                public int size() {
                    return this.cartesianProductList.size();
                }
            });
        }
    }

    abstract class BaseListCalc
    extends AbstractListCalc {
        protected BaseListCalc(ResolvedFunCall call, Calc[] calcs, boolean mutable) {
            super(call, calcs, mutable);
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (TupleList)nativeEvaluator.execute(ResultStyle.LIST);
            }
            Calc[] calcs = this.getCalcs();
            ListCalc listCalc1 = (ListCalc)calcs[0];
            ListCalc listCalc2 = (ListCalc)calcs[1];
            TupleList l1 = listCalc1.evaluateList(evaluator);
            TupleList l2 = listCalc2.evaluateList(evaluator);
            if ((l1 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l1, call)).isEmpty()) {
                return TupleCollections.emptyList(l1.getArity() + l2.getArity());
            }
            if ((l2 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l2, call)).isEmpty()) {
                return TupleCollections.emptyList(l1.getArity() + l2.getArity());
            }
            return this.makeList(l1, l2);
        }

        protected abstract TupleList makeList(TupleList var1, TupleList var2);
    }

    class CrossJoinIterCalc
    extends AbstractIterCalc {
        CrossJoinIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        public TupleIterable evaluateIterable(Evaluator evaluator) {
            TupleIterable o2;
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (TupleIterable)nativeEvaluator.execute(ResultStyle.ITERABLE);
            }
            Calc[] calcs = this.getCalcs();
            IterCalc calc1 = (IterCalc)calcs[0];
            IterCalc calc2 = (IterCalc)calcs[1];
            TupleIterable o1 = calc1.evaluateIterable(evaluator);
            if (o1 instanceof TupleList) {
                TupleList l1 = (TupleList)o1;
                if ((l1 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l1, call)).isEmpty()) {
                    return TupleCollections.emptyList(this.getType().getArity());
                }
                o1 = l1;
            }
            if ((o2 = calc2.evaluateIterable(evaluator)) instanceof TupleList) {
                TupleList l2 = (TupleList)o2;
                if ((l2 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l2, call)).isEmpty()) {
                    return TupleCollections.emptyList(this.getType().getArity());
                }
                o2 = l2;
            }
            return this.makeIterable(o1, o2);
        }

        protected TupleIterable makeIterable(final TupleIterable it1, final TupleIterable it2) {
            return new AbstractTupleIterable(it1.getArity() + it2.getArity()){

                @Override
                public TupleCursor tupleCursor() {
                    return new AbstractTupleCursor(this.getArity()){
                        final TupleCursor i1;
                        final int arity1;
                        TupleCursor i2;
                        final Member[] members;
                        {
                            this.i1 = it1.tupleCursor();
                            this.arity1 = this.i1.getArity();
                            this.i2 = TupleCollections.emptyList(1).tupleCursor();
                            this.members = new Member[this.arity];
                        }

                        @Override
                        public boolean forward() {
                            if (this.i2.forward()) {
                                return true;
                            }
                            while (this.i1.forward()) {
                                this.i2 = it2.tupleCursor();
                                if (!this.i2.forward()) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public List<Member> current() {
                            this.i1.currentToArray(this.members, 0);
                            this.i2.currentToArray(this.members, this.arity1);
                            return Util.flatList(this.members);
                        }

                        @Override
                        public Member member(int column) {
                            if (column < this.arity1) {
                                return this.i1.member(column);
                            }
                            return this.i2.member(column - this.arity1);
                        }

                        @Override
                        public void setContext(Evaluator evaluator) {
                            this.i1.setContext(evaluator);
                            this.i2.setContext(evaluator);
                        }

                        @Override
                        public void currentToArray(Member[] members, int offset) {
                            this.i1.currentToArray(members, offset);
                            this.i2.currentToArray(members, offset + this.arity1);
                        }
                    };
                }
            };
        }
    }
}

