/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.util.Date;
import java.util.GregorianCalendar;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class YesterdayFunction
implements Function {
    private static final long serialVersionUID = -456933388664083206L;

    @Override
    public String getCanonicalName() {
        return "YESTERDAY";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Date yesterday = YesterdayFunction.yesterday(context);
        Date date = DateUtil.normalizeDate(yesterday, (Type)DateTimeType.DATE_TYPE);
        return new TypeValuePair(DateTimeType.DATE_TYPE, date);
    }

    private static Date yesterday(FormulaContext context) {
        LocalizationContext localizationContext = context.getLocalizationContext();
        GregorianCalendar gc = new GregorianCalendar(localizationContext.getTimeZone(), localizationContext.getLocale());
        gc.setTime(context.getCurrentDate());
        gc.set(14, 0);
        gc.add(5, -1);
        return gc.getTime();
    }
}

