/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.IOException;
import java.io.Reader;

public class MemoryStringReader
extends Reader {
    private char[] backend;
    private int offset;
    private int length;

    public MemoryStringReader(char[] backend, int offset, int length) {
        this.backend = (char[])backend.clone();
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int read(char[] chars, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (this.length == 0) {
            return -1;
        }
        int readLength = Math.min(length, this.length);
        System.arraycopy(this.backend, this.offset, chars, offset, readLength);
        this.offset += readLength;
        this.length -= readLength;
        return readLength;
    }

    @Override
    public void close() throws IOException {
    }
}

