/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rssinput;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.rssinput.RssInput;
import org.w3c.dom.Node;

public class RssInputField
implements Cloneable {
    private static Class<?> PKG = RssInput.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final int COLUMN_TITLE = 0;
    public static final int COLUMN_LINK = 1;
    public static final int COLUMN_DESCRIPTION_AS_TEXT = 2;
    public static final int COLUMN_DESCRIPTION_AS_HTML = 3;
    public static final int COLUMN_COMMENTS = 4;
    public static final int COLUMN_GUID = 5;
    public static final int COLUMN_PUB_DATE = 6;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"RssInput.Field.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Field.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Field.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Field.TrimType.Both", (String[])new String[0])};
    public static final String[] ColumnCode = new String[]{"title", "link", "descriptiontext", "descriptionhtml", "comments", "guid", "pubdate"};
    public static final String[] ColumnDesc = new String[]{BaseMessages.getString(PKG, (String)"RssInput.Column.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Column.Link", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Column.DescriptionAsText", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Column.DescriptionAsHtml", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Column.Comments", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Column.Guid", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RssInput.Column.PubDate", (String[])new String[0])};
    private String name;
    private int column;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;

    public RssInputField(String fieldname) {
        this.name = fieldname;
        this.column = 0;
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public RssInputField() {
        this("");
    }

    public String getXML() {
        String retval = "";
        retval = retval + "      <field>" + Const.CR;
        retval = retval + "        " + XMLHandler.addTagValue((String)"name", (String)this.getName());
        retval = retval + "        " + XMLHandler.addTagValue((String)"column", (String)this.getColumnCode());
        retval = retval + "        " + XMLHandler.addTagValue((String)"type", (String)this.getTypeDesc());
        retval = retval + "        " + XMLHandler.addTagValue((String)"format", (String)this.getFormat());
        retval = retval + "        " + XMLHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol());
        retval = retval + "        " + XMLHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol());
        retval = retval + "        " + XMLHandler.addTagValue((String)"group", (String)this.getGroupSymbol());
        retval = retval + "        " + XMLHandler.addTagValue((String)"length", (int)this.getLength());
        retval = retval + "        " + XMLHandler.addTagValue((String)"precision", (int)this.getPrecision());
        retval = retval + "        " + XMLHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode());
        retval = retval + "        " + XMLHandler.addTagValue((String)"repeat", (boolean)this.isRepeated());
        retval = retval + "      </field>" + Const.CR;
        return retval;
    }

    public RssInputField(Node fnode) throws KettleValueException {
        this.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
        this.setColumn(RssInputField.getColumnByCode(XMLHandler.getTagValue((Node)fnode, (String)"column")));
        this.setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(RssInputField.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getColumnByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ColumnCode.length; ++i) {
            if (!ColumnCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getColumnByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ColumnDesc.length; ++i) {
            if (!ColumnDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getColumnDesc(int i) {
        if (i < 0 || i >= ColumnDesc.length) {
            return ColumnDesc[0];
        }
        return ColumnDesc[i];
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getColumnCode(int i) {
        if (i < 0 || i >= ColumnCode.length) {
            return ColumnCode[0];
        }
        return ColumnCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            RssInputField retval = (RssInputField)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMeta.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public int getColumn() {
        return this.column;
    }

    public String getTrimTypeCode() {
        return RssInputField.getTrimTypeCode(this.trimtype);
    }

    public String getColumnCode() {
        return RssInputField.getColumnCode(this.column);
    }

    public String getTrimTypeDesc() {
        return RssInputField.getTrimTypeDesc(this.trimtype);
    }

    public String getColumnDesc() {
        return RssInputField.getColumnDesc(this.column);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public void guess() {
    }
}

