/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.nullif;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.nullif.NullIfData;
import org.pentaho.di.trans.steps.nullif.NullIfMeta;

public class NullIf
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = NullIfMeta.class;
    private NullIfMeta meta;
    private NullIfData data;

    public NullIf(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        int i;
        this.meta = (NullIfMeta)smi;
        this.data = (NullIfData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.data.keynr = new int[this.meta.getFieldValue().length];
            this.data.nullValue = new Object[this.meta.getFieldValue().length];
            this.data.nullValueMeta = new ValueMetaInterface[this.meta.getFieldValue().length];
            for (i = 0; i < this.meta.getFieldValue().length; ++i) {
                this.data.keynr[i] = this.data.outputRowMeta.indexOfValue(this.meta.getFieldName()[i]);
                if (this.data.keynr[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"NullIf.Log.CouldNotFindFieldInRow", (String[])new String[]{this.meta.getFieldName()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.nullValueMeta[i] = this.data.outputRowMeta.getValueMeta(this.data.keynr[i]);
                this.data.nullValue[i] = this.data.nullValueMeta[i].convertData((ValueMetaInterface)new ValueMeta(null, 2), (Object)this.meta.getFieldValue()[i]);
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"NullIf.Log.ConvertFieldValuesToNullForRow", (String[])new String[0]) + this.data.outputRowMeta.getString(r));
        }
        for (i = 0; i < this.meta.getFieldValue().length; ++i) {
            Object field = r[this.data.keynr[i]];
            if (field == null || this.data.nullValueMeta[i].compare(field, this.data.nullValue[i]) != 0) continue;
            r[this.data.keynr[i]] = null;
        }
        this.putRow(this.data.outputRowMeta, r);
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NullIfMeta)smi;
        this.data = (NullIfData)sdi;
        super.dispose(smi, sdi);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NullIfMeta)smi;
        this.data = (NullIfData)sdi;
        return super.init(smi, sdi);
    }
}

