/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelwriter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepData;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepField;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepMeta;

public class ExcelWriterStep
extends BaseStep
implements StepInterface {
    public static final String STREAMER_FORCE_RECALC_PROP_NAME = "KETTLE_EXCEL_WRITER_STREAMER_FORCE_RECALCULATE";
    private ExcelWriterStepData data;
    private ExcelWriterStepMeta meta;
    private static Class<?> PKG = ExcelWriterStepMeta.class;

    public ExcelWriterStep(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExcelWriterStepMeta)smi;
        this.data = (ExcelWriterStepData)sdi;
        Object[] r = this.getRow();
        if (this.first && r != null) {
            int i;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            if (r != null && this.meta.isDoNotOpenNewFileInit()) {
                this.data.firstFileOpened = true;
                this.prepareNextOutputFile();
            }
            this.data.fieldnrs = new int[this.meta.getOutputFields().length];
            for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.fieldnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getOutputFields()[i].getName());
                if (this.data.fieldnrs[i] >= 0) continue;
                this.logError("Field [" + this.meta.getOutputFields()[i].getName() + "] couldn't be found in the input stream!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.commentfieldnrs = new int[this.meta.getOutputFields().length];
            for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.commentfieldnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getOutputFields()[i].getCommentField());
                if (this.data.commentfieldnrs[i] >= 0 || Const.isEmpty((String)this.meta.getOutputFields()[i].getCommentField())) continue;
                this.logError("Comment Field [" + this.meta.getOutputFields()[i].getCommentField() + "] couldn't be found in the input stream!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.commentauthorfieldnrs = new int[this.meta.getOutputFields().length];
            for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.commentauthorfieldnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getOutputFields()[i].getCommentAuthorField());
                if (this.data.commentauthorfieldnrs[i] >= 0 || Const.isEmpty((String)this.meta.getOutputFields()[i].getCommentAuthorField())) continue;
                this.logError("Comment Author Field [" + this.meta.getOutputFields()[i].getCommentAuthorField() + "] couldn't be found in the input stream!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.linkfieldnrs = new int[this.meta.getOutputFields().length];
            for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.linkfieldnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getOutputFields()[i].getHyperlinkField());
                if (this.data.linkfieldnrs[i] >= 0 || Const.isEmpty((String)this.meta.getOutputFields()[i].getHyperlinkField())) continue;
                this.logError("Link Field [" + this.meta.getOutputFields()[i].getHyperlinkField() + "] couldn't be found in the input stream!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        if (r != null) {
            if (!this.meta.isAppendLines() && this.meta.getSplitEvery() > 0 && this.data.datalines > 0 && this.data.datalines % this.meta.getSplitEvery() == 0) {
                this.closeOutputFile();
                this.prepareNextOutputFile();
            }
            this.writeNextLine(r);
            this.incrementLinesOutput();
            ++this.data.datalines;
            this.putRow(this.data.outputRowMeta, r);
            if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
                this.logBasic("Linenr " + this.getLinesOutput());
            }
            return true;
        }
        if (this.data.wb != null) {
            this.closeOutputFile();
        }
        this.setOutputDone();
        this.clearWorkbookMem();
        return false;
    }

    private void clearWorkbookMem() {
        this.data.file = null;
        this.data.sheet = null;
        this.data.wb = null;
        this.data.clearStyleCache(0);
    }

    private void closeOutputFile() throws KettleException {
        try {
            if (this.meta.isFooterEnabled()) {
                this.writeHeader();
            }
            if (this.meta.isAutoSizeColums()) {
                int i;
                if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                    for (i = 0; i < this.data.inputRowMeta.size(); ++i) {
                        this.data.sheet.autoSizeColumn(i + this.data.startingCol);
                    }
                } else {
                    for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                        this.data.sheet.autoSizeColumn(i + this.data.startingCol);
                    }
                }
            }
            if (this.meta.isForceFormulaRecalculation()) {
                this.recalculateAllWorkbookFormulas();
            }
            BufferedOutputStream out = new BufferedOutputStream(KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false));
            this.data.wb.write((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
    }

    void recalculateAllWorkbookFormulas() {
        if (this.data.wb instanceof XSSFWorkbook) {
            FormulaEvaluator evaluator = this.data.wb.getCreationHelper().createFormulaEvaluator();
            for (int sheetNum = 0; sheetNum < this.data.wb.getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = this.data.wb.getSheetAt(sheetNum);
                for (Row r : sheet) {
                    for (Cell c : r) {
                        if (c.getCellType() != 2) continue;
                        evaluator.evaluateFormulaCell(c);
                    }
                }
            }
        } else if (this.data.wb instanceof HSSFWorkbook) {
            for (int sheetNum = 0; sheetNum < this.data.wb.getNumberOfSheets(); ++sheetNum) {
                HSSFSheet sheet = ((HSSFWorkbook)this.data.wb).getSheetAt(sheetNum);
                sheet.setForceFormulaRecalculation(true);
            }
        } else {
            String forceRecalc = this.getVariable(STREAMER_FORCE_RECALC_PROP_NAME, "N");
            if ("Y".equals(forceRecalc)) {
                this.data.wb.setForceFormulaRecalculation(true);
            }
        }
    }

    public void writeNextLine(Object[] r) throws KettleException {
        try {
            this.openLine();
            Row xlsRow = this.data.sheet.getRow(this.data.posY);
            if (xlsRow == null) {
                xlsRow = this.data.sheet.createRow(this.data.posY);
            }
            Object v = null;
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                int nr = this.data.inputRowMeta.size();
                this.data.clearStyleCache(nr);
                this.data.linkfieldnrs = new int[nr];
                this.data.commentfieldnrs = new int[nr];
                for (int i = 0; i < nr; ++i) {
                    v = r[i];
                    this.writeField(v, this.data.inputRowMeta.getValueMeta(i), null, xlsRow, this.data.posX++, r, i, false);
                }
                this.data.posX = this.data.startingCol;
                ++this.data.posY;
            } else {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    v = r[this.data.fieldnrs[i]];
                    this.writeField(v, this.data.inputRowMeta.getValueMeta(this.data.fieldnrs[i]), this.meta.getOutputFields()[i], xlsRow, this.data.posX++, r, i, false);
                }
                this.data.posX = this.data.startingCol;
                ++this.data.posY;
            }
        }
        catch (Exception e) {
            this.logError("Error writing line :" + e.toString());
            throw new KettleException((Throwable)e);
        }
    }

    private Comment createCellComment(String author, String comment) {
        if (this.data.sheet instanceof XSSFSheet) {
            CreationHelper factory = this.data.wb.getCreationHelper();
            Drawing drawing = this.data.sheet.createDrawingPatriarch();
            ClientAnchor anchor = factory.createClientAnchor();
            Comment cmt = drawing.createCellComment(anchor);
            RichTextString str = factory.createRichTextString(comment);
            cmt.setString(str);
            cmt.setAuthor(author);
            return cmt;
        }
        return null;
    }

    private Cell getCellFromReference(String reference) {
        CellReference cellRef = new CellReference(reference);
        String sheetName = cellRef.getSheetName();
        Sheet sheet = this.data.sheet;
        if (!Const.isEmpty((String)sheetName)) {
            sheet = this.data.wb.getSheet(sheetName);
        }
        if (sheet == null) {
            return null;
        }
        Row xlsRow = sheet.getRow(cellRef.getRow());
        if (xlsRow == null) {
            return null;
        }
        Cell styleCell = xlsRow.getCell((int)cellRef.getCol());
        return styleCell;
    }

    private void writeField(Object v, ValueMetaInterface vMeta, ExcelWriterStepField excelField, Row xlsRow, int posX, Object[] row, int fieldNr, boolean isTitle) throws KettleException {
        try {
            String comment;
            String link;
            boolean cellExisted = true;
            Cell cell = xlsRow.getCell(posX);
            if (cell == null) {
                cellExisted = false;
                cell = xlsRow.createCell(posX);
            }
            if (!cellExisted || !this.meta.isLeaveExistingStylesUnchanged()) {
                if (!isTitle && this.data.getCachedStyle(fieldNr) != null) {
                    cell.setCellStyle(this.data.getCachedStyle(fieldNr));
                } else {
                    if (excelField != null) {
                        Cell styleCell;
                        String styleRef = null;
                        if (!isTitle && !Const.isEmpty((String)excelField.getStyleCell())) {
                            styleRef = excelField.getStyleCell();
                        } else if (isTitle && !Const.isEmpty((String)excelField.getTitleStyleCell())) {
                            styleRef = excelField.getTitleStyleCell();
                        }
                        if (styleRef != null && (styleCell = this.getCellFromReference(styleRef)) != null && cell != styleCell) {
                            cell.setCellStyle(styleCell.getCellStyle());
                        }
                    }
                    if (!(isTitle || excelField == null || Const.isEmpty((String)excelField.getFormat()) || excelField.getFormat().startsWith("Image"))) {
                        this.setDataFormat(excelField.getFormat(), cell);
                    }
                    if (!isTitle) {
                        this.data.cacheStyle(fieldNr, cell.getCellStyle());
                    }
                }
            }
            if (!isTitle && excelField != null && this.data.linkfieldnrs[fieldNr] >= 0 && !Const.isEmpty((String)(link = this.data.inputRowMeta.getValueMeta(this.data.linkfieldnrs[fieldNr]).getString(row[this.data.linkfieldnrs[fieldNr]])))) {
                CreationHelper ch = this.data.wb.getCreationHelper();
                Hyperlink hyperLink = null;
                if (link.startsWith("http:") || link.startsWith("https:") || link.startsWith("ftp:")) {
                    hyperLink = ch.createHyperlink(1);
                    hyperLink.setLabel("URL Link");
                } else if (link.startsWith("mailto:")) {
                    hyperLink = ch.createHyperlink(3);
                    hyperLink.setLabel("Email Link");
                } else if (link.startsWith("'")) {
                    hyperLink = ch.createHyperlink(2);
                    hyperLink.setLabel("Link within this document");
                } else {
                    hyperLink = ch.createHyperlink(4);
                    hyperLink.setLabel("Link to a file");
                }
                hyperLink.setAddress(link);
                cell.setHyperlink(hyperLink);
                if (!cellExisted || !this.meta.isLeaveExistingStylesUnchanged()) {
                    if (this.data.getCachedLinkStyle(fieldNr) != null) {
                        cell.setCellStyle(this.data.getCachedLinkStyle(fieldNr));
                    } else {
                        Font origFont = this.data.wb.getFontAt(cell.getCellStyle().getFontIndex());
                        Font hlink_font = this.data.wb.createFont();
                        hlink_font.setBoldweight(origFont.getBoldweight());
                        hlink_font.setCharSet(origFont.getCharSet());
                        hlink_font.setFontHeight(origFont.getFontHeight());
                        hlink_font.setFontName(origFont.getFontName());
                        hlink_font.setItalic(origFont.getItalic());
                        hlink_font.setStrikeout(origFont.getStrikeout());
                        hlink_font.setTypeOffset(origFont.getTypeOffset());
                        hlink_font.setUnderline((byte)1);
                        hlink_font.setColor(IndexedColors.BLUE.getIndex());
                        CellStyle style = cell.getCellStyle();
                        style.setFont(hlink_font);
                        cell.setCellStyle(style);
                        this.data.cacheLinkStyle(fieldNr, cell.getCellStyle());
                    }
                }
            }
            if (!isTitle && excelField != null && this.data.commentfieldnrs[fieldNr] >= 0 && this.data.wb instanceof XSSFWorkbook && !Const.isEmpty((String)(comment = this.data.inputRowMeta.getValueMeta(this.data.commentfieldnrs[fieldNr]).getString(row[this.data.commentfieldnrs[fieldNr]])))) {
                String author = this.data.commentauthorfieldnrs[fieldNr] >= 0 ? this.data.inputRowMeta.getValueMeta(this.data.commentauthorfieldnrs[fieldNr]).getString(row[this.data.commentauthorfieldnrs[fieldNr]]) : "Kettle PDI";
                cell.setCellComment(this.createCellComment(author, comment));
            }
            if (!isTitle && excelField != null && excelField.isFormula()) {
                cell.setCellFormula(vMeta.getString(v));
            } else {
                switch (vMeta.getType()) {
                    case 3: {
                        if (v == null || vMeta.getDate(v) == null) break;
                        cell.setCellValue(vMeta.getDate(v));
                        break;
                    }
                    case 4: {
                        if (v == null) break;
                        cell.setCellValue(vMeta.getBoolean(v).booleanValue());
                        break;
                    }
                    case 2: 
                    case 8: {
                        if (v == null) break;
                        cell.setCellValue(vMeta.getString(v));
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        if (v == null) break;
                        cell.setCellValue(vMeta.getNumber(v).doubleValue());
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logError("Error writing field (" + this.data.posX + "," + this.data.posY + ") : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            throw new KettleException((Throwable)e);
        }
    }

    private void setDataFormat(String excelFieldFormat, Cell cell) {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterStep.Log.SetDataFormat", (Object[])new Object[]{excelFieldFormat, CellReference.convertNumToColString((int)cell.getColumnIndex()), cell.getRowIndex()}));
        }
        DataFormat format = this.data.wb.createDataFormat();
        short formatIndex = format.getFormat(excelFieldFormat);
        CellStyle style = this.data.wb.createCellStyle();
        style.setDataFormat(formatIndex);
        cell.setCellStyle(style);
    }

    public String buildFilename(int splitNr) {
        return this.meta.buildFilename(this, this.getCopy(), splitNr);
    }

    public static void copyFile(FileObject in, FileObject out) throws KettleException {
        BufferedInputStream fis = null;
        FilterOutputStream fos = null;
        try {
            fis = new BufferedInputStream(KettleVFS.getInputStream((FileObject)in));
            fos = new BufferedOutputStream(KettleVFS.getOutputStream((FileObject)out, (boolean)false));
            byte[] buf = new byte[0x100000];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                ((BufferedOutputStream)fos).write(buf, 0, i);
            }
            ((BufferedOutputStream)fos).flush();
            fos.close();
            fis.close();
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareNextOutputFile() throws KettleException {
        try {
            int numOfFields;
            if (this.data.realSheetname != null && this.data.realSheetname.length() > 31) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"ExcelWriterStep.Exception.MaxSheetName", (String[])new String[]{this.data.realSheetname}));
            }
            int n = numOfFields = this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0 ? this.meta.getOutputFields().length : 0;
            if (numOfFields == 0) {
                numOfFields = this.data.inputRowMeta != null ? this.data.inputRowMeta.size() : 0;
            }
            this.data.clearStyleCache(numOfFields);
            String buildFilename = this.buildFilename(this.data.splitnr);
            this.data.file = KettleVFS.getFileObject((String)buildFilename, (VariableSpace)this.getTransMeta());
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterStep.Log.OpeningFile", (String[])new String[]{buildFilename}));
            }
            if (this.data.file.exists() && this.data.createNewFile && !this.data.file.delete()) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExcelWriterStep.Log.CouldNotDeleteStaleFile", (String[])new String[]{buildFilename}));
                }
                this.setErrors(1L);
                throw new KettleException("Could not delete stale file " + buildFilename);
            }
            if (this.meta.isAddToResultFiles()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment("This file was created with an Excel writer step by Pentaho Data Integration");
                this.addResultFile(resultFile);
            }
            boolean appendingToSheet = true;
            if (!this.data.file.exists()) {
                block33: {
                    if (this.meta.isTemplateEnabled()) {
                        String templateExt = KettleVFS.getFileObject((String)this.data.realTemplateFileName).getName().getExtension();
                        if (!this.meta.getExtension().equalsIgnoreCase(templateExt)) {
                            throw new KettleException("Template Format Mismatch: Template has extension: " + templateExt + ", but output file has extension: " + this.meta.getExtension() + ". Template and output file must share the same format!");
                        }
                        if (KettleVFS.getFileObject((String)this.data.realTemplateFileName).exists()) {
                            ExcelWriterStep.copyFile(KettleVFS.getFileObject((String)this.data.realTemplateFileName, (VariableSpace)this.getTransMeta()), this.data.file);
                            break block33;
                        } else {
                            if (this.log.isBasic()) {
                                this.logBasic(BaseMessages.getString(PKG, (String)"ExcelWriterStep.Log.TemplateMissing", (String[])new String[]{this.data.realTemplateFileName}));
                            }
                            this.setErrors(1L);
                            throw new KettleException("Template file missing: " + this.data.realTemplateFileName);
                        }
                    }
                    XSSFWorkbook wb = this.meta.getExtension().equalsIgnoreCase("xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
                    OutputStream out = KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false);
                    wb.createSheet(this.data.realSheetname);
                    wb.write(out);
                    out.close();
                }
                appendingToSheet = false;
            }
            if (this.meta.getExtension().equalsIgnoreCase("xlsx")) {
                XSSFWorkbook xssfWorkbook = new XSSFWorkbook(KettleVFS.getInputStream((FileObject)this.data.file));
                this.data.wb = this.meta.isStreamingData() ? new SXSSFWorkbook(xssfWorkbook, 100) : xssfWorkbook;
            } else {
                this.data.wb = new HSSFWorkbook(KettleVFS.getInputStream((FileObject)this.data.file));
            }
            int existingActiveSheetIndex = this.data.wb.getActiveSheetIndex();
            int replacingSheetAt = -1;
            if (this.data.wb.getSheet(this.data.realSheetname) != null && this.data.createNewSheet) {
                replacingSheetAt = this.data.wb.getSheetIndex(this.data.wb.getSheet(this.data.realSheetname));
                this.data.wb.removeSheetAt(replacingSheetAt);
            }
            if (this.data.wb.getSheet(this.data.realSheetname) == null) {
                if (this.meta.isTemplateSheetEnabled()) {
                    Sheet ts = this.data.wb.getSheet(this.data.realTemplateSheetName);
                    if (ts == null) {
                        throw new KettleException("Tempate Sheet: " + this.data.realTemplateSheetName + " not found, aborting");
                    }
                    this.data.sheet = this.data.wb.cloneSheet(this.data.wb.getSheetIndex(ts));
                    this.data.wb.setSheetName(this.data.wb.getSheetIndex(this.data.sheet), this.data.realSheetname);
                    this.data.wb.setSheetHidden(this.data.wb.getSheetIndex(this.data.sheet), false);
                } else {
                    this.data.sheet = this.data.wb.createSheet(this.data.realSheetname);
                }
                if (replacingSheetAt > -1) {
                    this.data.wb.setSheetOrder(this.data.sheet.getSheetName(), replacingSheetAt);
                }
                this.data.wb.setActiveSheet(existingActiveSheetIndex);
                this.data.wb.setSelectedTab(existingActiveSheetIndex);
                appendingToSheet = false;
            } else {
                this.data.sheet = this.data.wb.getSheet(this.data.realSheetname);
            }
            if (this.meta.isMakeSheetActive()) {
                int sheetIndex = this.data.wb.getSheetIndex(this.data.sheet);
                this.data.wb.setActiveSheet(sheetIndex);
                this.data.wb.setSelectedTab(sheetIndex);
            }
            if (this.meta.isSheetProtected()) {
                this.protectSheet(this.data.sheet, this.data.realPassword);
            }
            this.data.startingRow = 0;
            this.data.startingCol = 0;
            if (!Const.isEmpty((String)this.data.realStartingCell)) {
                CellReference cellRef = new CellReference(this.data.realStartingCell);
                this.data.startingRow = cellRef.getRow();
                this.data.startingCol = cellRef.getCol();
            }
            this.data.posX = this.data.startingCol;
            this.data.posY = this.data.startingRow;
            if (!this.data.createNewSheet && this.meta.isAppendLines() && appendingToSheet) {
                this.data.posY = this.data.sheet.getLastRowNum();
                if (this.data.posY > 0) {
                    ++this.data.posY;
                }
            }
            if (!this.data.createNewSheet && this.meta.getAppendOffset() != 0 && appendingToSheet) {
                this.data.posY += this.meta.getAppendOffset();
            }
            if (!this.data.createNewSheet && this.meta.getAppendEmpty() > 0 && appendingToSheet) {
                for (int i = 0; i < this.meta.getAppendEmpty(); ++i) {
                    this.openLine();
                    if (this.data.shiftExistingCells && !this.meta.isAppendLines()) continue;
                    ++this.data.posY;
                }
            }
            if (this.meta.isHeaderEnabled() && (this.data.createNewSheet || !this.meta.isAppendOmitHeader() || !appendingToSheet)) {
                this.writeHeader();
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterStep.Log.FileOpened", (String[])new String[]{buildFilename}));
            }
            ++this.data.splitnr;
            return;
        }
        catch (Exception e) {
            this.logError("Error opening new file", e);
            this.setErrors(1L);
            throw new KettleException((Throwable)e);
        }
    }

    private void openLine() {
        if (this.data.shiftExistingCells) {
            this.data.sheet.shiftRows(this.data.posY, Math.max(this.data.posY, this.data.sheet.getLastRowNum()), 1);
        }
    }

    private void writeHeader() throws KettleException {
        try {
            this.openLine();
            Row xlsRow = this.data.sheet.getRow(this.data.posY);
            if (xlsRow == null) {
                xlsRow = this.data.sheet.createRow(this.data.posY);
            }
            int posX = this.data.posX;
            if (this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0) {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    String fieldName = !Const.isEmpty((String)this.meta.getOutputFields()[i].getTitle()) ? this.meta.getOutputFields()[i].getTitle() : this.meta.getOutputFields()[i].getName();
                    ValueMeta vMeta = new ValueMeta(fieldName, 2);
                    this.writeField(fieldName, (ValueMetaInterface)vMeta, this.meta.getOutputFields()[i], xlsRow, posX++, null, -1, true);
                }
            } else if (this.data.inputRowMeta != null) {
                for (int i = 0; i < this.data.inputRowMeta.size(); ++i) {
                    String fieldName = this.data.inputRowMeta.getFieldNames()[i];
                    ValueMeta vMeta = new ValueMeta(fieldName, 2);
                    this.writeField(fieldName, (ValueMetaInterface)vMeta, null, xlsRow, posX++, null, -1, true);
                }
            }
            ++this.data.posY;
            this.incrementLinesOutput();
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelWriterStepMeta)smi;
        this.data = (ExcelWriterStepData)sdi;
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            this.data.datalines = 0;
            this.data.realSheetname = this.environmentSubstitute(this.meta.getSheetname());
            this.data.realTemplateSheetName = this.environmentSubstitute(this.meta.getTemplateSheetName());
            this.data.realTemplateFileName = this.environmentSubstitute(this.meta.getTemplateFileName());
            this.data.realStartingCell = this.environmentSubstitute(this.meta.getStartingCell());
            this.data.realPassword = this.environmentSubstitute(this.meta.getPassword());
            this.data.realProtectedBy = this.environmentSubstitute(this.meta.getProtectedBy());
            this.data.shiftExistingCells = "push".equals(this.meta.getRowWritingMethod());
            this.data.createNewSheet = "new".equals(this.meta.getIfSheetExists());
            this.data.createNewFile = "new".equals(this.meta.getIfFileExists());
            if (!this.meta.isDoNotOpenNewFileInit()) {
                this.data.firstFileOpened = true;
                try {
                    this.prepareNextOutputFile();
                }
                catch (KettleException e) {
                    e.printStackTrace();
                    this.logError("Couldn't prepare output file " + this.environmentSubstitute(this.meta.getFileName()));
                    this.setErrors(1L);
                    this.stopAll();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelWriterStepMeta)smi;
        this.data = (ExcelWriterStepData)sdi;
        this.clearWorkbookMem();
        super.dispose(smi, sdi);
    }

    protected void protectSheet(Sheet sheet, String password) {
        if (sheet instanceof HSSFSheet) {
            sheet.protectSheet(password);
        }
    }
}

