/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.ui.Drawable;
import org.pentaho.di.trans.steps.autodoc.JobInformation;
import org.pentaho.di.trans.steps.autodoc.ReportSubjectLocation;
import org.pentaho.di.trans.steps.autodoc.TransformationInformation;
import org.pentaho.reporting.engine.classic.core.DataRow;

public class TransJobDrawable
implements Drawable {
    private DataRow dataRow;
    private boolean pixelateImages;

    public TransJobDrawable(DataRow dataRow, boolean pixelateImages) {
        this.dataRow = dataRow;
        this.pixelateImages = pixelateImages;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        try {
            ReportSubjectLocation location = (ReportSubjectLocation)this.dataRow.get("location");
            if (location.isTransformation()) {
                TransformationInformation ti = TransformationInformation.getInstance();
                ti.drawImage(graphics2D, rectangle2D, location, this.pixelateImages);
            } else {
                JobInformation ji = JobInformation.getInstance();
                ji.drawImage(graphics2D, rectangle2D, location, this.pixelateImages);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to draw image onto report", e);
        }
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public void setDataRow(DataRow dataRow) {
        this.dataRow = dataRow;
    }

    public boolean isPixelateImages() {
        return this.pixelateImages;
    }

    public void setPixelateImages(boolean pixelateImages) {
        this.pixelateImages = pixelateImages;
    }
}

