/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class H2DatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            return "org.h2.Driver";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 8082;
        }
        return -1;
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            if (databaseName != null && databaseName.startsWith("mem:") || (Const.isEmpty(port) || "-1".equals(port)) && Const.isEmpty(hostname)) {
                return "jdbc:h2:" + databaseName;
            }
            return "jdbc:h2:tcp://" + hostname + ":" + port + "/" + databaseName;
        }
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        return this.getBackwardsCompatibleSchemaTableCombination(schema_name, table_part);
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsAutoInc() {
        return true;
    }

    @Override
    public boolean supportsGetBlob() {
        return true;
    }

    @Override
    public boolean supportsSetCharacterStream() {
        return false;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "IDENTITY";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = retval + "DECIMAL(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        if (length < 3) {
                            retval = retval + "TINYINT";
                            break;
                        }
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "TEXT";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(2147483647";
                retval = retval + ")";
                break;
            }
            case 8: {
                retval = retval + "BLOB";
                break;
            }
            default: {
                retval = retval + "UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIME", "CURRENT_DATE", "CROSS", "DISTINCT", "EXCEPT", "EXISTS", "FROM", "FOR", "FALSE", "FULL", "GROUP", "HAVING", "INNER", "INTERSECT", "IS", "JOIN", "LIKE", "MINUS", "NATURAL", "NOT", "NULL", "ON", "ORDER", "PRIMARY", "ROWNUM", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TODAY", "TRUE", "UNION", "WHERE"};
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"h2.jar"};
    }

    @Override
    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }
}

