/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfText;

class WhitespaceCollapser {
    private static final String SPACE = " ";
    private boolean m_lastEndSpace = true;

    WhitespaceCollapser(RtfContainer rtfContainer) {
        Iterator iterator = rtfContainer.getChildren().iterator();
        while (iterator.hasNext()) {
            RtfText rtfText = null;
            Object e = iterator.next();
            if (e instanceof RtfText) {
                rtfText = (RtfText)e;
                this.processText(rtfText);
                continue;
            }
            this.m_lastEndSpace = true;
        }
    }

    private void processText(RtfText rtfText) {
        String string = rtfText.getText();
        if (string != null && string.length() > 0) {
            boolean bl = string.trim().length() == 0;
            boolean bl2 = bl || Character.isWhitespace(string.charAt(string.length() - 1));
            boolean bl3 = Character.isWhitespace(string.charAt(0));
            StringBuffer stringBuffer = new StringBuffer(string.length());
            if (bl) {
                if (!this.m_lastEndSpace) {
                    stringBuffer.append(SPACE);
                }
            } else {
                boolean bl4 = true;
                StringTokenizer stringTokenizer = new StringTokenizer(rtfText.getText(), " \t\n\r");
                while (stringTokenizer.hasMoreTokens()) {
                    if (bl4 && bl3 && !this.m_lastEndSpace) {
                        stringBuffer.append(SPACE);
                    }
                    bl4 = false;
                    stringBuffer.append(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens() && !bl2) continue;
                    stringBuffer.append(SPACE);
                }
            }
            rtfText.setText(stringBuffer.toString());
            this.m_lastEndSpace = bl2;
        }
    }
}

