/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.util.StringTokenizer;
import org.jfor.jfor.converter.ConverterLogChannel;
import org.jfor.jfor.rtflib.rtfdoc.RtfColorTable;

class FoColorConverter {
    private static final FoColorConverter m_instance = new FoColorConverter();
    private final IColorDecoder[] m_decoders = new IColorDecoder[]{new RgbColorDecoder(), new NamedColorDecoder(), new HexColorDecoder()};

    private FoColorConverter() {
    }

    static FoColorConverter getInstance() {
        return m_instance;
    }

    Integer getRtfColorNumber(String string, ConverterLogChannel converterLogChannel) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        Integer n = null;
        int n2 = 0;
        while (n2 < this.m_decoders.length) {
            n = this.m_decoders[n2].getRtfColorNumber(string, converterLogChannel);
            if (n != null) break;
            ++n2;
        }
        if (n == null) {
            converterLogChannel.logWarning("FoColorConverter: unable to decode color '" + string + "'");
        }
        return n;
    }

    private static class HexColorDecoder
    implements IColorDecoder {
        private HexColorDecoder() {
        }

        public Integer getRtfColorNumber(String string, ConverterLogChannel converterLogChannel) {
            int n = "#".length();
            if (!string.startsWith("#")) {
                return null;
            }
            if (string.length() != n + 6) {
                return null;
            }
            Integer n2 = null;
            try {
                int n3 = this.hexToDec(string.substring(n + 0, n + 2));
                int n4 = this.hexToDec(string.substring(n + 2, n + 4));
                int n5 = this.hexToDec(string.substring(n + 4, n + 6));
                n2 = new Integer(RtfColorTable.getInstance().getColorNumber(n3, n4, n5));
            }
            catch (Exception exception) {}
            return n2;
        }

        private int hexToDec(String string) {
            return Integer.parseInt(string, 16);
        }
    }

    private static class NamedColorDecoder
    implements IColorDecoder {
        private NamedColorDecoder() {
        }

        public Integer getRtfColorNumber(String string, ConverterLogChannel converterLogChannel) {
            return RtfColorTable.getInstance().getColorNumber(string);
        }
    }

    private static class RgbColorDecoder
    implements IColorDecoder {
        private RgbColorDecoder() {
        }

        public Integer getRtfColorNumber(String string, ConverterLogChannel converterLogChannel) {
            StringTokenizer stringTokenizer = this.checkColor(string);
            int[] nArray = null;
            try {
                if (stringTokenizer != null) {
                    nArray = new int[3];
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        nArray[n] = Integer.parseInt(stringTokenizer.nextToken().trim());
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                converterLogChannel.logWarning("invalid RGB color string '" + string + "'");
                nArray = null;
            }
            if (nArray == null) {
                return null;
            }
            return new Integer(RtfColorTable.getInstance().getColorNumber(nArray[0], nArray[1], nArray[2]));
        }

        private StringTokenizer checkColor(String string) {
            if (!string.toUpperCase().startsWith("RGB(") || !string.endsWith(")")) {
                return null;
            }
            String string2 = string.substring("RGB(".length(), string.length() - ")".length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() == 3) {
                return stringTokenizer;
            }
            return null;
        }
    }

    static interface IColorDecoder {
        public Integer getRtfColorNumber(String var1, ConverterLogChannel var2);
    }
}

