/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.jfor.jfor.converter.ConverterException;
import org.jfor.jfor.converter.ConverterLogChannel;
import org.jfor.jfor.converter.IBuilder;
import org.jfor.jfor.converter.TableContext;
import org.jfor.jfor.rtflib.rtfdoc.IRtfOptions;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfFile;

class BuilderContext {
    private final RtfFile m_rtfFile;
    private final Stack m_containers = new Stack();
    private final Stack m_tableContexts = new Stack();
    private final Stack m_builders = new Stack();
    ConverterLogChannel log;
    IRtfOptions m_options;

    BuilderContext(Writer writer, ConverterLogChannel converterLogChannel, IRtfOptions iRtfOptions) throws IOException {
        this.m_rtfFile = new RtfFile(writer);
        this.m_rtfFile.setLogChannel(converterLogChannel);
        this.m_options = iRtfOptions;
        this.log = converterLogChannel;
    }

    private Object getObjectFromStack(Stack stack, Class clazz) {
        Object var3_3 = null;
        Stack stack2 = (Stack)stack.clone();
        while (!stack2.isEmpty()) {
            Object e = stack2.pop();
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            var3_3 = e;
            break;
        }
        return var3_3;
    }

    IBuilder getBuilder(Class clazz, boolean bl) throws ConverterException {
        IBuilder iBuilder = (IBuilder)this.getObjectFromStack(this.m_builders, clazz);
        if (iBuilder == null && bl) {
            throw new ConverterException("IBuilder of class '" + clazz.getName() + "' not found on builders stack");
        }
        return iBuilder;
    }

    RtfContainer getContainer(Class clazz, boolean bl, IBuilder iBuilder) throws ConverterException {
        RtfContainer rtfContainer = (RtfContainer)this.getObjectFromStack(this.m_containers, clazz);
        if (rtfContainer == null && bl) {
            throw new ConverterException("No RtfContainer of class '" + clazz.getName() + "' available for '" + iBuilder.getClass().getName() + "' builder");
        }
        return rtfContainer;
    }

    void pushContainer(RtfContainer rtfContainer) {
        this.m_containers.push(rtfContainer);
    }

    void replaceContainer(RtfContainer rtfContainer, RtfContainer rtfContainer2) throws ConverterException {
        int n = this.m_containers.indexOf(rtfContainer);
        if (n < 0) {
            throw new ConverterException("container to replace not found:" + rtfContainer);
        }
        this.m_containers.setElementAt(rtfContainer2, n);
    }

    void popContainer() {
        this.m_containers.pop();
    }

    void pushBuilder(IBuilder iBuilder) {
        this.m_builders.push(iBuilder);
    }

    IBuilder popBuilderAndGetPreviousOne() {
        IBuilder iBuilder = null;
        this.m_builders.pop();
        if (!this.m_builders.isEmpty()) {
            iBuilder = (IBuilder)this.m_builders.peek();
        }
        return iBuilder;
    }

    RtfFile getRtfFile() {
        return this.m_rtfFile;
    }

    TableContext getTableContext() {
        return (TableContext)this.m_tableContexts.peek();
    }

    void pushTableContext(TableContext tableContext) {
        this.m_tableContexts.push(tableContext);
    }

    void popTableContext() {
        this.m_tableContexts.pop();
    }
}

