/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class X509LDAPCombineAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(X509LDAPCombineAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        logger.debug((Object)" --- Running combineAuth --- ");
        logger.debug((Object)("Email: " + userProp.getProperty("userEmail")));
        logger.debug((Object)("Uid: " + userProp.getProperty("userID")));
        logger.debug((Object)("authenticated: " + userProp.getProperty("authenticated")));
        logger.debug((Object)("Rest: " + userProp.toString()));
        String cert_email = userProp.getProperty("userEmail");
        String uid = userProp.getProperty("userID");
        boolean ok = false;
        if (cert_email != null && uid != null) {
            String extract = null;
            Matcher m = Pattern.compile("([^@]+)@.*").matcher(cert_email);
            if (m.matches()) {
                extract = m.group(1);
            }
            logger.debug((Object)("extract=" + extract));
            if (extract != null && uid.trim().equalsIgnoreCase(extract.trim())) {
                ok = true;
            }
        }
        String ldap_mail = userProp.getProperty("mail");
        if (cert_email != null && ldap_mail != null && ldap_mail.trim().equalsIgnoreCase(cert_email.trim())) {
            ok = true;
        }
        String ldap_mail2 = userProp.getProperty("mailAlternateAddress");
        if (cert_email != null && ldap_mail2 != null && ldap_mail2.trim().equalsIgnoreCase(cert_email.trim())) {
            ok = true;
        }
        if (ok) {
            userProp.put("authenticated", "y");
        } else {
            userProp.remove("authenticated");
        }
        logger.debug((Object)("Erg combineAuth: " + ok));
        return userProp;
    }
}

