/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbConnectionProperty;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.conprovider.ConnectionFactory;
import org.dbforms.conprovider.ConnectionProviderPrefs;
import org.dbforms.util.Util;

public class DbConnection
implements DataSource {
    private static Log logCat = LogFactory.getLog((Class)(class$org$dbforms$config$DbConnection == null ? (class$org$dbforms$config$DbConnection = DbConnection.class$("org.dbforms.config.DbConnection")) : class$org$dbforms$config$DbConnection));
    private ConnectionFactory connectionFactory = ConnectionFactory.instance();
    private Properties poolProperties;
    private Properties properties = new Properties();
    private String conClass;
    private String connectionPoolURL;
    private String connectionProviderClass;
    private String contextDataSource;
    private String id;
    private String isJndi = "false";
    private String name;
    private String password;
    private String username;
    private boolean defaultConnection = false;
    private boolean isFactorySetup = false;
    private boolean isPropSetup = false;
    private boolean jndi = false;
    private boolean pow2 = false;
    static /* synthetic */ Class class$org$dbforms$config$DbConnection;

    public DbConnection() {
        this.poolProperties = new Properties();
    }

    public void setConClass(String conClass) {
        this.conClass = conClass;
    }

    public String getConClass() {
        return this.conClass;
    }

    public Connection getConnection() {
        Connection con = null;
        con = this.jndi ? this.getConnectionFromJNDI(this.name) : (this.pow2 ? this.getConnectionFromFactory() : this.getConnectionFromDriverManager());
        return con;
    }

    public Connection getConnection(String p_username, String p_password) throws SQLException {
        this.setUsername(p_username);
        this.setPassword(p_password);
        return this.getConnection();
    }

    public void setConnectionPoolURL(String url) {
        this.connectionPoolURL = url;
    }

    public String getConnectionPoolURL() {
        return this.connectionPoolURL;
    }

    public void setConnectionProviderClass(String cpc) {
        this.connectionProviderClass = cpc;
    }

    public String getConnectionProviderClass() {
        return this.connectionProviderClass;
    }

    public void setContextDataSource(String contextDataSource) {
        this.contextDataSource = contextDataSource;
    }

    public String getContextDataSource() {
        return this.contextDataSource;
    }

    public void setDefaultConnection(boolean defaultConnection) {
        this.defaultConnection = defaultConnection;
    }

    public boolean isDefaultConnection() {
        return this.defaultConnection;
    }

    public void setDriverClassName(String driverClassName) {
        this.setConClass(driverClassName);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setIsJndi(String isJndi) {
        this.isJndi = isJndi;
        this.jndi = Util.getTrue(isJndi);
    }

    public void setIsPow2(String isPow2) {
        this.pow2 = Util.getTrue(isPow2);
    }

    public void setJdbcURL(String jdbcURL) {
        this.setName(jdbcURL);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLException("dbforms.error.not_supported");
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException("dbforms.error.not_supported");
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException("dbforms.error.not_supported");
    }

    public int getLoginTimeout() throws SQLException {
        throw new SQLException("dbforms.error.not_supported");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPassword(String newpass) {
        this.password = newpass;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String newuser) {
        this.username = newuser;
    }

    public String getUsername() {
        return this.username;
    }

    public void addPoolProperty(DbConnectionProperty prop) {
        this.poolProperties.put(prop.getName(), prop.getValue());
    }

    public void addProperty(DbConnectionProperty prop) {
        this.properties.put(prop.getName(), prop.getValue());
    }

    public String getisJndi() {
        return this.isJndi;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DbConnection = ");
        buf.append("id=" + this.id).append(", name=" + this.name).append(", jndi=" + this.isJndi).append(", conClass=" + this.conClass).append(", username=" + this.username).append(", default=" + this.defaultConnection);
        if (this.pow2) {
            buf.append(", connectionProviderClass=" + this.connectionProviderClass).append(", connectionPoolURL=" + this.connectionPoolURL);
        }
        if (!this.properties.isEmpty()) {
            buf.append(", jdbc properties: ").append(this.properties);
        }
        if (!this.poolProperties.isEmpty()) {
            buf.append(", connection pool properties: ").append(this.poolProperties);
        }
        return buf.toString();
    }

    private Connection getConnectionFromDriverManager() {
        Connection con = null;
        try {
            Class.forName(this.conClass).newInstance();
            if (!this.properties.isEmpty()) {
                if (!this.isPropSetup) {
                    this.properties.put("user", this.getUsername());
                    this.properties.put("password", this.getPassword());
                    this.isPropSetup = true;
                }
                con = DriverManager.getConnection(this.name, this.properties);
            } else {
                con = this.username != null ? DriverManager.getConnection(this.name, this.username, this.password) : DriverManager.getConnection(this.name);
            }
        }
        catch (Exception e) {
            logCat.error((Object)"::getConnectionFromDriverManager - cannot retrieve a connection from DriverManager", (Throwable)e);
        }
        return con;
    }

    private Connection getConnectionFromFactory() {
        Connection con = null;
        try {
            if (!this.isFactorySetup) {
                this.setupConnectionFactory();
            }
            con = this.connectionFactory.getConnection();
        }
        catch (Exception se) {
            logCat.error((Object)"::getConnectionFromFactory - cannot retrieve a connection from the connectionFactory", (Throwable)se);
        }
        return con;
    }

    private Connection getConnectionFromJNDI(String lookupString) {
        Connection con = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(lookupString);
            if (ds != null) {
                con = ds.getConnection();
            } else {
                logCat.error((Object)"::getConnectionFromJNDI - DataSource object is null");
            }
        }
        catch (NamingException ne) {
            logCat.error((Object)"::getConnectionFromJNDI - cannot retrieve a connection from JNDI:", (Throwable)ne);
        }
        catch (Exception e) {
            logCat.error((Object)"::getConnectionFromJNDI - exception:", (Throwable)e);
        }
        return con;
    }

    private void setupConnectionFactory() throws Exception {
        ConnectionProviderPrefs prefs = new ConnectionProviderPrefs();
        prefs.setConnectionProviderClass(this.connectionProviderClass);
        prefs.setConnectionPoolURL(this.connectionPoolURL);
        prefs.setJdbcDriver(this.conClass);
        prefs.setJdbcURL(this.name);
        prefs.setUser(this.username);
        prefs.setPassword(this.password);
        prefs.setProperties(this.properties);
        prefs.setPoolProperties(this.poolProperties);
        prefs.setServletContext(DbFormsConfigRegistry.instance().lookup().getServletContext());
        this.connectionFactory.setProvider(prefs);
        this.isFactorySetup = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

