/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource;

import de.destatis.core.connect.util.Contract;
import java.util.HashMap;
import java.util.Map;

public class ResourceType {
    public static final ResourceType TYPE_DATML_SDF = new ResourceType(1, "Erhebungsbeschreibung (DatML/SDF)");
    public static final ResourceType TYPE_SUPPLYAGREEMENT = new ResourceType(2, "Liefervereinbarung (PDF)");
    public static final ResourceType TYPE_ASK = new ResourceType(3, "Elektr. Fragebogen (DatML/ASK)");
    public static final ResourceType TYPE_EDT = new ResourceType(4, "PL-Metadaten (DatML/EDT)");
    public static final ResourceType TYPE_SDFMETA = new ResourceType(5, "Erhebungsbeschreibung-Metadaten  (DatML/SDFmeta)");
    public static final ResourceType TYPE_DATML_RAW_SCHEME = new ResourceType(6, "DatML/RAW-Schema-Dateien");
    private static final ResourceType[] TYPES = new ResourceType[]{TYPE_DATML_SDF, TYPE_SUPPLYAGREEMENT, TYPE_ASK, TYPE_EDT, TYPE_SDFMETA, TYPE_DATML_RAW_SCHEME};
    private static final Map TYPES_BY_ID = new HashMap();
    private int typeId;
    private String name;

    public static ResourceType getInstance(int typeId) {
        ResourceType result = (ResourceType)TYPES_BY_ID.get(new Integer(typeId));
        Contract.verify(result != null, "Ung\u00fcltige TypID.");
        return result;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && ResourceType.class.equals(obj.getClass()) && this.getTypeId() == ((ResourceType)obj).getTypeId()) {
            equal = true;
        }
        return equal;
    }

    public String toString() {
        return this.getName() + " (ID: " + this.getTypeId() + ")";
    }

    public int hashCode() {
        return this.typeId;
    }

    private ResourceType(int typeId, String name) {
        this.typeId = typeId;
        this.name = name;
    }

    static {
        for (ResourceType type : TYPES) {
            TYPES_BY_ID.put(new Integer(type.getTypeId()), type);
        }
    }
}

