/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.model;

import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.MetaMapping;
import de.statspez.sdf.generator.meta.SDFMetaStructureTraverser;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import de.werum.sis.meta.ElementVisitorInterface;

public class MetaMappingBuilder {
    public static final String DOCUMENT_FIELD_SET_NAME = new String("Dokumentebene");
    public static final String MESSAGE_FIELD_SET_NAME = new String("Nachrichtenebene");
    public static final String META_DATEN_BINDING_NAME = "Metadaten";

    public MetaMapping build(MetaSDFMetabeschreibung sdfMetaBeschreibung) {
        return this.build(sdfMetaBeschreibung, true);
    }

    public MetaMapping build(MetaSDFMetabeschreibung sdfMetaBeschreibung, boolean computePositions) {
        MetaMapping mapping;
        if (sdfMetaBeschreibung != null) {
            String name = META_DATEN_BINDING_NAME;
            mapping = new MetaMapping(sdfMetaBeschreibung.getProzedurCode(), name);
            mapping.setCustomName("Metadaten-MappingNeu");
            SDFMetaStructureTraverser traverser = new SDFMetaStructureTraverser(){
                private BindingGroup currentBindingGroup;
                {
                    this.currentBindingGroup = mapping;
                }

                public void visitSDFMetabeschreibung(MetaSDFMetabeschreibung metabeschreibung) {
                    MetaSDFMetaAusgabegruppe documentAusgabegruppe = metabeschreibung.getDokumentAusgabegruppe();
                    this.currentBindingGroup = new FieldSetBinding(DOCUMENT_FIELD_SET_NAME);
                    mapping.setDocumentBinding((FieldSetBinding)this.currentBindingGroup);
                    documentAusgabegruppe.accept((ElementVisitorInterface)this);
                    MetaSDFMetaAusgabegruppe messageAusgabegruppe = metabeschreibung.getNachrichtAusgabegruppe();
                    this.currentBindingGroup = new FieldSetBinding(MESSAGE_FIELD_SET_NAME);
                    mapping.setMessageBinding((FieldSetBinding)this.currentBindingGroup);
                    messageAusgabegruppe.accept((ElementVisitorInterface)this);
                }

                public void visitSDFMetaFeldReferenz(MetaSDFMetaFeldReferenz feldReferenz) {
                    short art = feldReferenz.getArt();
                    if (art == 2) {
                        MetaSDFMetaMerkmalsgruppe merkmalsgruppe = (MetaSDFMetaMerkmalsgruppe)feldReferenz.getKlasse();
                        FieldGroupBinding fieldGroupBinding = new FieldGroupBinding(merkmalsgruppe.getName());
                        fieldGroupBinding.setSize(new Integer(1));
                        this.currentBindingGroup.addBinding(fieldGroupBinding);
                        BindingGroup parentBindingGroup = this.currentBindingGroup;
                        this.currentBindingGroup = fieldGroupBinding;
                        super.visitSDFMetaFeldReferenz(feldReferenz);
                        this.currentBindingGroup = parentBindingGroup;
                    } else {
                        MetaSDFMerkmal merkmal = (MetaSDFMerkmal)feldReferenz.getKlasse();
                        FieldBinding fieldBinding = new FieldBinding(merkmal.getName());
                        this.currentBindingGroup.addBinding(fieldBinding);
                    }
                }
            };
            sdfMetaBeschreibung.accept((ElementVisitorInterface)traverser);
            if (computePositions) {
                BindingHelper.computePositions(mapping);
            }
        } else {
            mapping = null;
        }
        return mapping;
    }
}

