/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.MetaMappingCheck;
import de.destatis.core.map.MetaMappingGenerator;
import de.destatis.core.map.editor.MappingEditorTool;
import de.destatis.core.map.editor.MappingTreeTableModel;
import de.destatis.core.map.editor.MetaMappingTreeTableModel;
import de.destatis.core.map.editor.PropertiesIfc;
import de.destatis.core.map.editor.UndoSupport;
import de.destatis.core.map.editor.util.BindedElementProvider;
import de.destatis.core.map.editor.util.MetaMappingHtmlPreviewCreator;
import de.destatis.core.map.editor.util.SDFMetaBindedElementProvider;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.MetaMapping;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MetaMappingEditorTool
extends MappingEditorTool {
    private MetaMapping mapping;
    private MetaSDFMetabeschreibung metaBeschreibung;
    private JTextField customName;
    private DocumentListener documentListener;

    public MetaMappingEditorTool(UndoSupport undoSupport, boolean dirtyFlag, PropertiesIfc properties, MetaMapping mapping, MetaSDFMetabeschreibung metaBeschreibung) {
        super(undoSupport, dirtyFlag, properties);
        this.mapping = mapping;
        this.metaBeschreibung = metaBeschreibung;
    }

    public MetaMapping getMapping() {
        return this.mapping;
    }

    @Override
    protected void doActivate() {
        String customName = this.mapping.getCustomName();
        this.customName.setText(customName);
        this.documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent paramDocumentEvent) {
                MetaMappingEditorTool.this.setDirtyFlag(true);
            }

            @Override
            public void insertUpdate(DocumentEvent paramDocumentEvent) {
                MetaMappingEditorTool.this.setDirtyFlag(true);
            }

            @Override
            public void changedUpdate(DocumentEvent paramDocumentEvent) {
            }
        };
        this.customName.getDocument().addDocumentListener(this.documentListener);
    }

    @Override
    protected JComponent createLeftGUI() {
        JScrollPane scrollPane = new JScrollPane(this.treeTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().setBackground(this.treeTable.getBackground());
        JPanel mappingDetailPanel = new JPanel(new GridBagLayout());
        mappingDetailPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(8, 8, 10, 8)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        mappingDetailPanel.add((Component)new JLabel("Name:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 5;
        gbc.insets.top = 0;
        this.customName = new JTextField();
        mappingDetailPanel.add((Component)this.customName, gbc);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.add((Component)mappingDetailPanel, "North");
        dataPanel.add((Component)scrollPane, "Center");
        return dataPanel;
    }

    @Override
    protected MappingTreeTableModel createTreeTableModel() {
        return new MetaMappingTreeTableModel(this, this.mapping, this.undoSupport != null ? this.undoSupport.getUndoableEditSupport() : null);
    }

    @Override
    protected MappingCheckResult doCheck() {
        MetaMappingCheck mappingCheck = new MetaMappingCheck();
        MappingCheckResult result = mappingCheck.check(this.mapping, this.metaBeschreibung);
        return result;
    }

    @Override
    protected String getTablePreview() {
        StringWriter writer = new StringWriter();
        MetaMappingHtmlPreviewCreator creator = new MetaMappingHtmlPreviewCreator(this.mapping, writer);
        creator.run();
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    @Override
    public boolean commitChangesToMapping() {
        boolean ok = super.commitChangesToMapping();
        this.mapping.setCustomName(this.customName.getText());
        return ok;
    }

    @Override
    protected void doSave(OutputStream out) throws IOException {
        MetaMappingGenerator generator = new MetaMappingGenerator();
        generator.generate(this.mapping, out);
        out.close();
    }

    @Override
    public void close() {
        super.close();
        if (this.documentListener != null && this.customName != null) {
            this.customName.getDocument().removeDocumentListener(this.documentListener);
        }
    }

    @Override
    protected JPopupMenu createTablePopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.getExpandAction());
        popupMenu.add(this.getCollapseAction());
        popupMenu.add(new JSeparator(0));
        popupMenu.add(this.getExpandAllAction());
        popupMenu.add(this.getCollapseAllAction());
        popupMenu.add(new JSeparator(0));
        popupMenu.add(this.getComputeStandardPositionsAction());
        popupMenu.add(this.getShowTablePreviewAction());
        return popupMenu;
    }

    @Override
    protected void computeStandardPositions() {
        int rc = JOptionPane.showConfirmDialog(this.getGUI(), "Die Feldpositionen werden neu berechnet.\nHierbei werden die aktuellen Positionsangaben \u00fcberschrieben!\nSollen die Feldpositionen jetzt neu berechnet werden?", "Standardpositionen neu berechnen?", 0, 3);
        if (rc == 0) {
            BindingHelper.computePositions(this.mapping);
            if (this.undoSupport != null) {
                this.undoSupport.clearUndoStacks();
            }
            this.treeTable.repaint();
            this.setDirtyFlag(true);
            this.updateInfo();
        }
    }

    @Override
    protected BindedElementProvider createBindedElementProvider() {
        return new SDFMetaBindedElementProvider(this.metaBeschreibung);
    }
}

