/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.ProtocolRequest;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToProtocolRequest;
import de.destatis.core.connect.document.DatMLResDocument;
import de.destatis.core.connect.document.ValidationException;
import de.destatis.core.connect.transfer.https.HttpsRequestHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class HttpsProtocolRequestHandler
extends HttpsRequestHandler {
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsProtocolRequestHandler.class);

    public HttpsProtocolRequestHandler(ProtocolRequest request, ClientConfig config) {
        super(request, config);
    }

    @Override
    public String getActionValue() {
        return "get_protocol_connect";
    }

    @Override
    public void addParts(Map<String, ContentBody> partList) {
        ProtocolRequest protocolRequest = (ProtocolRequest)this.getRequest();
        LOG.trace("protocol_id=" + protocolRequest.getEntryStamp());
        try {
            partList.put("protocol_id", (ContentBody)new StringBody(protocolRequest.getEntryStamp()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (protocolRequest.getDatMLResVersion() != null) {
            LOG.trace("datml_res_version=" + protocolRequest.getDatMLResVersion());
            try {
                partList.put("datml_res_version", (ContentBody)new StringBody(protocolRequest.getDatMLResVersion()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Response getResponse(HttpResponse httpResponse) {
        ResponseToProtocolRequest response = null;
        ResponseStatus responseStatus = this.getResponseStatus(httpResponse);
        String responseBody = this.getResponseBody(httpResponse);
        if (responseStatus.equals(ResponseStatus.OK)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Zurueckgeliefertes Verarbeitungsprotokoll:");
                LOG.trace(responseBody);
            }
            DatMLResDocument document = new DatMLResDocument();
            try {
                document.setDocument(responseBody);
            }
            catch (ValidationException exc) {
                LOG.error("Fehlerhaftes DatML/RES-Dokument geliefert bekommen", exc);
                response = new ResponseToProtocolRequest(ResponseStatus.BAD_RESPONSE, exc.getMessage(), null);
            }
            if (response == null) {
                response = new ResponseToProtocolRequest(responseStatus, null, document);
            }
        } else {
            response = new ResponseToProtocolRequest(responseStatus, responseBody, null);
        }
        return response;
    }
}

