/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.GetCommonResourceRequest;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToGetCommonResourceRequest;
import de.destatis.core.connect.transfer.https.HttpsRequestHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.resource.ResourceType;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;

public class HttpsGetCommonResourceRequestHandler
extends HttpsRequestHandler {
    protected static final String RESPONSE_COMMON_RESOURCE_MAIN_FILENAME = "X-MainFileName";
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsGetCommonResourceRequestHandler.class);

    public HttpsGetCommonResourceRequestHandler(GetCommonResourceRequest request, ClientConfig config) {
        super(request, config);
    }

    @Override
    public String getActionValue() {
        return "get_common_res_connect";
    }

    @Override
    public void addParts(Map<String, ContentBody> partList) {
        String currentResourceId;
        GetCommonResourceRequest resourceRequest = (GetCommonResourceRequest)this.getRequest();
        ResourceType resourceType = resourceRequest.getResourceType();
        int resourceTypeId = resourceType.getTypeId();
        LOG.trace("resource_type=" + resourceTypeId);
        try {
            partList.put("resource_type", (ContentBody)new StringBody(String.valueOf(resourceTypeId)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String datMlRawVersion = resourceRequest.getDatMlRawVersion();
        if (datMlRawVersion != null) {
            LOG.trace("datml_raw_version=" + datMlRawVersion);
            try {
                partList.put("datml_raw_version", (ContentBody)new StringBody(datMlRawVersion));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if ((currentResourceId = resourceRequest.getCurrentResourceId()) != null) {
            LOG.trace("current_resource_id=" + currentResourceId);
            try {
                partList.put("current_resource_id", (ContentBody)new StringBody(currentResourceId));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Response getResponse(HttpResponse httpResponse) {
        ResponseToGetCommonResourceRequest response;
        ResponseStatus responseStatus = this.getResponseStatus(httpResponse);
        if (ResponseStatus.OK.equals(responseStatus)) {
            try {
                Header resourceIdHeader = httpResponse.getFirstHeader("X-ResourceId");
                String resourceId = resourceIdHeader.getValue();
                String fileName = null;
                Header fileNameHeader = httpResponse.getFirstHeader("X-FileName");
                if (fileNameHeader != null) {
                    fileName = fileNameHeader.getValue();
                }
                String charset = null;
                Header charsetHeader = httpResponse.getFirstHeader("X-Charset");
                if (charsetHeader != null) {
                    charset = charsetHeader.getValue();
                }
                String mainFileName = null;
                Header mainFileNameHeader = httpResponse.getFirstHeader(RESPONSE_COMMON_RESOURCE_MAIN_FILENAME);
                if (mainFileNameHeader != null) {
                    mainFileName = mainFileNameHeader.getValue();
                }
                HttpEntity entity = httpResponse.getEntity();
                byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
                response = new ResponseToGetCommonResourceRequest(responseStatus, null, resourceId, data, charset, fileName, mainFileName);
            }
            catch (Exception e) {
                LOG.error("Fehler beim Lesen der Ressourcedaten", e);
                response = new ResponseToGetCommonResourceRequest(ResponseStatus.BAD_RESPONSE, e.getMessage(), null, null, null, null, null);
            }
        } else {
            String responseBody = this.getResponseBody(httpResponse);
            response = new ResponseToGetCommonResourceRequest(responseStatus, responseBody, null, null, null, null, null);
        }
        return response;
    }
}

