/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;

public class HttpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    protected static final String KEY_FOLLOW_REDIRECT = "followRedirect";
    private static final HttpFileSystemConfigBuilder BUILDER = new HttpFileSystemConfigBuilder();
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 5;
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 0;
    private static final int DEFAULT_SO_TIMEOUT = 0;
    private static final boolean DEFAULT_FOLLOW_REDIRECT = true;
    private static final String KEY_PREEMPTIVE_AUTHENTICATION = "preemptiveAuth";

    protected HttpFileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    private HttpFileSystemConfigBuilder() {
        super("http.");
    }

    public static HttpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setUrlCharset(FileSystemOptions opts, String chaset) {
        this.setParam(opts, "urlCharset", chaset);
    }

    public String getUrlCharset(FileSystemOptions opts) {
        return this.getString(opts, "urlCharset");
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, "proxyHost", proxyHost);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, "proxyPort", proxyPort);
    }

    public String getProxyHost(FileSystemOptions opts) {
        return this.getString(opts, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions opts) {
        return this.getInteger(opts, "proxyPort", 0);
    }

    public void setProxyAuthenticator(FileSystemOptions opts, UserAuthenticator authenticator) {
        this.setParam(opts, "proxyAuthenticator", authenticator);
    }

    public UserAuthenticator getProxyAuthenticator(FileSystemOptions opts) {
        return (UserAuthenticator)this.getParam(opts, "proxyAuthenticator");
    }

    public void setCookies(FileSystemOptions opts, Cookie[] cookies) {
        this.setParam(opts, "cookies", cookies);
    }

    public void setFollowRedirect(FileSystemOptions opts, boolean redirect) {
        this.setParam(opts, KEY_FOLLOW_REDIRECT, redirect);
    }

    public Cookie[] getCookies(FileSystemOptions opts) {
        return (Cookie[])this.getParam(opts, "cookies");
    }

    public boolean getFollowRedirect(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_FOLLOW_REDIRECT, true);
    }

    public void setMaxTotalConnections(FileSystemOptions opts, int maxTotalConnections) {
        this.setParam(opts, "http.connection-manager.max-total", maxTotalConnections);
    }

    public int getMaxTotalConnections(FileSystemOptions opts) {
        return this.getInteger(opts, "http.connection-manager.max-total", 50);
    }

    public void setMaxConnectionsPerHost(FileSystemOptions opts, int maxHostConnections) {
        this.setParam(opts, "http.connection-manager.max-per-host", maxHostConnections);
    }

    public int getMaxConnectionsPerHost(FileSystemOptions opts) {
        return this.getInteger(opts, "http.connection-manager.max-per-host", 5);
    }

    public boolean isPreemptiveAuth(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_PREEMPTIVE_AUTHENTICATION, Boolean.FALSE);
    }

    public void setPreemptiveAuth(FileSystemOptions opts, boolean preemptiveAuth) {
        this.setParam(opts, KEY_PREEMPTIVE_AUTHENTICATION, (Object)preemptiveAuth);
    }

    public void setConnectionTimeout(FileSystemOptions opts, int connectionTimeout) {
        this.setParam(opts, "http.connection.timeout", connectionTimeout);
    }

    public int getConnectionTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, "http.connection.timeout", 0);
    }

    public void setSoTimeout(FileSystemOptions opts, int soTimeout) {
        this.setParam(opts, "http.socket.timeout", soTimeout);
    }

    public int getSoTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, "http.socket.timeout", 0);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return HttpFileSystem.class;
    }
}

