/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.format;

import clover.com.lowagie.text.Chunk;
import clover.com.lowagie.text.Font;
import clover.com.lowagie.text.FontFactory;
import clover.com.lowagie.text.Phrase;
import com.atlassian.clover.util.format.MessageFormatException;
import com.atlassian.clover.util.format.MessageTokenizer;
import java.awt.Color;

public class PDFFormatter {
    public static Phrase format(String msg, String font, int points, Color anchorColour) {
        boolean bold = false;
        boolean italic = false;
        try {
            Phrase message = new Phrase(10.0f, "", PDFFormatter.getFont(font, points, bold, italic));
            MessageTokenizer tokenizer = new MessageTokenizer(msg);
            while (tokenizer.hasNext()) {
                int token = tokenizer.nextToken();
                switch (token) {
                    case 3: {
                        bold = true;
                        break;
                    }
                    case 4: {
                        bold = false;
                        break;
                    }
                    case 5: {
                        italic = true;
                        break;
                    }
                    case 6: {
                        italic = false;
                        break;
                    }
                    case 7: {
                        message.add(new Phrase(tokenizer.getContent(), PDFFormatter.getFont(font, points, bold, italic)));
                        break;
                    }
                    case 1: {
                        StringBuffer buffer = new StringBuffer();
                        token = tokenizer.nextToken();
                        while (token != 2) {
                            buffer.append(tokenizer.getContent());
                            token = tokenizer.nextToken();
                        }
                        String anchor = buffer.toString();
                        Chunk link = new Chunk(anchor, FontFactory.getFont(font, points, 5, anchorColour));
                        link.setAnchor(anchor);
                        message.add(link);
                    }
                }
            }
            return message;
        }
        catch (MessageFormatException e) {
            return new Phrase(10.0f, msg, FontFactory.getFont(font, points, 0));
        }
    }

    private static Font getFont(String font, int points, boolean bold, boolean italic) {
        if (bold && italic) {
            return FontFactory.getFont(font, points, 3);
        }
        if (bold) {
            return FontFactory.getFont(font, points, 1);
        }
        if (italic) {
            return FontFactory.getFont(font, points, 2);
        }
        return FontFactory.getFont(font, points, 0);
    }
}

