/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import java.util.Comparator;

public class ObjectHeaps {
    private ObjectHeaps() {
    }

    public static int downHeap(Object[] heap, int size, int i, Comparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        Object e = heap[i];
        if (c == null) {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && ((Comparable)heap[child + 1]).compareTo(heap[child]) < 0) {
                    ++child;
                }
                if (((Comparable)e).compareTo(heap[child]) > 0) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && c.compare(heap[child + 1], heap[child]) < 0) {
                    ++child;
                }
                if (c.compare(e, heap[child]) > 0) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(Object[] heap, int size, int i, Comparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        Object e = heap[i];
        if (c == null) {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && ((Comparable)heap[parent]).compareTo(e) > 0) {
                heap[i] = heap[parent];
                i = parent;
            }
        } else {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && c.compare(heap[parent], e) > 0) {
                heap[i] = heap[parent];
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(Object[] heap, int size, Comparator c) {
        int i = size / 2;
        while (i-- != 0) {
            ObjectHeaps.downHeap(heap, size, i, c);
        }
    }
}

