/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonSerializationContext;
import clover.com.google.gson.JsonSerializationVisitor;
import clover.com.google.gson.JsonSerializer;
import clover.com.google.gson.ObjectNavigator;
import clover.com.google.gson.ObjectNavigatorFactory;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonSerializationContextDefault
implements JsonSerializationContext {
    private final ObjectNavigatorFactory factory;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final boolean serializeNulls;

    JsonSerializationContextDefault(ObjectNavigatorFactory factory, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers) {
        this.factory = factory;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
    }

    @Override
    public JsonElement serialize(Object src) {
        return this.serialize(src, src.getClass());
    }

    @Override
    public JsonElement serialize(Object src, Type typeOfSrc) {
        ObjectNavigator on = this.factory.create(src, typeOfSrc);
        JsonSerializationVisitor visitor = new JsonSerializationVisitor(this.factory, this.serializeNulls, this.serializers, this);
        on.accept(visitor);
        return visitor.getJsonElement();
    }
}

