/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.NowikiTag;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import java.io.IOException;
import java.util.Map;

public class SourceTag
extends HTMLTag
implements INoBodyParsingTag {
    protected static final String SOURCE_START_1 = "<pre class=\"";
    protected static final String SOURCE_START_2 = "\">";
    protected static final String SOURCE_END = "</pre>";

    public SourceTag() {
        super("source");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            SourceCodeFormatter formatter;
            boolean show;
            Map<String, String> attributes = this.getAttributes();
            String sourceCodeLanguage = attributes.get("lang");
            if (sourceCodeLanguage == null) {
                sourceCodeLanguage = SourceTag.getSourceType(content);
            }
            if ((show = model.showSyntax(sourceCodeLanguage)) && (formatter = model.getCodeFormatterMap().get(sourceCodeLanguage)) != null) {
                String result = formatter.filter(content);
                writer.append(SOURCE_START_1);
                writer.append(sourceCodeLanguage);
                writer.append(SOURCE_START_2);
                writer.append(result);
                writer.append(SOURCE_END);
                return;
            }
            writer.append(SOURCE_START_1);
            writer.append(sourceCodeLanguage);
            writer.append(SOURCE_START_2);
            NowikiTag.copyPre(content, writer, true);
            writer.append(SOURCE_END);
        }
    }

    public boolean isReduceTokenStack() {
        return true;
    }

    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }

    public static String getSourceType(String src) {
        for (int i = 0; i < src.length(); ++i) {
            if (Character.isWhitespace(src.charAt(i))) continue;
            char ch = src.charAt(i);
            if (ch == '<') {
                if (++i >= src.length() || src.charAt(i) != '?') break;
                ++i;
                while (i < src.length() && Character.isWhitespace(src.charAt(i++))) {
                }
                ch = src.charAt(i - 1);
                if (i + 3 < src.length()) {
                    if (ch == 'x' || ch == 'X') {
                        if (!(src.charAt(i) != 'm' && src.charAt(i) != 'M' || src.charAt(i + 1) != 'l' && src.charAt(i + 1) != 'L')) {
                            return "xml";
                        }
                    } else if (!(ch != 'p' && ch != 'P' || src.charAt(i) != 'h' && src.charAt(i) != 'H' || src.charAt(i + 1) != 'p' && src.charAt(i + 1) != 'P')) {
                        return "php";
                    }
                }
                return "xml";
            }
            if (ch == 'p') {
                if (i + 7 >= src.length() || src.charAt(++i) != 'a' || src.charAt(i + 1) != 'c' || src.charAt(i + 2) != 'k' || src.charAt(i + 3) != 'a' || src.charAt(i + 4) != 'g' || src.charAt(i + 5) != 'e') break;
                return "java";
            }
            if (ch == 'i') {
                if (i + 7 >= src.length() || src.charAt(++i) != 'm' || src.charAt(i + 1) != 'p' || src.charAt(i + 2) != 'o' || src.charAt(i + 3) != 'r' || src.charAt(i + 4) != 't') break;
                return "java";
            }
            if (!(ch == 'f' || ch == 'F' ? !(++i + 7 >= src.length() || src.charAt(i) != 'u' && src.charAt(i) != 'U' || src.charAt(i + 1) != 'n' && src.charAt(i + 1) != 'N' || src.charAt(i + 2) != 'c' && src.charAt(i + 2) != 'C' || src.charAt(i + 3) != 't' && src.charAt(i + 3) != 'T' || src.charAt(i + 4) != 'i' && src.charAt(i + 4) != 'I' || src.charAt(i + 5) != 'o' && src.charAt(i + 5) != 'O' || src.charAt(i + 6) != 'n' && src.charAt(i + 6) != 'N') : (ch == 'm' || ch == 'M' ? !(++i + 5 >= src.length() || src.charAt(i) != 'e' && src.charAt(i) != 'E' || src.charAt(i + 1) != 't' && src.charAt(i + 1) != 'T' || src.charAt(i + 2) != 'h' && src.charAt(i + 2) != 'H' || src.charAt(i + 3) != 'o' && src.charAt(i + 3) != 'O' || src.charAt(i + 4) != 'd' && src.charAt(i + 4) != 'D') : !(ch != 'r' && ch != 'R' || ++i + 5 >= src.length() || src.charAt(i) != 'e' && src.charAt(i) != 'E' || src.charAt(i + 1) != 'p' && src.charAt(i + 1) != 'P' || src.charAt(i + 2) != 'o' && src.charAt(i + 2) != 'O' || src.charAt(i + 3) != 'r' && src.charAt(i + 3) != 'R' || src.charAt(i + 4) != 't' && src.charAt(i + 4) != 'T')))) break;
            return "abap";
        }
        return "xml";
    }
}

