/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbadmin;

import de.superx.dbadmin.OrgaEintrag2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class OrgaBearbDialog
extends JDialog
implements ActionListener {
    OrgaEintrag2 derEintrag;
    JTextField tname;
    JTextField tdrucktext;
    JTextField tkey;
    JTextField tebene;
    JTextField tparent;
    JTextField tlehre;
    JCheckBox clehre;
    JTextField torgstruktur;
    JTextField tgueltig_seit;
    JTextField tgueltig_bis;
    String oldKeyApnr;
    Date oldGueltigSeit;
    Date oldGueltigBis;
    DefaultMutableTreeNode theNode;
    DefaultMutableTreeNode theRoot;
    Vector ung\u00fcltigeEintr\u00e4ge;
    boolean bearbeiteNeueOrgaEinheit;

    public OrgaBearbDialog(Frame owner, DefaultMutableTreeNode node, Vector ung\u00fcltigeE) {
        super(owner, "OrgaEintrag bearbeiten", true);
        this.bearbeiteNeueOrgaEinheit = false;
        this.theNode = node;
        this.theRoot = (DefaultMutableTreeNode)node.getRoot();
        this.ung\u00fcltigeEintr\u00e4ge = ung\u00fcltigeE;
        this.init();
    }

    public OrgaBearbDialog(Frame owner, DefaultMutableTreeNode node, Vector ung\u00fcltigeE, DefaultMutableTreeNode lRoot) {
        super(owner, "Neue OrgaEintrag bearbeiten", true);
        this.bearbeiteNeueOrgaEinheit = true;
        this.theNode = node;
        this.theRoot = lRoot;
        this.ung\u00fcltigeEintr\u00e4ge = ung\u00fcltigeE;
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Abbrechen")) {
            if (this.bearbeiteNeueOrgaEinheit) {
                this.theNode = null;
            }
            this.setVisible(false);
            this.dispose();
        }
        if (cmd.equals("OK")) {
            this.OK\u00c4nderungAusf\u00fchren();
        }
    }

    public String dateToString(Date inp) {
        DateFormat df = DateFormat.getDateInstance(2);
        df.setTimeZone(TimeZone.getDefault());
        df.setLenient(false);
        String help = df.format(inp);
        return help;
    }

    public void init() {
        this.derEintrag = (OrgaEintrag2)this.theNode.getUserObject();
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel pcenter = new JPanel(new GridLayout(9, 1));
        JPanel p1 = new JPanel(new FlowLayout(0));
        JLabel lname = new JLabel("  Name     ");
        this.tname = new JTextField(60);
        this.tname.setText(this.derEintrag.getName());
        p1.add(lname);
        p1.add(this.tname);
        pcenter.add(p1);
        JPanel p1b = new JPanel(new FlowLayout(0));
        JLabel ldrucktext = new JLabel("Drucktext  ");
        this.tdrucktext = new JTextField(60);
        this.tdrucktext.setText(this.derEintrag.getDrucktext());
        p1b.add(ldrucktext);
        p1b.add(this.tdrucktext);
        pcenter.add(p1b);
        JPanel p2 = new JPanel(new FlowLayout(0));
        JLabel lkey = new JLabel("Key_apnr ");
        this.tkey = new JTextField(15);
        this.tkey.setText(this.derEintrag.getKeyApnr().toString());
        this.oldKeyApnr = this.derEintrag.getKeyApnr();
        p2.add(lkey);
        p2.add(this.tkey);
        pcenter.add(p2);
        JPanel p3 = new JPanel(new FlowLayout(0));
        JLabel lebene = new JLabel("Ebene      ");
        this.tebene = new JTextField(3);
        this.tebene.setText(this.derEintrag.getEbene().toString());
        p3.add(lebene);
        p3.add(this.tebene);
        pcenter.add(p3);
        JPanel p4 = new JPanel(new FlowLayout(0));
        JLabel lparent = new JLabel("Parent:   ");
        String parobj = this.derEintrag.getParent();
        String itsParent = parobj == null ? "" : parobj.toString();
        this.tparent = new JTextField(itsParent);
        JLabel lparentNum = new JLabel(itsParent);
        p4.add(lparent);
        p4.add(lparentNum);
        pcenter.add(p4);
        JPanel p5 = new JPanel(new FlowLayout(0));
        JLabel llehre = new JLabel("Lehre");
        this.clehre = new JCheckBox("Lehre", this.derEintrag.isLehre());
        p5.add(this.clehre);
        pcenter.add(p5);
        JPanel p5b = new JPanel(new FlowLayout(0));
        JLabel lorgstruktur = new JLabel("Orgstruktur");
        this.torgstruktur = new JTextField(4);
        Integer help_orgstruktur = this.derEintrag.getOrgstruktur();
        String help_orgstruktur2 = help_orgstruktur == null ? "" : ((Object)help_orgstruktur).toString();
        this.torgstruktur.setText(help_orgstruktur2);
        p5b.add(lorgstruktur);
        p5b.add(this.torgstruktur);
        pcenter.add(p5b);
        JPanel p6 = new JPanel(new FlowLayout(0));
        JLabel lgueltig_seit = new JLabel("g\u00fcltig seit");
        this.oldGueltigSeit = this.derEintrag.getGueltigSeit();
        this.tgueltig_seit = new JTextField(this.dateToString(this.oldGueltigSeit));
        p6.add(lgueltig_seit);
        p6.add(this.tgueltig_seit);
        pcenter.add(p6);
        JPanel p7 = new JPanel(new FlowLayout(0));
        JLabel lgueltig_bis = new JLabel("g\u00fcltig bis ");
        this.oldGueltigBis = this.derEintrag.getGueltigBis();
        this.tgueltig_bis = new JTextField(this.dateToString(this.oldGueltigBis));
        p7.add(lgueltig_bis);
        p7.add(this.tgueltig_bis);
        pcenter.add(p7);
        cp.add((Component)pcenter, "Center");
        JPanel pOKAbr = new JPanel();
        JButton OK = new JButton("OK");
        OK.addActionListener(this);
        pOKAbr.add(OK);
        JButton Abbr = new JButton("Abbrechen");
        Abbr.addActionListener(this);
        pOKAbr.add(Abbr);
        cp.add((Component)pOKAbr, "South");
        this.pack();
        this.setLocation(100, 100);
        this.show();
    }

    public boolean keyApnrOK(String keyApnr) {
        boolean isOK = true;
        Enumeration<TreeNode> en = this.theRoot.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            OrgaEintrag2 x;
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)en.nextElement();
            if (aNode.equals(this.theNode) || aNode.equals(this.theRoot) || !(aNode.getUserObject() instanceof OrgaEintrag2) || !keyApnr.equals((x = (OrgaEintrag2)aNode.getUserObject()).getKeyApnr())) continue;
            isOK = false;
        }
        return isOK;
    }

    public boolean neueG\u00fcltigkeitOK(String newKeyApnr, Date gs, Date gb) {
        boolean isOK = true;
        Enumeration el = this.ung\u00fcltigeEintr\u00e4ge.elements();
        while (el.hasMoreElements()) {
            boolean pruef2;
            OrgaEintrag2 x = (OrgaEintrag2)el.nextElement();
            if (!x.getKeyApnr().equals(newKeyApnr)) continue;
            boolean pruef1 = gs.before(x.getGueltigSeit()) && gb.before(x.getGueltigSeit());
            boolean bl = pruef2 = gs.after(x.getGueltigBis()) && gb.after(x.getGueltigBis());
            if (pruef1 || pruef2) continue;
            isOK = false;
        }
        return isOK;
    }

    public void OK\u00c4nderungAusf\u00fchren() {
        String neuname = this.tname.getText();
        String newKeyApnr = this.tkey.getText().trim();
        if (!this.keyApnrOK(newKeyApnr)) {
            JOptionPane.showMessageDialog(null, "Key_apnr bereits vergeben!", "SuperX DB Admin", 2);
            return;
        }
        if (!newKeyApnr.equals(this.oldKeyApnr)) {
            Enumeration<TreeNode> en = this.theNode.children();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode x = (DefaultMutableTreeNode)en.nextElement();
                OrgaEintrag2 einEintrag = (OrgaEintrag2)x.getUserObject();
                einEintrag.setParent(newKeyApnr);
            }
        }
        String drucktext = this.tdrucktext.getText();
        Integer neuEbene = new Integer(this.tebene.getText());
        int lehre = this.clehre.isSelected() ? 1 : 0;
        Integer neulehre = new Integer(lehre);
        Integer orgstruktur = this.torgstruktur.getText().equals("") ? null : new Integer(this.torgstruktur.getText());
        Date gs = this.stringToDate(this.tgueltig_seit.getText());
        Date gb = this.stringToDate(this.tgueltig_bis.getText());
        if (gs == null || gb == null || gb.before(gs)) {
            JOptionPane.showMessageDialog(null, "Fehler in Datumsfeldern!", "SuperX DB Admin", 2);
            return;
        }
        if (!this.oldGueltigSeit.equals(gs) || !this.oldGueltigBis.equals(gb)) {
            if (!this.neueG\u00fcltigkeitOK(newKeyApnr, gs, gb)) {
                JOptionPane.showMessageDialog(null, "Die eingegebene G\u00fcltigkeit \u00fcberlappt sich\nmit der G\u00fcltigkeit einer schon bestehenden key_apnr!", "SuperX DB Admin", 2);
                return;
            }
            JOptionPane.showMessageDialog(null, "Die G\u00fcltigkeit wurde ge\u00e4ndert!\nGgf. Organigramm neu einlesen oder Stand \u00e4ndern!", "SuperX DB Admin", 1);
        }
        this.derEintrag.name = neuname;
        this.derEintrag.drucktext = drucktext;
        this.derEintrag.key_apnr = newKeyApnr;
        this.derEintrag.lehre = neulehre;
        this.derEintrag.ebene = neuEbene;
        this.derEintrag.orgstruktur = orgstruktur;
        this.derEintrag.gueltig_seit = gs;
        this.derEintrag.gueltig_bis = gb;
        this.setVisible(false);
        this.dispose();
    }

    public Date stringToDate(String datum) {
        DateFormat df = DateFormat.getDateInstance(2);
        df.setTimeZone(TimeZone.getDefault());
        df.setLenient(false);
        Date date = null;
        try {
            java.util.Date date1 = df.parse(datum);
            date = new Date(date1.getTime());
        }
        catch (Exception e2) {
            System.out.println(e2.toString());
        }
        return date;
    }
}

