/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.coll.IdObjectSet;
import de.memtext.util.NumberUtils;
import de.memtext.util.XMLUtils;
import de.superx.applet.SxSQL;
import de.superx.common.RepositoryItem;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.StringTemplateSource;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateProcessor {
    private final Configuration cfg = new Configuration();
    private final HashMap stringTemplates = new HashMap();
    public SxResultSet rawFmTemplates;
    protected HashMap repositoryMap = new HashMap();
    protected boolean inServlet = false;
    private List fmTemplateNames = new LinkedList();
    public static final String REPOSITORY_SELECT = "select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1";

    static {
        try {
            Logger.selectLoggerLibrary((int)0);
            XMLUtils.getExceptionHandler().setExitWanted(false);
        }
        catch (Exception e2) {
            System.out.println("FreeMarker warning: " + e2);
        }
    }

    public TemplateProcessor() {
        this.cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader((Map)this.stringTemplates));
        try {
            this.cfg.setSetting("number_format", "###########.####");
        }
        catch (TemplateException e2) {
            System.out.println("FreeMarker warning: " + (Object)((Object)e2));
            e2.printStackTrace();
        }
    }

    public void setRepositoryMap(HashMap repository) {
        this.repositoryMap = repository;
    }

    public void add(String id, StringTemplateSource ts) {
        this.stringTemplates.put(id, ts);
    }

    public void clear() {
        this.stringTemplates.clear();
        this.fmTemplateNames.clear();
    }

    protected synchronized Template buildTemplateObject(String templateName, String template) throws IOException {
        Template t = null;
        templateName = this.cleanName(templateName);
        templateName = String.valueOf(templateName) + "-rnd:" + NumberUtils.getRandomInt(1000000000);
        this.stringTemplates.put(templateName, new StringTemplateSource(template));
        try {
            t = this.cfg.getTemplate(templateName);
            this.stringTemplates.remove(templateName);
        }
        catch (ParseException e2) {
            throw new RuntimeException("FreeMarker-Parsing fehlgeschlagen - " + e2.getMessage() + "\nDie Zeilennummer bezieht sich auf folgende Vorlage\n(Masken select_stmt nach SuperX-Verarbeitung mit generateSql)\n" + template);
        }
        return t;
    }

    public String process(String templateName, String fmSql, HashMap hmap, String sqldialect) throws TemplateException, IOException, SQLException {
        StringBuffer b2 = new StringBuffer();
        Iterator it = this.fmTemplateNames.iterator();
        while (it.hasNext()) {
            b2.append("<#include \"" + it.next() + "\"/>\n");
        }
        fmSql = String.valueOf(b2.toString()) + fmSql;
        templateName = this.cleanName(templateName);
        hmap.put("SQLdialect", sqldialect);
        hmap.putAll(this.repositoryMap);
        if (fmSql.indexOf("<sqlvars>") > -1) {
            this.addSqlVars(hmap, fmSql, sqldialect);
            fmSql = this.removeSqlVars(fmSql);
        }
        StringWriter out = new StringWriter();
        Template t = this.buildTemplateObject(templateName, fmSql);
        t.process((Object)hmap, (Writer)out);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    private synchronized void addSqlVars(HashMap hmap, String fmSql, String sqldialect) throws SQLException, TemplateException, IOException {
        int i2 = fmSql.indexOf("<sqlvars>");
        int i22 = fmSql.indexOf("</sqlvars>");
        String sqlvarsxml = fmSql.substring(i2, i22 + 10);
        Document doc = XMLUtils.buildDocumentFromString(sqlvarsxml, false);
        NodeList list = doc.getElementsByTagName("sqlvar");
        i2 = 0;
        while (i2 < list.getLength()) {
            Node n = list.item(i2);
            String varname = XMLUtils.getAttribValue(n, "name");
            String sql = XMLUtils.getTheValue(n);
            boolean isHash = XMLUtils.hasAttrib(n, "type") && XMLUtils.getAttribValue(n, "type").equalsIgnoreCase("hash");
            sql = this.process("sqlvar " + varname + NumberUtils.getRandomInt(99999999), "<#include \"SuperX_general\"/><#include \"SQL_lingua_franca\"/>" + sql, hmap, sqldialect);
            SxResultSet roh = new SxResultSet();
            roh = this.inServlet ? this.readFromDb(sql) : this.readFromDbApplet(sql);
            FMListe liste = new FMListe();
            boolean isSelectableItem = false;
            Object entry = "";
            int rowcount = roh.size();
            for (SxResultRow zeile : roh) {
                if (isHash) {
                    SxHash h2 = new SxHash();
                    int j2 = 0;
                    while (j2 < zeile.size()) {
                        h2.put(roh.getColumnName(j2), zeile.get(j2));
                        ++j2;
                    }
                    if (rowcount == 1) {
                        entry = h2;
                        continue;
                    }
                    liste.add(h2);
                    continue;
                }
                entry = zeile.get(0);
                if (entry == null) {
                    entry = "";
                }
                String nam = "";
                if (zeile.size() > 1) {
                    nam = (String)zeile.get(1);
                    isSelectableItem = true;
                }
                SelectableItem item = new SelectableItem(entry, nam);
                if (zeile.size() > 2) {
                    item.setStrukturInfo(zeile.get(2));
                }
                if (zeile.size() > 3) {
                    item.setStrukturInfo(zeile.get(3));
                }
                liste.add(new SelectableItemNode(item));
            }
            if (isHash && rowcount > 1 || isSelectableItem) {
                hmap.put(varname, liste);
            } else {
                hmap.put(varname, entry);
            }
            ++i2;
        }
    }

    protected SxResultSet readFromDb(String sql) throws SQLException {
        return new SxResultSet();
    }

    private String removeSqlVars(String fmSql) {
        int i2 = fmSql.indexOf("<sqlvars>");
        int i22 = fmSql.indexOf("</sqlvars>");
        return String.valueOf(fmSql.substring(0, i2)) + fmSql.substring(i22 + 10, fmSql.length());
    }

    protected String cleanName(String templateName) {
        if (templateName.indexOf("/") > -1) {
            templateName = templateName.replace('/', ' ');
        }
        if (templateName.indexOf("\\") > -1) {
            templateName = templateName.replace('\\', ' ');
        }
        return templateName;
    }

    public static void main(String[] args) {
    }

    public void setTemplates(SxResultSet rawFmTemplates) {
        this.rawFmTemplates = rawFmTemplates;
        if (rawFmTemplates == null) {
            throw new RuntimeException("Keine FreeMarker Templates geliefert");
        }
        this.clear();
        for (SxResultRow row : rawFmTemplates) {
            String name = (String)row.get(0);
            this.fmTemplateNames.add(name);
            String content = (String)row.get(1);
            this.add(name, new StringTemplateSource(content));
        }
    }

    protected SxResultSet readFromDbApplet(String sql) throws SQLException {
        SxSQL.executeAll(sql);
        SxResultSet rs = SxSQL.getResult();
        SxSQL.close();
        return rs;
    }

    public static void repositoryToMap(SxResultSet rs, HashMap map) {
        IdObjectSet riColls = new IdObjectSet();
        for (SxResultRow row : rs) {
            Object id = row.get(0);
            String name = (String)row.get(1);
            RepositoryItem ri = new RepositoryItem();
            ri.setId(id);
            ri.setName(name);
            ri.setContent((String)row.get(2));
            ri.setValidSince((java.util.Date)row.get(3));
            ri.setValidTill((java.util.Date)row.get(4));
            ri.setComment((String)row.get(5));
            RepositoryItemCollection riColl = null;
            if (riColls.containsItemWithId(id)) {
                riColl = (RepositoryItemCollection)riColls.getById(id);
            } else {
                riColl = new RepositoryItemCollection(id);
                riColls.add(riColl);
            }
            riColl.add(ri);
        }
        for (RepositoryItemCollection rcoll : riColls) {
            map.put(rcoll.getId(), rcoll);
        }
    }

    class FMListe
    implements TemplateMethodModel,
    TemplateSequenceModel {
        private static final long serialVersionUID = 1L;
        private LinkedList liste = new LinkedList();

        FMListe() {
        }

        public void add(Object o) {
            this.liste.add(o);
        }

        public Object exec(List l2) throws TemplateModelException {
            Object result = null;
            if (l2 == null) {
                throw new IllegalArgumentException("keine Argumente \u00fcbergeben");
            }
            String key = "";
            if (l2.get(0).toString().equalsIgnoreCase("get")) {
                if (l2.size() < 3) {
                    throw new TemplateModelException("Syntax: get,id-column Schl\u00fcssel - mindestens 3 Elemente n\u00f6tig");
                }
                String idcolumn = l2.get(1).toString();
                key = l2.get(2).toString();
                for (Object o : this.liste) {
                    if (!(o instanceof SxHash)) continue;
                    SxHash h2 = (SxHash)o;
                    if (!h2.containsKey(idcolumn)) {
                        throw new IllegalArgumentException("idcolumn " + idcolumn + " nicht gefunden");
                    }
                    if (!h2.get(idcolumn).toString().equals(key)) continue;
                    result = h2;
                }
            } else if (l2.get(0).toString().equalsIgnoreCase("getById")) {
                if (l2.size() < 2) {
                    throw new TemplateModelException("Syntax: getbyId,Schl\u00fcssel - mindestens 2 Elemente n\u00f6tig");
                }
                for (Object o : this.liste) {
                    SelectableItem s;
                    if (!(o instanceof SelectableItem) || !(s = (SelectableItem)o).getId().toString().equals(key)) continue;
                    result = s;
                }
            } else {
                throw new IllegalArgumentException("nur getItem,Schl\u00fcssel implementiert");
            }
            if (result == null) {
                throw new IllegalArgumentException("Element " + key + " nicht gefunden in Freemarker hash");
            }
            return result;
        }

        public TemplateModel get(int i2) throws TemplateModelException {
            Object o = this.liste.get(i2);
            SxHash result = null;
            result = o instanceof SxHash ? (SxHash)o : new DefaultObjectWrapper().wrap(o);
            return result;
        }

        public int size() throws TemplateModelException {
            return this.liste.size();
        }
    }

    class SxHash
    implements TemplateHashModel {
        private HashMap map = new HashMap();

        SxHash() {
        }

        public void put(String key, Object value) {
            this.map.put(key, value);
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if (!this.map.containsKey(key)) {
                throw new IllegalArgumentException("Kein attribut " + key + " bekannt");
            }
            Object val = this.map.get(key);
            if (val == null) {
                val = "";
            }
            SimpleScalar result = null;
            if (val instanceof String) {
                result = new SimpleScalar(val.toString());
            } else if (val instanceof Date) {
                result = new SimpleDate((Date)val);
            } else if (val instanceof Number) {
                result = new SimpleNumber((Number)val);
            }
            return result;
        }

        public boolean isEmpty() throws TemplateModelException {
            return this.map.isEmpty();
        }
    }
}

