/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.SxDBUtils;
import de.superx.bin.SxJdbcClient;
import de.superx.util.SqlStringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Iterator;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UploadRecords {
    private static String delim = "^";
    private static String mode = "exclude-row";
    private static String header = "false";
    private static String encoding = System.getProperty("file.encoding");
    private static String logfile = "../conf/logging.properties";
    private static String dbpropfile = "./conf/db.properties";
    private static String tabelle = "";
    private static String inFormat = "txt";
    private static Logger logger = Logger.getLogger(UploadRecords.class.toString());
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin.UploadRecords \n-logger:<Pfad zu logging.properties> \n-dbproperties:<Pfad zu db.properties> \n-table:<Tabellenname> \n-unl:<Dateipfad Quelldatei>(optional, default ist Tabellenname.unl) \n-delim:<delimiter>(optional, default ist ^) \n-header:<true|false>(optional, mit Feld\u00fcberschriften, default ist false)\n-mode:<stop|exclude-field|exclude-row|transaction>(optional, default is exclude-row) #Bei Fehlerhaften Daten kann das Hochladen gestoppt werden, oder der Datensatz wird \u00fcbersprungen, oder das einzelne Feld wird \u00fcbersprungen\n-inserts:<false|simple|batch>(optional, default is false) #Bei -inserts:simple und batch werden Die Rohdaten in Insert-sql-Statements \u00fcbersetzt (nur f\u00fcr Debugging-Zwecke, sehr langsam. Der Modus exclude-field ist dar\u00fcberhinaus nicht anwendbar)\n-encoding:<utf8,ISO-8859-1, default ist System.file.encoding>\n---------------------------------------------------";

    public static void upload(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        BufferedWriter out;
        int fehlerSaetze;
        int z;
        SxJdbcClient myClient;
        String _dateiPfad;
        long jetzt;
        block68: {
            File f2;
            String encodingParam;
            jetzt = new java.util.Date().getTime();
            _dateiPfad = "";
            String insert_stmt = "";
            String inserts = "false";
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-dbproperties,-table");
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.err.println(usage);
                System.exit(1);
            }
            if (GetOpts.isPresent("-logger")) {
                logfile = GetOpts.getValue("-logger");
            }
            if (GetOpts.isPresent("-dbproperties")) {
                dbpropfile = GetOpts.getValue("-dbproperties");
            }
            if (GetOpts.isPresent("-informat")) {
                inFormat = GetOpts.getValue("-informat");
            }
            if (GetOpts.isPresent("-table")) {
                tabelle = GetOpts.getValue("-table");
            }
            _dateiPfad = GetOpts.isPresent("-unl") ? GetOpts.getValue("-unl") : String.valueOf(tabelle) + ".unl";
            if (GetOpts.isPresent("-header")) {
                header = GetOpts.getValue("-header");
            }
            if (GetOpts.isPresent("-delim")) {
                delim = GetOpts.getValue("-delim");
            }
            if (GetOpts.isPresent("-encoding") && (encodingParam = GetOpts.getValue("-encoding")) != null && !encodingParam.equals("")) {
                encoding = encodingParam;
            }
            if (GetOpts.isPresent("-mode") && !(mode = GetOpts.getValue("-mode").toLowerCase()).equals("stop") && !mode.equals("exclude-field") && !mode.equals("transaction")) {
                mode = "exclude-row";
            }
            if (GetOpts.isPresent("-inserts")) {
                inserts = GetOpts.getValue("-inserts");
            }
            if (!inserts.equals("false") && mode.equals("exclude-field")) {
                System.err.println("Achtung: Im Modus 'exclude-field' sind die Optionen -inserts:simple/batch nicht anwendbar. W\u00e4hlen Sie -mode:exclude-row");
                System.err.println(usage);
                System.exit(1);
            }
            if (!(f2 = new File(logfile)).exists()) {
                throw new IOException("Datei nicht gefunden: " + logfile);
            }
            FileInputStream ins = new FileInputStream(logfile);
            LogManager MyLogManager = LogManager.getLogManager();
            MyLogManager.readConfiguration(ins);
            logfile = MyLogManager.getProperty(".level");
            logger.info("Using Loggging-Level " + logfile);
            logger.info("Upload-Mode set to " + mode + " after an error");
            logger.info("Input Format set to " + inFormat);
            logger.info("Using file encoding " + encoding);
            if (delim.equals("tab")) {
                delim = "\t";
            }
            if (delim.equals("")) {
                delim = "^";
            }
            logger.config("Starting the upload.");
            String text = "";
            int k2 = 0;
            int i2 = 0;
            boolean p = false;
            String[] headers = new String[255];
            String[] insert_cols = new String[255];
            int[] insert_types = new int[255];
            myClient = new SxJdbcClient(logger, dbpropfile);
            logger.config("Tabellenkatalog f\u00fcr " + tabelle);
            myClient.TableColumns(tabelle);
            if (!myClient.dbmd.supportsTransactions() && mode.equals("transaction")) {
                logger.severe("Achtung: Sie haben den Modus 'transaction' gew\u00e4hlt, die Datenbank unters\u00fctzt aber keine Transaktionen. W\u00e4hlen Sie einen anderen Modus.");
                logger.severe(usage);
                myClient.close();
                System.exit(1);
            }
            String db_driver = myClient.db_driver;
            i2 = 0;
            int[] types = new int[255];
            String[] names = new String[255];
            while (myClient.rs.next()) {
                names[i2] = myClient.rs.getObject("COLUMN_NAME").toString();
                types[i2] = myClient.rs.getInt("DATA_TYPE");
                logger.config("Tabellenfeld " + i2 + ": " + names[i2] + " Typ " + types[i2] + "(" + SxDBUtils.getSqlTypeName(types[i2]) + ")");
                ++i2;
            }
            int cols = i2;
            f2 = new File(_dateiPfad);
            if (!f2.exists()) {
                throw new IOException("Datei nicht gefunden: " + _dateiPfad);
            }
            File out_err = new File(String.valueOf(_dateiPfad) + ".err");
            z = 1;
            fehlerSaetze = 0;
            String errmsg = "";
            String msg = "";
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out_err), encoding));
            if (inFormat.equals("xml")) {
                Document mydomres = null;
                try {
                    DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dfactory.newDocumentBuilder();
                    FileInputStream in = new FileInputStream(f2);
                    InputSource is = new InputSource(in);
                    mydomres = builder.newDocument();
                    mydomres = builder.parse(is);
                }
                catch (SAXException e1) {
                    logger.severe("XML-Strom nicht wohlgeformt: " + e1.toString());
                }
                catch (ParserConfigurationException e2) {
                    logger.severe("XML-Strom nicht wohlgeformt: " + e2.toString());
                }
                NodeList rowlist = mydomres.getElementsByTagName("row");
                String insert_head = "insert into " + tabelle + "(";
                i2 = 0;
                while (i2 < cols) {
                    insert_head = String.valueOf(insert_head) + names[i2] + ", ";
                    ++i2;
                }
                insert_head = insert_head.substring(0, insert_head.length() - 2);
                insert_head = String.valueOf(insert_head) + ") values (";
                if (inserts.equals("false")) {
                    i2 = 0;
                    while (i2 < cols) {
                        insert_head = String.valueOf(insert_head) + "?, ";
                        insert_cols[i2] = names[i2];
                        insert_types[i2] = types[i2];
                        ++i2;
                    }
                    insert_head = insert_head.substring(0, insert_head.length() - 2);
                }
                insert_head = String.valueOf(insert_head) + ");";
                if (inserts.equals("false")) {
                    logger.info(insert_head);
                    myClient.prepareStatement(insert_head);
                } else if (myClient.dbmd.supportsBatchUpdates()) {
                    myClient.st.clearBatch();
                }
                if (mode.equals("transaction") && myClient.dbmd.supportsTransactions()) {
                    myClient.setSqlstmt("begin work;");
                    myClient.executeQueryWithinConnection();
                }
                int anz_rows = rowlist.getLength();
                i2 = 0;
                while (i2 < anz_rows) {
                    block69: {
                        block70: {
                            Node rownode = rowlist.item(i2);
                            myClient.pst.clearParameters();
                            int j2 = 0;
                            while (j2 < cols) {
                                Iterator it = XMLUtils.getChildNodeIterator(rownode);
                                while (it.hasNext()) {
                                    Node fldNode = (Node)it.next();
                                    if (!XMLUtils.getAttribValue(fldNode, "name").equalsIgnoreCase(names[j2])) continue;
                                    String feld_wert = "";
                                    try {
                                        feld_wert = XMLUtils.getTheValue(fldNode).trim();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        // empty catch block
                                    }
                                    if (inserts.equals("false")) {
                                        errmsg = UploadRecords.feld_wert_to_pst(j2, insert_types, myClient, errmsg, feld_wert);
                                        continue;
                                    }
                                    feld_wert = UploadRecords.feld_wert_to_insert(k2, insert_types, db_driver, feld_wert, "", "");
                                    insert_stmt = String.valueOf(insert_stmt) + feld_wert + ",";
                                }
                                ++j2;
                            }
                            if (inserts.equals("false")) {
                                if (errmsg.startsWith("Error")) {
                                    msg = "  Conversion Error in Load-File Line " + i2 + ": " + errmsg;
                                    out.write(msg);
                                    System.err.println(msg);
                                    ++fehlerSaetze;
                                    if (mode.equals("stop")) break block68;
                                }
                                try {
                                    myClient.pst.executeUpdate();
                                    break block69;
                                }
                                catch (SQLException e2) {
                                    logger.severe("Fehler beim Ausf\u00fchren des " + z + ". Insert:\n " + errmsg + "\nFehler: " + e2.toString());
                                    msg = "  SQL-Error in Load-File Line " + z + ": " + errmsg;
                                    out.write(msg);
                                    System.err.println(msg);
                                    ++fehlerSaetze;
                                    if (!mode.equals("stop")) break block69;
                                    break;
                                }
                            }
                            insert_stmt = String.valueOf(insert_stmt.substring(0, insert_stmt.length() - 1)) + ");";
                            if (inserts.equals("simple") || !myClient.dbmd.supportsBatchUpdates()) {
                                try {
                                    myClient.st.execute(insert_stmt);
                                    break block70;
                                }
                                catch (SQLException e3) {
                                    logger.severe("Fehler beim Ausf\u00fchren des " + z + ". Insert:\n " + insert_stmt + "\nFehler: " + e3.toString());
                                    msg = String.valueOf(text) + "  #SQL-Error in Load-File Line " + z + ": " + insert_stmt + " Fehler: " + e3.toString();
                                    out.write(msg);
                                    ++fehlerSaetze;
                                    if (!mode.equals("stop")) break block70;
                                    break;
                                }
                            }
                            myClient.st.addBatch(insert_stmt);
                        }
                        logger.config(insert_stmt);
                        try {
                            if (inserts.equals("batch") && myClient.dbmd.supportsBatchUpdates()) {
                                k2 = myClient.st.executeBatch().length;
                            }
                        }
                        catch (SQLException e4) {
                            logger.severe("SQL_Fehler" + e4.toString());
                            k2 = 0;
                            ++fehlerSaetze;
                        }
                    }
                    ++z;
                    ++i2;
                }
            } else {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f2), encoding));
                String insert_head = UploadRecords.createInsertHeader(headers, insert_cols, insert_types, types, names, cols, in, inserts);
                if (inserts.equals("false")) {
                    logger.info(insert_head);
                    myClient.prepareStatement(insert_head);
                } else if (myClient.dbmd.supportsBatchUpdates()) {
                    myClient.st.clearBatch();
                }
                if (mode.equals("transaction") && myClient.dbmd.supportsTransactions()) {
                    myClient.setSqlstmt("begin work;");
                    myClient.executeQueryWithinConnection();
                }
                while ((text = in.readLine()) != null) {
                    block71: {
                        block72: {
                            if (text.endsWith("\\")) {
                                text = text.substring(0, text.length() - 1);
                                String tt = in.readLine();
                                if (tt != null) {
                                    text = String.valueOf(text) + "\n" + tt;
                                    while (tt.endsWith("\\")) {
                                        text = text.substring(0, text.length() - 1);
                                        tt = in.readLine();
                                        if (tt == null) continue;
                                        text = String.valueOf(text) + "\n" + tt;
                                    }
                                }
                            }
                            insert_stmt = insert_head;
                            k2 = 0;
                            i2 = 0;
                            p = false;
                            msg = null;
                            if (inserts.equals("false")) {
                                logger.config("Creating prepared Statement");
                                String prepare = UploadRecords.createPreparedStatement(insert_stmt, text, k2, i2, insert_types, myClient, db_driver);
                                if (prepare.startsWith("Error")) {
                                    msg = String.valueOf(text) + "  #Conversion Error in Load-File Line " + z + ": " + prepare;
                                    out.write(msg);
                                    System.err.println(msg);
                                    ++fehlerSaetze;
                                    if (mode.equals("stop")) break;
                                }
                                try {
                                    myClient.pst.executeUpdate();
                                    break block71;
                                }
                                catch (SQLException e5) {
                                    logger.severe("Fehler beim Ausf\u00fchren des " + z + ". Insert:\n " + prepare + "\nFehler: " + e5.toString());
                                    msg = String.valueOf(text) + "  #SQL-Error in Load-File Line " + z + ": " + prepare;
                                    out.write(msg);
                                    System.err.println(msg);
                                    ++fehlerSaetze;
                                    if (mode.equals("stop")) {
                                        break;
                                    }
                                    break block71;
                                }
                            }
                            logger.config("Creating insert Statement");
                            insert_stmt = UploadRecords.createInsertStatement(insert_stmt, text, k2, i2, insert_types, myClient, db_driver);
                            if (inserts.equals("simple") || !myClient.dbmd.supportsBatchUpdates()) {
                                try {
                                    myClient.st.execute(insert_stmt);
                                    break block72;
                                }
                                catch (SQLException e6) {
                                    logger.severe("Fehler beim Ausf\u00fchren des " + z + ". Insert:\n " + insert_stmt + "\nFehler: " + e6.toString());
                                    msg = String.valueOf(text) + "  #SQL-Error in Load-File Line " + z + ": " + insert_stmt + " Fehler: " + e6.toString();
                                    out.write(msg);
                                    ++fehlerSaetze;
                                    if (mode.equals("stop")) {
                                        break;
                                    }
                                    break block72;
                                }
                            }
                            myClient.st.addBatch(insert_stmt);
                        }
                        logger.config(insert_stmt);
                        try {
                            if (inserts.equals("batch") && myClient.dbmd.supportsBatchUpdates()) {
                                k2 = myClient.st.executeBatch().length;
                            }
                        }
                        catch (SQLException e7) {
                            logger.severe("SQL_Fehler" + e7.toString());
                            k2 = 0;
                            ++fehlerSaetze;
                        }
                    }
                    ++z;
                }
                in.close();
            }
        }
        long erstrecht = new java.util.Date().getTime();
        System.out.println(String.valueOf(z - 1) + " Rows inserted in " + (erstrecht - jetzt) / 1000L + " Sec.");
        if (fehlerSaetze > 0) {
            System.err.println(String.valueOf(fehlerSaetze) + " Rows could not be inserted. Check " + _dateiPfad + ".err" + " for Details");
            if (mode.equals("transaction") && myClient.dbmd.supportsTransactions()) {
                myClient.setSqlstmt("rollback;");
                myClient.executeQueryWithinConnection();
                System.err.println("Transaction rolled back. Nothing changed.");
            }
        }
        out.flush();
        out.close();
        if (mode.equals("transaction") && myClient.dbmd.supportsTransactions()) {
            myClient.setSqlstmt("commit work;");
            myClient.executeQueryWithinConnection();
        }
        logger.info("Now closing the connection");
        myClient.close();
    }

    private static String createInsertHeader(String[] headers, String[] insert_cols, int[] insert_types, int[] types, String[] names, int cols, BufferedReader in, String inserts) throws IOException {
        int i2 = 0;
        int k2 = 0;
        int p = 0;
        String insert_head = "insert into " + tabelle;
        if (header.equals("true")) {
            String text = in.readLine();
            if (text != null) {
                if (!text.endsWith(delim)) {
                    text = String.valueOf(text) + delim;
                }
                insert_head = String.valueOf(insert_head) + "(";
                logger.info("Reading headers in file");
                do {
                    if ((p = text.indexOf(delim, i2)) <= -1) continue;
                    headers[k2] = text.substring(i2, p);
                    boolean headerExists = false;
                    int b2 = 0;
                    while (b2 < cols) {
                        if (headers[k2].equalsIgnoreCase(names[b2])) {
                            headerExists = true;
                        }
                        ++b2;
                    }
                    if (!headerExists) {
                        throw new IOException("Error: header " + headers[k2] + " does not exist");
                    }
                    logger.info("header " + headers[k2] + " exists");
                    if (header.equals("true")) {
                        insert_head = String.valueOf(insert_head) + headers[k2] + ", ";
                    }
                    ++k2;
                    i2 = p + 1;
                } while (p > -1);
            }
        } else {
            i2 = 0;
            while (i2 < cols) {
                headers[i2] = names[i2];
                ++i2;
            }
            if (header.equals("true")) {
                insert_head = String.valueOf(insert_head) + names[i2] + ", ";
            }
        }
        i2 = 0;
        while (i2 < cols) {
            k2 = 0;
            while (k2 < cols) {
                if (names[i2].equals(headers[k2])) {
                    insert_cols[k2] = names[i2];
                    insert_types[k2] = types[i2];
                }
                ++k2;
            }
            ++i2;
        }
        if (header.equals("true")) {
            insert_head = insert_head.substring(0, insert_head.length() - 2);
            insert_head = String.valueOf(insert_head) + ") values(";
        } else {
            insert_head = String.valueOf(insert_head) + " values(";
        }
        if (inserts.equals("false")) {
            i2 = 0;
            while (i2 < cols) {
                k2 = 0;
                while (k2 < cols) {
                    if (names[i2].equals(headers[k2])) {
                        insert_head = String.valueOf(insert_head) + "?, ";
                    }
                    ++k2;
                }
                ++i2;
            }
            insert_head = insert_head.substring(0, insert_head.length() - 2);
            insert_head = String.valueOf(insert_head) + ");";
        }
        return insert_head;
    }

    private static String createPreparedStatement(String insert_stmt, String text, int k2, int i2, int[] insert_types, SxJdbcClient myClient, String db_driver) throws SQLException {
        int p;
        String errmsg = "";
        myClient.pst.clearParameters();
        do {
            if (!text.endsWith(delim)) {
                text = String.valueOf(text) + delim;
            }
            if ((p = text.indexOf(delim, i2)) > 0 && text.substring(p - 1, p).equals("\\")) {
                p = text.indexOf(delim, p + 1);
            }
            if (p <= -1) continue;
            String feld_wert = text.substring(i2, p);
            if (feld_wert != null && feld_wert.indexOf("\\\\n") > 0) {
                feld_wert = StringUtils.replace(feld_wert, "\\\\n", "\\n");
            }
            if (feld_wert != null && feld_wert.indexOf("\\" + delim) > 0) {
                feld_wert = StringUtils.replace(feld_wert, "\\", "");
            }
            errmsg = UploadRecords.feld_wert_to_pst(k2, insert_types, myClient, errmsg, feld_wert);
            ++k2;
            i2 = p + 1;
        } while (p > -1);
        return errmsg;
    }

    private static String feld_wert_to_pst(int k2, int[] insert_types, SxJdbcClient myClient, String errmsg, String feld_wert) throws SQLException {
        int spaltenzahl = insert_types.length;
        if (k2 >= spaltenzahl) {
            errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, "Anzahl Spalten in Datei ist " + k2 + ", aber es sollten nur " + (spaltenzahl - 1) + " Spalten sein. Bitte pr\u00fcfen Sie das Trennzeichen");
        } else if (feld_wert.equals("")) {
            try {
                myClient.pst.setNull(k2 + 1, insert_types[k2]);
            }
            catch (SQLException e1) {
                errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
            }
        } else {
            switch (insert_types[k2]) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    try {
                        int myInt = Integer.parseInt(feld_wert);
                        myClient.pst.setInt(k2 + 1, myInt);
                    }
                    catch (NumberFormatException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    break;
                }
                case 6: {
                    try {
                        float myFloat = Float.parseFloat(feld_wert);
                        myClient.pst.setFloat(k2 + 1, myFloat);
                    }
                    catch (NumberFormatException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    try {
                        double myDouble = Double.parseDouble(feld_wert);
                        myClient.pst.setDouble(k2 + 1, myDouble);
                    }
                    catch (NumberFormatException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    break;
                }
                default: {
                    try {
                        myClient.pst.setString(k2 + 1, feld_wert);
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    break;
                }
                case -1: {
                    ByteArrayInputStream by = new ByteArrayInputStream(feld_wert.getBytes());
                    myClient.pst.setAsciiStream(k2 + 1, (InputStream)by, feld_wert.length());
                    break;
                }
                case 91: {
                    try {
                        Date datum = DateUtils.parse(feld_wert);
                        feld_wert = DateUtils.formatUS(datum);
                        myClient.pst.setDate(k2 + 1, Date.valueOf(feld_wert));
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (ParseException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (IllegalArgumentException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    break;
                }
                case 92: {
                    try {
                        myClient.pst.setTime(k2 + 1, Time.valueOf(feld_wert));
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (IllegalArgumentException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    break;
                }
                case 93: {
                    try {
                        java.util.Date datum = DateUtils.dateTimeParse(feld_wert);
                        feld_wert = DateUtils.dateTimeFormatUS(datum);
                        myClient.pst.setTimestamp(k2 + 1, Timestamp.valueOf(String.valueOf(feld_wert) + ".0"));
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (ParseException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    catch (IllegalArgumentException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                    break;
                }
                case -7: {
                    try {
                        boolean wf = Boolean.getBoolean(feld_wert);
                        myClient.pst.setBoolean(k2 + 1, wf);
                        break;
                    }
                    catch (SQLException e1) {
                        errmsg = String.valueOf(errmsg) + UploadRecords.conversionException(k2, e1.toString());
                        UploadRecords.setFieldToNull(k2, insert_types, myClient);
                    }
                }
            }
        }
        return errmsg;
    }

    private static String createInsertStatement(String insert_stmt, String text, int k2, int i2, int[] insert_types, SxJdbcClient myClient, String db_driver) throws SQLException {
        int p;
        do {
            if ((p = text.indexOf(delim, i2)) <= -1) continue;
            String delim1 = "";
            String delim2 = "";
            String feld_wert = text.substring(i2, p);
            feld_wert = UploadRecords.feld_wert_to_insert(k2, insert_types, db_driver, feld_wert, delim1, delim2);
            insert_stmt = String.valueOf(insert_stmt) + feld_wert + ",";
            ++k2;
            i2 = p + 1;
        } while (p > -1);
        insert_stmt = String.valueOf(insert_stmt.substring(0, insert_stmt.length() - 1)) + ");";
        return insert_stmt;
    }

    private static String feld_wert_to_insert(int k2, int[] insert_types, String db_driver, String feld_wert, String delim1, String delim2) {
        if (feld_wert.equals("")) {
            feld_wert = null;
        } else {
            switch (insert_types[k2]) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    delim1 = "";
                    delim2 = "";
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    delim1 = "'";
                    delim2 = "'";
                    break;
                }
                case 91: {
                    if (db_driver.equals("com.informix.jdbc.IfxDriver")) {
                        delim1 = "date('";
                        delim2 = "')";
                        break;
                    }
                    try {
                        Date datum = DateUtils.parse(feld_wert);
                        feld_wert = DateUtils.formatUS(datum);
                        delim1 = "'";
                        delim2 = "'";
                    }
                    catch (ParseException e2) {
                        logger.warning("Feldwert " + feld_wert + "konnte nicht zum Datum konvertiert werden: " + e2.toString());
                        feld_wert = null;
                    }
                    break;
                }
                case 92: {
                    delim1 = db_driver.equals("org.postgresql.Driver") ? "time_val('" : "('";
                    delim2 = "')";
                    break;
                }
                case 93: {
                    if (db_driver.equals("com.informix.jdbc.IfxDriver")) {
                        delim1 = "to_date('";
                    } else {
                        try {
                            java.util.Date datum = DateUtils.dateTimeParse(feld_wert);
                            feld_wert = DateUtils.dateTimeFormatUS(datum);
                            delim1 = "'";
                            delim2 = "'";
                        }
                        catch (ParseException e3) {
                            logger.warning("Feldwert " + feld_wert + "konnte nicht zum DateTime konvertiert werden: " + e3.toString());
                            feld_wert = null;
                        }
                    }
                    delim2 = "')";
                    break;
                }
                case -7: {
                    delim1 = "'";
                    delim2 = "'";
                    break;
                }
                default: {
                    delim1 = "'";
                    delim2 = "'";
                }
            }
            feld_wert = String.valueOf(delim1) + SqlStringUtils.escapeSpecialChars(feld_wert) + delim2;
        }
        return feld_wert;
    }

    private static void setFieldToNull(int k2, int[] insert_types, SxJdbcClient myClient) {
        if (mode.equals("exclude-field")) {
            try {
                myClient.pst.setNull(k2 + 1, insert_types[k2]);
            }
            catch (SQLException e3) {
                logger.warning("Invalid Field " + (k2 + 1) + " could not be set to null");
            }
        }
    }

    private static String conversionException(int k2, String error) {
        String err_msg = "";
        err_msg = "Error in Column " + (k2 + 1) + ": " + error.toString() + "; ";
        logger.info(err_msg);
        return err_msg;
    }

    public static void instructions() {
        System.out.println("SuperX @version@\n");
        System.out.println("\nDieses Javaprogramm l\u00e4dt Inhalte einer Datei in eine Tabelle hoch");
        System.out.println(usage);
        System.out.println("Der Logging-Level wird in ../conf/logging.properties konfiguriert, der DB-Zugriff in ../conf/db.properties ");
        System.out.println("Default:\n java upload_records <Tabellenname> <Dateipfad> <TAB> false");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            UploadRecords.upload(args);
        }
        catch (Exception ex) {
            System.err.println("Upload fehlgeschlagen: " + ex);
            System.exit(1);
        }
    }
}

