/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.baseobjects.NamedObject;
import de.memtext.baseobjects.coll.NamedIdObjectSet;
import de.memtext.util.StringUtils;
import de.superx.applet.Sachgebiet;
import de.superx.applet.Sachgebiete;
import de.superx.applet.SxDate;
import de.superx.applet.SxDefaults;
import de.superx.applet.SxForm;
import de.superx.applet.SxSQL;
import de.superx.applet.SxUtils;
import de.superx.common.SxResultRow;
import de.superx.common.XilParser;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class MaskeninfoElement
extends NamedObject {
    private static final long serialVersionUID = 1L;
    private Properties xilProps = new Properties();
    private Vector felderinfos;
    private Integer tid;
    private Integer breite;
    private Integer hoehe;
    private NamedIdObjectSet sachgebiete = new NamedIdObjectSet();
    private boolean isSqlInHeaders = false;
    private Vector spaltenExplanations;
    private String xilPropListString;
    private String selectStmt;
    private String cleanupStmt;
    private String hinweis;
    private Date stand;
    private String erlaueterung;
    private XilParser xilParser = new XilParser();
    private SxForm maskeForm;

    MaskeninfoElement() {
    }

    public void setMaskeForm(SxForm maskeForm) {
        this.maskeForm = maskeForm;
    }

    protected void init(Vector vectorMaskeninfoEntries) throws IOException {
        Vector vectorCurrentMask = (Vector)vectorMaskeninfoEntries.elementAt(0);
        this.setSelectStmt(vectorCurrentMask.elementAt(1));
        this.setXilPropListString(vectorCurrentMask.elementAt(2));
        this.setCleanupStmt(vectorCurrentMask.elementAt(3));
        this.setBreite((Integer)vectorCurrentMask.elementAt(4));
        this.setHoehe((Integer)vectorCurrentMask.elementAt(5));
        this.stand = new Date(1L);
        Object tmpDate = vectorCurrentMask.elementAt(6);
        if (tmpDate != null) {
            try {
                this.stand = (Date)tmpDate;
            }
            catch (ClassCastException e2) {
                Timestamp mytimestamp = (Timestamp)tmpDate;
                long mytimestampwert = mytimestamp.getTime();
                this.stand = new Date(mytimestampwert);
            }
        }
        this.setHinweis(vectorCurrentMask.elementAt(7));
        this.setErlaueterung((String)vectorCurrentMask.elementAt(8));
        Object expl = vectorCurrentMask.elementAt(9);
        if (!(expl instanceof SxResultRow)) {
            String msg = "Es wurde ein ResultRow mit Erl\u00e4uterungen erwartet (SuperXDBServlet. addExplanations). statt dessen wurde geliefert: ";
            msg = expl == null ? String.valueOf(msg) + "null" : String.valueOf(msg) + " ein " + expl.getClass() + " :" + expl;
            throw new IllegalArgumentException(msg);
        }
        this.spaltenExplanations = new Vector();
        this.spaltenExplanations.addAll((SxResultRow)vectorCurrentMask.elementAt(9));
    }

    boolean hasSpaltenExplanations() {
        boolean result = false;
        for (String expl : this.spaltenExplanations) {
            if (expl == null || expl.trim().equals("")) continue;
            result = true;
            break;
        }
        return result;
    }

    StringBuffer getSpaltenExplanationText() {
        StringBuffer buf = new StringBuffer("");
        int i2 = 0;
        while (i2 < this.spaltenExplanations.size()) {
            String expl = (String)this.spaltenExplanations.get(i2);
            if (expl != null && !expl.trim().equals("")) {
                buf.append(String.valueOf(expl) + "<br><br>");
            }
            ++i2;
        }
        return buf;
    }

    public void adaptExplanation(int pos, String neu) {
        String expl;
        if (this.spaltenExplanations.size() > pos && (expl = (String)this.spaltenExplanations.get(pos)).indexOf("</b>") > -1) {
            expl = "<b>" + neu + expl.substring(expl.indexOf("</b>"), expl.length());
            System.out.println("neu:" + expl);
            this.spaltenExplanations.setElementAt(expl, pos);
        }
    }

    Integer getBreite() {
        return this.breite;
    }

    String getStandString() {
        String d_str = "";
        if (this.getStand() != null) {
            d_str = SxDate.toString(this.getStand());
        }
        return d_str;
    }

    String getCleanupStmt() {
        return this.cleanupStmt;
    }

    String getHinweis() {
        return this.hinweis;
    }

    Integer getHoehe() {
        return this.hoehe;
    }

    String getSelectStmt() {
        return this.selectStmt;
    }

    Date getStand() {
        return this.stand;
    }

    Integer getTid() {
        return this.tid;
    }

    private String getTmpXilPropListString() throws TemplateException, IOException, SQLException {
        String tmpxil = SxUtils.generateSQL(this.maskeForm, this.xilPropListString);
        HashMap map = this.maskeForm.getHashMap(this.getTid());
        tmpxil = SxSQL.templateProcessor.process("XIL-Maske " + this.getName(), tmpxil, map, (String)SxDefaults.getPropertyValue("SxDB"));
        ByteArrayInputStream bis = new ByteArrayInputStream(tmpxil.getBytes());
        this.xilProps.load(bis);
        return tmpxil;
    }

    void setBreite(Integer integer) {
        this.breite = integer;
    }

    void setCleanupStmt(Object stmt) {
        if (stmt == null) {
            stmt = "";
        }
        this.cleanupStmt = (String)stmt;
    }

    void setHinweis(Object hin) {
        this.hinweis = null;
        if (hin != null) {
            this.hinweis = hin.toString();
        }
    }

    void setHoehe(Integer integer) {
        this.hoehe = integer;
    }

    void setSelectStmt(Object stmt) {
        if (stmt == null) {
            throw new IllegalArgumentException("null ist nicht erlaubt f\u00fcr select stmt");
        }
        this.selectStmt = (String)stmt;
    }

    private void setStand(Date date) {
        this.stand = date;
    }

    void setTid(Integer integer) {
        this.tid = integer;
    }

    void setXilPropListString(Object xil) {
        if (xil == null) {
            throw new IllegalArgumentException("null ist nicht erlaubt f\u00fcr xil");
        }
        StringBuffer buf = new StringBuffer(xil.toString());
        StringUtils.replace(buf, "\\000", "\\n");
        this.xilPropListString = buf.toString();
        this.xilParser.setXilString(this.xilPropListString);
    }

    Properties getXilProps() {
        return this.xilProps;
    }

    Vector getFelderinfos() {
        return this.felderinfos;
    }

    void setFelderinfos(Vector vector) {
        this.felderinfos = vector;
    }

    void clear() {
        this.felderinfos = null;
        this.hoehe = null;
        this.breite = null;
        this.tid = null;
        this.hinweis = null;
        this.cleanupStmt = null;
        this.selectStmt = null;
        this.xilPropListString = null;
        this.stand = null;
    }

    void readSachgebiete() throws SQLException {
        this.sachgebiete.clear();
        SxSQL.executeQuery("select sachgebiete_id from sachgeb_maske_bez where maskeninfo_id=" + this.getTid());
        for (Vector row : SxSQL.getResultVector()) {
            Sachgebiet sachgeb = (Sachgebiet)Sachgebiete.getById(row.get(0));
            this.sachgebiete.add(sachgeb);
        }
    }

    boolean isSqlInHeaders() throws TemplateException, IOException, SQLException {
        this.getHeaderVector();
        return this.isSqlInHeaders;
    }

    Vector getHeaderVector() throws TemplateException, IOException, SQLException {
        Vector<String> header = new Vector<String>();
        int pos = 0;
        int end_pos = 0;
        int offset = 0;
        String tmpxil = this.getTmpXilPropListString();
        int len = tmpxil.length();
        String search_str = "heading_text=\"";
        String header_str = null;
        int search_len = search_str.length();
        this.isSqlInHeaders = false;
        while (offset < len) {
            pos = tmpxil.indexOf(search_str, offset);
            if (pos == -1 || (end_pos = tmpxil.indexOf("\"", pos + search_len)) == -1) break;
            header_str = tmpxil.substring(pos + search_len, end_pos);
            if (header_str.trim().startsWith("<<SQL>>")) {
                this.isSqlInHeaders = true;
            }
            header.addElement(header_str);
            offset = pos + search_len + header_str.length() + 1;
        }
        return header;
    }

    Vector getWidthVector() throws TemplateException, IOException, SQLException {
        this.xilParser.setXilString(this.getTmpXilPropListString());
        return this.xilParser.getWidths();
    }

    public String getErlaueterung() {
        return this.erlaueterung;
    }

    public void setErlaueterung(String erlaueterung) {
        this.erlaueterung = erlaueterung;
    }

    public int getFixedColumns() {
        String fx = this.getXilProps().getProperty("fixed_columns", "1");
        int fc = Integer.parseInt(fx);
        if (fc == 1 && this.xilPropListString.toLowerCase().indexOf("\"ebene\"") > -1) {
            fc = 2;
        }
        return fc;
    }
}

