/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.FileUtils;
import de.memtext.util.RawFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtils {
    private static ConsoleHandler rawConsoleHandler = new ConsoleHandler();

    static {
        RawFormatter rf = new RawFormatter();
        rf.setTimeWanted(true);
        rawConsoleHandler.setFormatter(rf);
    }

    private LogUtils() {
    }

    public static void initRaw(String loggername) {
        LogUtils.initRaw(Logger.getLogger(loggername));
    }

    public static void initRaw(Logger logger) {
        logger.addHandler(rawConsoleHandler);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.WARNING);
    }

    public static void initRawFile(String loggername, String filename, int maxKB, int count, boolean append, boolean tryLckDeletion) throws SecurityException, IOException {
        if (tryLckDeletion) {
            if (count > 1) {
                throw new IllegalArgumentException("tryLckDeletion doesn't work for >1 file");
            }
            File f2 = new File(String.valueOf(filename) + ".lck");
            if (f2.exists()) {
                f2.delete();
            }
        }
        if (count > 1) {
            filename = FileUtils.addToEndOfFileName(filename, "%g");
        }
        FileHandler fh = new FileHandler(filename, maxKB * 1024, count, append);
        fh.setFormatter(new RawFormatter());
        Logger.getLogger(loggername).addHandler(fh);
        Logger.getLogger(loggername).setUseParentHandlers(false);
    }

    public static void close(String loggername) {
        Handler[] h2 = Logger.getLogger(loggername).getHandlers();
        int i2 = 0;
        while (i2 < h2.length) {
            h2[i2].close();
            ++i2;
        }
    }

    public static void main(String[] args) {
        try {
            LogUtils.initRawFile("superx_10000", "d:\\temp\\superx_10000.log", 2000, 1, true, true);
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        Logger.getLogger("superx_10000").log(Level.SEVERE, "sql: \u00f6alskjf");
    }
}

