/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;

public class NonEmptyAttributeFilter
implements AttributeVisitor {
    private final AttributeVisitor attributeVisitor;

    public NonEmptyAttributeFilter(AttributeVisitor attributeVisitor) {
        this.attributeVisitor = attributeVisitor;
    }

    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        unknownAttribute.accept(clazz, this.attributeVisitor);
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        sourceFileAttribute.accept(clazz, this.attributeVisitor);
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        sourceDirAttribute.accept(clazz, this.attributeVisitor);
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        if (innerClassesAttribute.u2classesCount > 0) {
            innerClassesAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.accept(clazz, this.attributeVisitor);
    }

    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        deprecatedAttribute.accept(clazz, this.attributeVisitor);
    }

    public void visitDeprecatedAttribute(Clazz clazz, Field field, DeprecatedAttribute deprecatedAttribute) {
        deprecatedAttribute.accept(clazz, field, this.attributeVisitor);
    }

    public void visitDeprecatedAttribute(Clazz clazz, Method method, DeprecatedAttribute deprecatedAttribute) {
        deprecatedAttribute.accept(clazz, method, this.attributeVisitor);
    }

    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        syntheticAttribute.accept(clazz, this.attributeVisitor);
    }

    public void visitSyntheticAttribute(Clazz clazz, Field field, SyntheticAttribute syntheticAttribute) {
        syntheticAttribute.accept(clazz, field, this.attributeVisitor);
    }

    public void visitSyntheticAttribute(Clazz clazz, Method method, SyntheticAttribute syntheticAttribute) {
        syntheticAttribute.accept(clazz, method, this.attributeVisitor);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.accept(clazz, this.attributeVisitor);
    }

    public void visitSignatureAttribute(Clazz clazz, Field field, SignatureAttribute signatureAttribute) {
        signatureAttribute.accept(clazz, field, this.attributeVisitor);
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        signatureAttribute.accept(clazz, method, this.attributeVisitor);
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        constantValueAttribute.accept(clazz, field, this.attributeVisitor);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        if (exceptionsAttribute.u2exceptionIndexTableLength > 0) {
            exceptionsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.accept(clazz, method, this.attributeVisitor);
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        if (stackMapAttribute.u2stackMapFramesCount > 0) {
            stackMapAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        if (stackMapTableAttribute.u2stackMapFramesCount > 0) {
            stackMapTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        if (lineNumberTableAttribute.u2lineNumberTableLength > 0) {
            lineNumberTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        if (localVariableTableAttribute.u2localVariableTableLength > 0) {
            localVariableTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        if (localVariableTypeTableAttribute.u2localVariableTypeTableLength > 0) {
            localVariableTypeTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        if (runtimeVisibleAnnotationsAttribute.u2annotationsCount > 0) {
            runtimeVisibleAnnotationsAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Field field, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        if (runtimeVisibleAnnotationsAttribute.u2annotationsCount > 0) {
            runtimeVisibleAnnotationsAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        if (runtimeVisibleAnnotationsAttribute.u2annotationsCount > 0) {
            runtimeVisibleAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        if (runtimeInvisibleAnnotationsAttribute.u2annotationsCount > 0) {
            runtimeInvisibleAnnotationsAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Field field, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        if (runtimeInvisibleAnnotationsAttribute.u2annotationsCount > 0) {
            runtimeInvisibleAnnotationsAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        if (runtimeInvisibleAnnotationsAttribute.u2annotationsCount > 0) {
            runtimeInvisibleAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        if (runtimeVisibleParameterAnnotationsAttribute.u2parametersCount > 0) {
            runtimeVisibleParameterAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        if (runtimeInvisibleParameterAnnotationsAttribute.u2parametersCount > 0) {
            runtimeInvisibleParameterAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.accept(clazz, method, this.attributeVisitor);
    }
}

