/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.google.common.base.Splitter;
import de.memtext.util.XMLUtils;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.SuperXManager;
import de.superx.util.SqlStringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SxSQL_Server {
    private static final char SQL_STRING_DELIM = '\'';
    private static final char SQL_STMT_SEP = ';';
    private static final String SQL_STMT_SEP_SUBST = "@@SEMICOLON@@";
    private String mandantenID = "default";
    private int updateCount = -1;
    private int numberOfColumns = -1;
    public static final String DEFAULT_MANDANTEN_ID = "default";
    private ResultSetMetaData metaData;

    public SxSQL_Server(String mandantenID) {
        this.mandantenID = mandantenID;
        XMLUtils.getExceptionHandler().setExitWanted(false);
    }

    private static String removeSemicolonExpansionSequence(String fromThis) {
        String result = fromThis;
        while (result.contains(SQL_STMT_SEP_SUBST)) {
            result = result.replace(SQL_STMT_SEP_SUBST, "");
        }
        return result;
    }

    public synchronized void executeQuery(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        statement.setMaxRows(SuperXManager.maxRows);
        String value = "";
        Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "Abfrage ausf\u00fchren:" + query);
        try {
            int column;
            ResultSet resultSet = statement.executeQuery(query);
            this.metaData = resultSet.getMetaData();
            this.numberOfColumns = this.metaData.getColumnCount();
            String[] columnName = new String[this.numberOfColumns];
            String[] columnLabel = new String[this.numberOfColumns];
            int[] columnDisplaySize = new int[this.numberOfColumns];
            int[] columnType = new int[this.numberOfColumns];
            int[] scales = new int[this.numberOfColumns];
            boolean[] isWritable = new boolean[this.numberOfColumns];
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnName[column] = this.metaData.getColumnName(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnLabel[column] = this.metaData.getColumnLabel(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnDisplaySize[column] = this.metaData.getColumnDisplaySize(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnType[column] = this.adaptColumType(this.metaData.getColumnType(column + 1));
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                scales[column] = this.metaData.getScale(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                isWritable[column] = this.metaData.isWritable(column + 1);
            }
            int naturalOrderNo = 1;
            while (resultSet.next()) {
                SxResultRow newRow = new SxResultRow(this.numberOfColumns, naturalOrderNo++);
                block29: for (int i = 0; i < this.numberOfColumns; ++i) {
                    switch (this.metaData.getColumnType(i + 1)) {
                        case 1: 
                        case 12: {
                            String s;
                            try {
                                s = resultSet.getString(i + 1);
                                value = s == null ? "" : s.trim();
                            }
                            catch (Exception e) {
                                value = "";
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "char-feld " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                            }
                            if (value == null || value.equals("null")) {
                                newRow.add(new String(""));
                                continue block29;
                            }
                            newRow.add(value);
                            continue block29;
                        }
                        case -1: {
                            String s;
                            try {
                                s = resultSet.getString(i + 1);
                                value = s == null ? "" : s.trim();
                            }
                            catch (Exception e) {
                                value = "";
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Blob " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                            }
                            if (value == null || value.equals("null")) {
                                newRow.add(new String(""));
                                continue block29;
                            }
                            newRow.add(value);
                            continue block29;
                        }
                        case 4: {
                            try {
                                newRow.add(resultSet.getObject(i + 1));
                            }
                            catch (Exception e) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Integer " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                                newRow.add(null);
                            }
                            continue block29;
                        }
                        case 91: {
                            Object myObj;
                            try {
                                myObj = resultSet.getObject(i + 1);
                                newRow.add(myObj);
                            }
                            catch (Exception e) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Datum " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                                newRow.add(null);
                            }
                            continue block29;
                        }
                        case 93: {
                            Object myObj;
                            try {
                                myObj = resultSet.getObject(i + 1);
                                newRow.add(myObj);
                            }
                            catch (Exception e) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Timestamp " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                                newRow.add(null);
                            }
                            continue block29;
                        }
                        default: {
                            try {
                                newRow.add(resultSet.getObject(i + 1));
                                continue block29;
                            }
                            catch (Exception e) {
                                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Unbekanntes Objekt " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                                newRow.add(null);
                            }
                        }
                    }
                }
                rows.add(newRow);
            }
            gesamt.setColumnCount(this.numberOfColumns);
            gesamt.setAndAdaptColumnNames(columnName);
            gesamt.setColumnLabels(columnLabel);
            gesamt.setColumnDisplaySizes(columnDisplaySize);
            gesamt.setColumnTypes(columnType);
            gesamt.setScales(scales);
            gesamt.setisWritable(isWritable);
            gesamt.setRows(rows);
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, e.toString());
            gesamt.setError_String(e.toString());
        }
        catch (Exception e) {
            Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Allgemeiner Fehler beim DB-Zugriff:" + e.toString());
            gesamt.setError_String(e.toString());
        }
    }

    private synchronized void executePst(PreparedStatement pst, String args) throws NumberFormatException, SQLException {
        int i = args.indexOf("<pstexec>");
        int i2 = args.indexOf("</pstexec>");
        if (i == -1 || i2 == -1) {
            throw new IllegalArgumentException("<pstexec> nicht XML konform definiert");
        }
        XMLUtils.getExceptionHandler().setExitWanted(false);
        Document doc = null;
        try {
            doc = XMLUtils.buildDocumentFromString2(args, false);
        }
        catch (Exception e) {
            System.err.println(args);
            throw new SQLException("Xml-Parsingproblem " + e);
        }
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("arg");
            for (i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                String no = XMLUtils.getAttribValue(n, "no");
                String datatype = "string";
                if (XMLUtils.hasAttrib(n, "type")) {
                    datatype = XMLUtils.getAttribValue(n, "type");
                }
                String val = XMLUtils.getTheValue(n);
                pst.setString(Integer.parseInt(no), val);
            }
            int rows = pst.executeUpdate();
            System.out.println(rows + " r");
        }
    }

    public synchronized void executeALL(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        gesamt.setAktuelleNachricht("");
        gesamt.setError_String("");
        if (SuperXManager.isDevelopmentMode || query.indexOf("--Abfrage") <= -1) {
            String queryReplaced = SxSQL_Server.removeSemicolonExpansionSequence(query);
            queryReplaced = SqlStringUtils.replaceInAll(queryReplaced, '\'', ';', SQL_STMT_SEP_SUBST);
            Iterator st = Splitter.on((char)';').split((CharSequence)queryReplaced).iterator();
            int n = 0;
            while (st.hasNext()) {
                ++n;
                String sqlstmt = ((String)st.next()).trim();
                if (sqlstmt.length() < 5) continue;
                sqlstmt = sqlstmt.replace(SQL_STMT_SEP_SUBST, ";");
                sqlstmt = SqlStringUtils.unescapeString(sqlstmt);
                this.execute(sqlstmt, connection, gesamt);
                String errorstring = gesamt.getError_String();
                if (errorstring.equals("")) continue;
                String msg = errorstring + " bei sql-statement Nr " + n + " " + sqlstmt;
                throw new SQLException(msg);
            }
        } else {
            int pos = query.lastIndexOf("select");
            if (query.lastIndexOf("Select") > pos) {
                pos = query.lastIndexOf("Select");
            }
            if (query.lastIndexOf("SELECT") > pos) {
                pos = query.lastIndexOf("SELECT");
            }
            String hauptteil = query.substring(0, pos);
            String rest = query.substring(pos);
            Statement stm = connection.createStatement();
            hauptteil = SxSQL_Server.removeSemicolonExpansionSequence(hauptteil);
            Iterator st = Splitter.on((char)';').split((CharSequence)hauptteil).iterator();
            int totallength = 0;
            while (st.hasNext()) {
                String sqlstmt = ((String)st.next()).trim();
                sqlstmt = sqlstmt.replace(SQL_STMT_SEP_SUBST, ";");
                totallength += sqlstmt.length();
                if (sqlstmt.length() > 5) {
                    stm.addBatch(sqlstmt);
                }
                if (totallength <= 30000) continue;
                stm.executeBatch();
                stm.clearBatch();
            }
            stm.executeBatch();
            stm.close();
            Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "Hauptteil ausgef\u00fchrt");
            this.execute(rest, connection, gesamt);
        }
    }

    public synchronized void execute(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        statement.setMaxRows(SuperXManager.maxRows);
        String queryReplaced = SqlStringUtils.replaceInAll(query, '\'', ';', SQL_STMT_SEP_SUBST);
        Iterator st = Splitter.on((char)';').split((CharSequence)queryReplaced).iterator();
        int n = 0;
        boolean hasRuntimeMessage = false;
        while (st.hasNext()) {
            ++n;
            String sqlstmt = ((String)st.next()).trim();
            if ((sqlstmt = sqlstmt.replace(SQL_STMT_SEP_SUBST, ";")).length() < 5) continue;
            Logger.getLogger("superx_" + this.mandantenID).log(Level.FINEST, "sql-Abfrage ausf\u00fchren:" + sqlstmt);
            try {
                if (statement.execute(sqlstmt)) {
                    int column;
                    ResultSet resultSet = statement.getResultSet();
                    this.metaData = resultSet.getMetaData();
                    this.numberOfColumns = this.metaData.getColumnCount();
                    String[] columnNames = new String[this.numberOfColumns];
                    String[] columnLabel = new String[this.numberOfColumns];
                    int[] columnDisplaySize = new int[this.numberOfColumns];
                    int[] columnType = new int[this.numberOfColumns];
                    int[] Scale = new int[this.numberOfColumns];
                    boolean[] isWritable = new boolean[this.numberOfColumns];
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnNames[column] = this.metaData.getColumnName(column + 1);
                        if (!columnNames[column].equalsIgnoreCase("_runtimeMessage")) continue;
                        hasRuntimeMessage = true;
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnLabel[column] = this.metaData.getColumnLabel(column + 1);
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnDisplaySize[column] = this.metaData.getColumnDisplaySize(column + 1);
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnType[column] = this.adaptColumType(this.metaData.getColumnType(column + 1));
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        Scale[column] = this.metaData.getScale(column + 1);
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        isWritable[column] = this.metaData.isWritable(column + 1);
                    }
                    int naturalOrderNo = 1;
                    while (resultSet.next()) {
                        if (hasRuntimeMessage) {
                            gesamt.setRuntimeMessage(resultSet.getString(1));
                            continue;
                        }
                        SxResultRow newRow = this.addRow(naturalOrderNo++, resultSet, columnNames);
                        rows.add(newRow);
                    }
                    gesamt.setColumnCount(this.numberOfColumns);
                    gesamt.setAndAdaptColumnNames(columnNames);
                    gesamt.setColumnLabels(columnLabel);
                    gesamt.setColumnDisplaySizes(columnDisplaySize);
                    gesamt.setColumnTypes(columnType);
                    gesamt.setScales(Scale);
                    gesamt.setisWritable(isWritable);
                    gesamt.setRows(rows);
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    this.updateCount = -1;
                } else {
                    this.updateCount = statement.getUpdateCount();
                }
            }
            catch (SQLException e) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, e.toString());
                gesamt.setError_String(e.toString());
            }
            catch (Exception e) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Allgemeiner Fehler beim DB-Zugriff:" + e.toString());
                gesamt.setError_String(e.toString());
            }
            gesamt.setUpdateCount(this.updateCount);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private SxResultRow addRow(int naturalOrderNo, ResultSet resultSet, String[] columnName) throws SQLException {
        SxResultRow newRow = new SxResultRow(this.numberOfColumns, naturalOrderNo);
        block22: for (int i = 0; i < this.numberOfColumns; ++i) {
            switch (this.metaData.getColumnType(i + 1)) {
                case 1: 
                case 12: {
                    String value;
                    try {
                        value = resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Textfeld " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                    }
                    if (value == null || value.equals("null")) {
                        newRow.add(new String(""));
                        continue block22;
                    }
                    newRow.add(value.trim());
                    continue block22;
                }
                case -1: {
                    String value;
                    try {
                        value = "" + resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Blob " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                    }
                    if (value == null || value.equals("null")) {
                        newRow.add(new String(""));
                        continue block22;
                    }
                    newRow.add(value.trim());
                    continue block22;
                }
                case 4: {
                    try {
                        newRow.add(resultSet.getObject(i + 1));
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Integer " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                    continue block22;
                }
                case 2: {
                    try {
                        BigDecimal myNum = resultSet.getBigDecimal(i + 1);
                        newRow.add(myNum);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Numeric " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                    continue block22;
                }
                case 93: {
                    Object myObj;
                    try {
                        myObj = resultSet.getObject(i + 1);
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.INFO, "Objekt: " + myObj.toString());
                        newRow.add(myObj);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Timestamp " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add("");
                    }
                    continue block22;
                }
                case 91: {
                    Object myObj = null;
                    try {
                        myObj = resultSet.getDate(i + 1);
                        newRow.add(myObj);
                    }
                    catch (Exception e) {
                        System.out.println("myObj " + myObj + " i:" + i + " columncount:" + resultSet.getMetaData().getColumnCount());
                        for (int ix = 0; ix < resultSet.getMetaData().getColumnCount(); ++ix) {
                            System.out.println(resultSet.getMetaData().getColumnName(ix + 1) + " " + resultSet.getMetaData().getColumnTypeName(ix + 1));
                        }
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Datum " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add("Fehler beim Datum einlesen");
                    }
                    continue block22;
                }
                default: {
                    try {
                        newRow.add(resultSet.getObject(i + 1));
                        continue block22;
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.mandantenID).log(Level.WARNING, "Unbekanntes Objekt " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString());
                        newRow.add(null);
                    }
                }
            }
        }
        return newRow;
    }

    public void cancel() throws Exception {
        try {
            System.err.println("SxSQL: Cancel statement");
        }
        catch (Exception e) {
            System.err.println("SxSQL: Error canceling statement: " + e);
        }
        throw new UnsupportedOperationException("");
    }

    public void cancel(String url, String user, String passwd) throws Exception {
        try {
            System.err.println("SxSQL: Cancel statement");
        }
        catch (Exception e) {
            System.err.println("SxSQL: Error canceling statement: " + e);
        }
        throw new UnsupportedOperationException("cancel");
    }

    public int adaptColumType(int rsColType) {
        int returnType;
        switch (rsColType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                returnType = 4;
                break;
            }
            case 16: {
                returnType = -7;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                returnType = 3;
                break;
            }
            case 91: {
                returnType = 6;
                break;
            }
            case 93: {
                returnType = 8;
                break;
            }
            case 92: {
                returnType = 9;
                break;
            }
            default: {
                returnType = 1;
            }
        }
        return returnType;
    }
}

