/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlFlatFileMerger {
    public static void main(String[] args) {
        if (args.length < 5 || args.length > 6) {
            System.exit(0);
        }
        String dir = args[0];
        String inPattern = args[1];
        String outFile = args[2];
        String xpath = args[3];
        String attribute = args[4];
        String encoding = "UTF-8";
        if (args.length == 6) {
            encoding = args[5];
        }
        XmlFlatFileMerger.flatMergeXmlFiles(dir, inPattern, outFile, xpath, attribute, encoding);
    }

    public static boolean flatMergeXmlFiles(String inDir, String inPattern, String outFile, String xpath, String mergeAttribute, String encoding) {
        boolean success = false;
        final Pattern filePattern = Pattern.compile(inPattern);
        File dir = new File(inDir);
        if (dir.isDirectory()) {
            File[] inFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    Matcher m = filePattern.matcher(pathname.getName());
                    return m.matches();
                }
            });
            SAXReader reader = new SAXReader();
            LinkedHashMap outNodes = new LinkedHashMap();
            Document doc = null;
            Element root = null;
            HashSet<String> dimensionNames = new HashSet<String>();
            for (File inFile : inFiles) {
                try {
                    doc = reader.read(inFile);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                root = doc.getRootElement();
                List elements = root.elements();
                for (Element element : elements) {
                    String type = element.getName();
                    String name = element.attributeValue("name");
                    System.out.println(type + " : " + name);
                    if (!outNodes.containsKey(type)) {
                        outNodes.put(type, new HashMap());
                    }
                    if (type.equals("Dimension")) {
                        if (dimensionNames.contains(name)) {
                            System.out.println("Dimension " + name + " already exists.");
                            Node newDim = element.detach();
                            Node oldDim = (Node)((Map)outNodes.get(type)).get(name);
                            if (newDim.asXML().equals(oldDim.asXML())) continue;
                            String msg = "Dimension " + name + " has differing entries in " + inFile.getName() + "! Please fix.";
                            System.out.println(msg);
                            throw new RuntimeException(msg);
                        }
                        ((Map)outNodes.get(type)).put(name, element.detach());
                        dimensionNames.add(name);
                        continue;
                    }
                    ((Map)outNodes.get(type)).put(name, element.detach());
                }
                for (Map.Entry entry : outNodes.entrySet()) {
                    System.out.println("All elements of type " + (String)entry.getKey() + ":");
                    TreeSet sortedEntries = new TreeSet(((Map)entry.getValue()).keySet());
                    for (String key : sortedEntries) {
                        System.out.println("Name: " + key);
                        root.add(((Node)((Map)entry.getValue()).get(key)).detach());
                    }
                }
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(dir.getAbsolutePath() + File.separator + outFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(encoding);
            XMLWriter writer = null;
            try {
                writer = new XMLWriter((OutputStream)fos, format);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            try {
                writer.write(doc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            success = true;
        }
        return success;
    }
}

