/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.baseobjects.NamedObjectI;
import de.memtext.db.DBServletException;
import de.memtext.db.PropsReader;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.DSAHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class MemtextPool
extends GenericObjectPool
implements NamedObjectI {
    private String name;
    private String subpath;
    private String nameNoAppendix;
    private Properties props = new Properties();
    private String privateKeyEncoded = null;
    private String publicKeyEncoded = null;
    private DSAHandler dsaHandler;

    public MemtextPool(String name, String nameAppendix, String subpath) throws SQLException, IOException, DBServletException {
        this.subpath = subpath;
        this.nameNoAppendix = name;
        this.setName(name + nameAppendix);
        try {
            this.readPropertiesAndUrl();
            System.out.print(" (" + this.props.getProperty("connectionURL") + ") ..");
        }
        catch (Exception e) {
            System.out.println("Konnte properties / Passwort nicht lesen. " + e);
            e.printStackTrace();
            throw new DBServletException("Konnte properties / Passwort nicht lesen. " + e);
        }
        try {
            Class.forName(this.props.getProperty("driverName"));
        }
        catch (ClassNotFoundException e1) {
            throw new DBServletException("Treiber " + this.props.getProperty("driverName") + " nicht gefunden. Ggfs. nach tomcat/common/lib kopieren.");
        }
        this.initLogging();
        this.setTestOnBorrow(true);
        int minIdle = 5;
        if (this.props.getProperty("minIdle") != null && !this.props.getProperty("minIdle").trim().equals("")) {
            minIdle = Integer.parseInt(this.props.getProperty("minIdle"));
        }
        this.setMinIdle(minIdle);
        int maxIdle = -1;
        if (this.props.getProperty("maxIdle") != null && !this.props.getProperty("maxIdle").trim().equals("")) {
            maxIdle = Integer.parseInt(this.props.getProperty("maxIdle"));
        }
        if (maxIdle != -1) {
            this.setMaxIdle(maxIdle);
        }
        int maxActive = -1;
        if (this.props.getProperty("maxActive") != null && !this.props.getProperty("maxActive").trim().equals("")) {
            maxActive = Integer.parseInt(this.props.getProperty("maxActive"));
        }
        if (maxActive != -1) {
            this.setMaxActive(maxActive);
        }
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.props.getProperty("connectionURL"), this.props);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)this, null, "select count(*) from xdummy;", false, true);
        boolean i = true;
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException e2) {
            throw new DBServletException("ConnectionPool Klasse org.apache.commons.dbcp.PoolingDriver nicht gefunden.\ncommons-dbcp nach tomcat/common/lib stellen.");
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(this.getName(), (ObjectPool)this);
        ObjectPool x = driver.getConnectionPool(this.getName());
        try {
            Connection con = this.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("select value from properties where name='privatekey'");
            while (rs.next()) {
                this.privateKeyEncoded = rs.getString(1);
            }
            rs.close();
            rs = st.executeQuery("select value from properties where name='publickey'");
            while (rs.next()) {
                this.publicKeyEncoded = rs.getString(1);
            }
            rs.close();
            st.close();
            con.close();
        }
        catch (SQLException e) {
            String msg = "Fehler beim Aufbau des ConnectionPools ";
            if (!this.getName().startsWith("default")) {
                msg = msg + " f\u00fcr Mandant: " + this.getName();
            }
            msg = msg + "\nKonnte keine Connection aus dem Pool holen.\n" + e;
            throw new SQLException(msg);
        }
        if (this.privateKeyEncoded != null) {
            this.initDSAHandler();
        }
    }

    protected void initLogging() throws IOException {
    }

    public static String getLogDir() {
        String tomcat_home = System.getProperty("catalina.home");
        if (tomcat_home == null) {
            tomcat_home = System.getProperty("tomcat.home");
        }
        if (tomcat_home == null) {
            tomcat_home = "/home/superx/webserver/tomcat";
        }
        return tomcat_home + "/logs";
    }

    public Properties getProperties() {
        return this.props;
    }

    private void readPropertiesAndUrl() throws Exception {
        String propname = "db_" + this.nameNoAppendix + ".properties";
        if (this.nameNoAppendix.equals("default")) {
            propname = "db.properties";
        }
        URL url = MemtextPool.class.getProtectionDomain().getCodeSource().getLocation();
        File myJar = new File(url.getFile());
        File myPath = new File(myJar.getParent());
        String pfad = myPath.getParent() + System.getProperty("file.separator");
        if (this.subpath != null) {
            pfad = pfad + this.subpath + System.getProperty("file.separator");
        }
        this.props = PropsReader.prepareProps(new File(pfad + propname));
        boolean i = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void close() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.closePool(this.getName());
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.getName());
    }

    public void init() throws TransformerConfigurationException, KeyParentEqualException, SQLException, DBServletException {
    }

    public void clearLogFiles() throws IOException {
    }

    private void initDSAHandler() throws DBServletException {
        if (this.privateKeyEncoded == null) {
            throw new IllegalStateException("privatekey war null - properties-table auf Eintrag \u00fcberpr\u00fcfen");
        }
        if (this.publicKeyEncoded == null) {
            throw new IllegalStateException("publickey war null - properties-table pr\u00fcfen");
        }
        try {
            this.dsaHandler = new DSAHandler(this.privateKeyEncoded, this.publicKeyEncoded);
        }
        catch (Exception e) {
            throw new DBServletException(e.toString());
        }
    }

    public boolean hasDSAHandler() {
        return this.dsaHandler != null;
    }

    public boolean verifiy(String data, String signature) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException {
        if (this.dsaHandler == null) {
            throw new IllegalStateException("DSAHandler ist null, public und private key definition pr\u00fcfen");
        }
        return this.dsaHandler.verify(data, signature);
    }

    public String getPrivateKey() {
        return this.privateKeyEncoded;
    }
}

