/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CipherPacker;
import de.werum.sis.crypt.CryptProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptPBEOutputStream
extends OutputStream {
    private CipherOutputStream secureOut;
    private CryptProperties properties;

    public EncryptPBEOutputStream(OutputStream out, CryptProperties properties, char[] password) throws GeneralSecurityException, IOException {
        if (out == null) {
            throw new IllegalArgumentException("out ist erforderlich.");
        }
        this.properties = properties;
        if (this.properties == null) {
            throw new IllegalArgumentException("properties ist erforderlich.");
        }
        if (password == null) {
            throw new IllegalArgumentException("password ist erforlderlich.");
        }
        SecureRandom secureRandom = this.properties.getSecureRandom();
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        Integer userId = this.properties.getEncryptPackagingUserId();
        String alg = this.properties.getPbeAlgorithm(userId);
        int iterations = this.properties.getPbeIterations(userId);
        byte[] pbeSalt = new byte[this.properties.getPbeSaltSize(userId)];
        secureRandom.nextBytes(pbeSalt);
        PBEKeySpec keySpec = new PBEKeySpec(password, pbeSalt, iterations);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(alg, this.properties.getProviderName(userId));
        SecretKey pbeKey = keyFactory.generateSecret(keySpec);
        SecretKeySpec secretKey = new SecretKeySpec(pbeKey.getEncoded(), this.properties.getSymetricAlgorithm(userId));
        Cipher symetricCipher = Cipher.getInstance(this.properties.getSymetricAlgorithmComplete(userId), this.properties.getProviderName(userId));
        byte[] symmetricCipherIv = new byte[symetricCipher.getBlockSize()];
        secureRandom.nextBytes(symmetricCipherIv);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(symmetricCipherIv);
        symetricCipher.init(1, (Key)secretKey, ivParameterSpec);
        CipherPacker cipherPacker = new CipherPacker(this.properties);
        cipherPacker.packCipherPBE(out, symetricCipher, symmetricCipherIv, pbeSalt);
        this.secureOut = new CipherOutputStream(new BufferedOutputStream(out), symetricCipher);
    }

    public void write(int b) throws IOException {
        this.secureOut.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.secureOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.secureOut.write(b, off, len);
    }

    public void close() throws IOException {
        if (this.secureOut != null) {
            this.secureOut.close();
            this.secureOut = null;
        }
    }
}

