/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.runtime.test.PlausiTest;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCaseResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PlausiTestResult {
    private PlausiTest test;
    private List testCaseResults;
    private int failuresCount;
    private int failedTestCasesCount;
    private long duration;

    public PlausiTestResult(PlausiTest test) {
        this.test = test;
        this.testCaseResults = new ArrayList();
        this.failuresCount = 0;
        this.failedTestCasesCount = 0;
    }

    public void addTestCaseResult(PlausiTestCaseResult testCaseResult) {
        this.testCaseResults.add(testCaseResult);
        this.failuresCount += testCaseResult.getFailuresCount();
        if (testCaseResult.isFailed()) {
            ++this.failedTestCasesCount;
        }
    }

    public PlausiTest getTest() {
        return this.test;
    }

    public boolean isFailed() {
        return this.failuresCount > 0;
    }

    public int getFailuresCount() {
        return this.failuresCount;
    }

    public int getFailedTestCasesCount() {
        return this.failedTestCasesCount;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getDurationMessage() {
        StringBuffer durationMessage = new StringBuffer("Dauer: ");
        durationMessage.append(this.duration / 60000L > 1L ? String.valueOf(this.duration / 60000L) + " Minuten " : "");
        durationMessage.append(this.duration % 60000L / 1000L > 1L ? String.valueOf(this.duration % 60000L / 1000L) + " Sekunden " : "");
        durationMessage.append(String.valueOf(this.duration % 1000L) + " Millisekunden.");
        return durationMessage.toString();
    }

    public Iterator getTestCaseResults() {
        return this.testCaseResults.iterator();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isFailed()) {
            Iterator iter = this.getTestCaseResults();
            while (iter.hasNext()) {
                PlausiTestCaseResult testCaseResult = (PlausiTestCaseResult)iter.next();
                if (!testCaseResult.isFailed()) continue;
                buffer.append(testCaseResult);
                buffer.append("\n");
            }
        }
        buffer.append('[');
        buffer.append(this.getTest().getName());
        buffer.append("] ");
        buffer.append(this.getFailuresCount());
        buffer.append(" Fehler festgestellt.\n");
        buffer.append('[');
        buffer.append(this.getTest().getName());
        buffer.append("] ");
        buffer.append(this.getFailedTestCasesCount());
        buffer.append(" von ");
        buffer.append(this.getTest().getTestCasesCount());
        buffer.append(" Testf\u00e4llen fehlgeschlagen.\n");
        buffer.append(String.valueOf(this.getDurationMessage()) + "\n");
        return buffer.toString();
    }
}

