/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ProgramFactory;
import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import java.util.Iterator;

public class PlausiProgramFactory
implements ProgramFactory {
    private MetaCustomPlausibilisierung plausi;
    private MetaThemenbereich topic;
    private TBFieldDescriptorFactory fieldDescriptorFactory;

    public PlausiProgramFactory(MetaCustomPlausibilisierung plausi) {
        this(plausi, plausi.rootThemenbereich());
    }

    public PlausiProgramFactory(MetaCustomPlausibilisierung plausi, MetaThemenbereich topic) {
        this(plausi, topic, new TBFieldDescriptorFactory(topic));
    }

    public PlausiProgramFactory(MetaCustomPlausibilisierung plausi, MetaThemenbereich topic, TBFieldDescriptorFactory fieldDescriptorFactory) {
        this.plausi = plausi;
        this.topic = topic;
        this.fieldDescriptorFactory = fieldDescriptorFactory;
    }

    @Override
    public ProgramDescriptor getFunction(String name, FeldDeskriptorImpl structure) throws NoSuchFieldException {
        MetaCustomFunktion function;
        Iterator iter;
        MetaThemenbereich topic = this.getTopicForStructure(this.topic, structure);
        if (topic != null) {
            iter = topic.getFunktionen();
            while (iter.hasNext()) {
                function = (MetaCustomFunktion)iter.next();
                if (!function.getName().equals(name)) continue;
                String[] parameters = new String[function.sizeOfParameter()];
                int i = 0;
                while (i < function.sizeOfParameter()) {
                    parameters[i] = function.getFromParameter(i).getName();
                    ++i;
                }
                return this.createProgramDescriptor(function.getMetaSpezifikation(), parameters, function);
            }
        }
        iter = this.plausi.getFunktionen();
        while (iter.hasNext()) {
            function = (MetaCustomFunktion)iter.next();
            if (!function.getName().equals(name)) continue;
            String[] parameters = new String[function.sizeOfParameter()];
            int i = 0;
            while (i < function.sizeOfParameter()) {
                parameters[i] = function.getFromParameter(i).getName();
                ++i;
            }
            return this.createProgramDescriptor(function.getMetaSpezifikation(), parameters, function);
        }
        return null;
    }

    @Override
    public ProgramDescriptor getFieldCheck(String name, FeldDeskriptorImpl structure) throws NoSuchFieldException {
        MetaThemenbereich topic = this.getTopicForStructure(this.topic, structure);
        Iterator iter = topic.getFelder();
        while (iter.hasNext()) {
            MetaCustomTBFeld field = (MetaCustomTBFeld)iter.next();
            if (!field.getName().equals(name) || !(field.getKlasse() instanceof MetaCustomMerkmal)) continue;
            MetaCustomMerkmal feature = (MetaCustomMerkmal)field.getKlasse();
            return this.createProgramDescriptor(feature.getMetaSpezifikation(), new String[]{"feld"}, feature);
        }
        return null;
    }

    @Override
    public ProgramDescriptor getCheck(String name, FeldDeskriptorImpl structure) throws NoSuchFieldException {
        MetaThemenbereich topic = this.getTopicForStructure(this.topic, structure);
        Iterator iter = topic.getPruefungen();
        while (iter.hasNext()) {
            MetaCustomPruefung check = (MetaCustomPruefung)iter.next();
            if (!check.getName().equals(name)) continue;
            ProgramDescriptor programDescriptor = this.createProgramDescriptor(check.getMetaSpezifikation(), null, check);
            Iterator refFieldStructure = check.getHauptBezugsfeld();
            if (refFieldStructure != null && refFieldStructure.hasNext()) {
                FeldDeskriptorImpl currentFieldDescriptor = structure;
                while (refFieldStructure.hasNext()) {
                    MetaTBFeld refField = (MetaTBFeld)refFieldStructure.next();
                    currentFieldDescriptor = this.fieldDescriptorFactory.getFieldDecriptor(refField.getName(), null, currentFieldDescriptor);
                }
                programDescriptor.setRefField(currentFieldDescriptor);
            }
            return programDescriptor;
        }
        return null;
    }

    @Override
    public ProgramDescriptor getFlow(String name, FeldDeskriptorImpl structure) throws NoSuchFieldException {
        MetaThemenbereich topic = this.getTopicForStructure(this.topic, structure);
        Iterator iter = topic.getAblaeufe();
        while (iter.hasNext()) {
            MetaCustomAblauf flow = (MetaCustomAblauf)iter.next();
            if (!flow.getName().equals(name)) continue;
            String[] parameters = new String[topic.sizeOfInitialisierungswerte()];
            int i = 0;
            while (i < topic.sizeOfInitialisierungswerte()) {
                parameters[i] = topic.getFromInitialisierungswerte(i).getName();
                ++i;
            }
            return this.createProgramDescriptor(flow.getMetaSpezifikation(), parameters, flow);
        }
        return null;
    }

    private MetaThemenbereich getTopicForStructure(MetaThemenbereich topic, FeldDeskriptorImpl structure) throws NoSuchFieldException {
        if (structure == null) {
            return topic;
        }
        topic = this.getTopicForStructure(topic, (FeldDeskriptorImpl)structure.getVorgaenger());
        Iterator iter = topic.getFelder();
        while (iter.hasNext()) {
            MetaCustomTBFeld field = (MetaCustomTBFeld)iter.next();
            if (!field.getName().equals(structure.getFeldNameTB())) continue;
            return (MetaThemenbereich)field.getKlasse();
        }
        throw new NoSuchFieldException("Feld " + structure.getFeldNameTB() + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
    }

    protected ProgramDescriptor createProgramDescriptor(MetaProgram program, String[] parameters, MetaElement plausiElement) {
        return new ProgramDescriptor(program, parameters, plausiElement);
    }
}

