/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.ui;

import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.ui.ComboBoxValue;
import de.statspez.pleditor.generator.compare2.ui.CompareEditor;
import de.statspez.pleditor.generator.compare2.ui.TreeTable;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PLErrorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Felder des PL-Fehlers bearbeiten";
    private static final String LABEL_UEBERNEHMEN = "\u00dcbernehmen";
    private static final String LABEL_ABBRECHEN = "Abbrechen";
    private static final int MAX_NUMBER = 20;
    private Hashtable editFields;
    private PlausiFehler plFehler;
    private CompareEditor compareEditor;

    public PLErrorDialog(Frame owner, CompareEditor compareEditor, PlausiFehler fehler, boolean useFullNames) {
        super(owner, true);
        this.init(compareEditor, fehler, useFullNames);
    }

    public PLErrorDialog(Dialog owner, CompareEditor compareEditor, PlausiFehler fehler, boolean useFullNames) {
        super(owner, true);
        this.init(compareEditor, fehler, useFullNames);
    }

    public void showFehler() {
        this.readValues();
        this.setVisible(true);
    }

    private JComponent createEditComponent(ComparedNode node) {
        JComponent result;
        MetaAuspraegungsgruppe classifications = node.getClassifications();
        if (classifications != null) {
            List auspraegungen = TreeTable.getComboBoxValues(classifications);
            result = new JComboBox<Object>(auspraegungen.toArray());
        } else {
            result = new JTextField(20);
        }
        this.editFields.put(node, result);
        return result;
    }

    private JLabel createLabelForEditComponent(ComparedNode comparedNode, boolean useFullNames) {
        StringBuffer fullName = new StringBuffer();
        ComparedNode tmpContext = comparedNode;
        do {
            if (fullName.length() > 0) {
                fullName.insert(0, '.');
            }
            fullName.insert(0, tmpContext.toString());
        } while ((tmpContext = tmpContext.getRealParent()) != null && tmpContext.getRealParent() != null && useFullNames);
        return new JLabel(fullName.toString());
    }

    private void init(CompareEditor compareEditor, PlausiFehler fehler, boolean useFullNames) {
        this.compareEditor = compareEditor;
        this.plFehler = fehler;
        JScrollPane sp = new JScrollPane(this.getRootPanel(useFullNames));
        sp.setBorder(null);
        this.getContentPane().add(sp);
        this.setTitle(TITLE);
        if (this.plFehler.getFelder() != null && this.plFehler.getFelder().length > 20) {
            this.setSize(new Dimension(400, 400));
        } else {
            this.pack();
        }
    }

    private JComponent getActionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (this.plFehler.getFelder() != null && this.plFehler.getFelder().length > 0) {
            JButton uebernehmen = new JButton(LABEL_UEBERNEHMEN);
            uebernehmen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PLErrorDialog.this.writeValues();
                    PLErrorDialog.this.setVisible(false);
                }
            });
            panel.add(uebernehmen);
        }
        JButton abbrechen = new JButton(LABEL_ABBRECHEN);
        abbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PLErrorDialog.this.editFields.clear();
                PLErrorDialog.this.setVisible(false);
            }
        });
        panel.add(abbrechen);
        return panel;
    }

    private JPanel getFieldsPanel(boolean useFullNames) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.editFields = new Hashtable();
        FeldDeskriptorInterface[] felder = this.plFehler.getFelder();
        int count = felder != null ? felder.length : 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        int i = 0;
        while (i < count) {
            ComparedNode comparedNode;
            if (felder[i] != null && (comparedNode = this.compareEditor.findComparedNode(felder[i])) != null) {
                ++constraints.gridy;
                constraints.gridx = 0;
                constraints.anchor = 17;
                constraints.fill = 0;
                JLabel label = this.createLabelForEditComponent(comparedNode, useFullNames);
                panel.add((Component)label, constraints);
                constraints.gridx = 1;
                constraints.fill = 2;
                JComponent valueComp = this.createEditComponent(comparedNode);
                panel.add((Component)valueComp, constraints);
            }
            ++i;
        }
        return panel;
    }

    private JPanel getRootPanel(boolean useFullNames) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        titlePanel.add((Component)new JLabel(this.plFehler.getFehlertextKurz()), "Center");
        panel.add((Component)titlePanel, "North");
        JPanel fieldsPanel = this.getFieldsPanel(useFullNames);
        panel.add((Component)fieldsPanel, "Center");
        panel.add((Component)this.getActionsPanel(), "South");
        return panel;
    }

    private void readValues() {
        Iterator nodes = this.editFields.keySet().iterator();
        block0: while (nodes != null && nodes.hasNext()) {
            ComparedNode comparedNode = (ComparedNode)nodes.next();
            Object obj = this.editFields.get(comparedNode);
            if (obj instanceof JTextField) {
                ((JTextField)obj).setText(comparedNode.getDisplayvalueOfHauptsatz());
                continue;
            }
            if (!(obj instanceof JComboBox)) continue;
            JComboBox box = (JComboBox)obj;
            box.setSelectedItem(comparedNode.getDisplayvalueOfHauptsatz());
            int i = 0;
            while (i < box.getItemCount()) {
                ComboBoxValue item = (ComboBoxValue)box.getItemAt(i);
                if (item.getLabel().equals(comparedNode.getDisplayvalueOfHauptsatz())) {
                    box.setSelectedItem(item);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private void writeValues() {
        Iterator it = this.editFields.keySet().iterator();
        while (it != null && it.hasNext()) {
            ComparedNode node = (ComparedNode)it.next();
            Object editField = this.editFields.get(node);
            Object value = editField instanceof JTextField ? ((JTextField)editField).getText() : ((JComboBox)editField).getSelectedItem();
            this.compareEditor.setHauptsatzValue(value, node);
        }
    }
}

