/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java.mapping;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.LiteralCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.mapping.util.MappingProgrammCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.MappingSegmentGiver;
import de.statspez.pleditor.generator.codegen.java.mapping.util.SegmentCounterGiver;
import de.statspez.pleditor.generator.codegen.mapping.MappingProgramGenerator;
import de.statspez.pleditor.generator.codegen.mapping.structure.Mapping;
import de.statspez.pleditor.generator.codegen.mapping.structure.MappingMeta;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.io.Writer;

public class MappingCodeGenerator
extends JavaCodeGenerator {
    public static final int DSB = 1;
    public static final int RAW = 2;
    public static final int TB = 3;
    public static final int DIRECTION_TO_TB = 1;
    public static final int DIRECTION_FROM_TB = 2;
    public static final int BOOTH_DIRECTION = 3;
    private CodegenContext context = null;
    private Writer writer;
    private LiteralManager literalManager;
    MappingProgrammCodeGenerator program = new MappingProgrammCodeGenerator();
    private boolean dsbAvailible = false;
    private boolean rawAvailible = false;
    private ScopeImpl dsbScope;
    private ScopeImpl rawScope;
    private String outPutClassName;
    private SegmentCounterGiver segmentGiver = null;
    private boolean fromTB;
    private boolean toTB;

    public void generate(CodegenContext context) {
        this.generate(context, 3);
    }

    public void generate(CodegenContext context, int direction) {
        this.context = context;
        switch (direction) {
            case 1: {
                this.toTB = true;
                break;
            }
            case 3: {
                this.toTB = true;
            }
            case 2: {
                this.fromTB = true;
                break;
            }
            default: {
                this.fromTB = false;
                this.toTB = false;
            }
        }
        context.getPlausi().accept(this);
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        MappingMeta mappingMeta;
        String filename;
        String prefix = null;
        if (this.dsbAvailible) {
            prefix = "DSB_Plausi_";
            this.program.setScope(this.dsbScope);
            MetaCustomMapping dsbMapping = (MetaCustomMapping)((MetaCustomPlausibilisierung)plausi).usedMappings();
            if (this.toTB) {
                this.program.setDirection(false);
                this.outPutClassName = "DSB_TO_TB_" + StringHelper.getEscapedName(plausi.getPLName());
                filename = String.valueOf(this.outPutClassName) + ".java";
                this.programSetup();
                mappingMeta = new MappingMeta(102, dsbMapping);
                this.createMapping(plausi, prefix, filename, mappingMeta, false);
            }
            if (this.fromTB) {
                this.program.setDirection(true);
                this.outPutClassName = "TB_TO_DSB_" + StringHelper.getEscapedName(plausi.getPLName());
                filename = String.valueOf(this.outPutClassName) + ".java";
                this.programSetup();
                mappingMeta = new MappingMeta(103, dsbMapping);
                this.createMapping(plausi, prefix, filename, mappingMeta, true);
            }
        }
        if (this.rawAvailible) {
            prefix = "RAW_Plausi_";
            MetaCustomMapping rawMapping = (MetaCustomMapping)((MetaCustomPlausibilisierung)plausi).getRawMapping();
            if (this.toTB) {
                this.program.setScope(new ScopeImpl(this.rawScope));
                this.program.setDirection(false);
                this.outPutClassName = "RAW_TO_TB_" + StringHelper.getEscapedName(plausi.getPLName());
                filename = String.valueOf(this.outPutClassName) + ".java";
                this.programSetup();
                mappingMeta = new MappingMeta(100, rawMapping);
                this.createMapping(plausi, prefix, filename, mappingMeta, false);
            }
            if (this.fromTB) {
                this.program.setScope(new ScopeImpl(this.rawScope));
                this.program.setDirection(true);
                this.outPutClassName = "TB_TO_RAW_" + StringHelper.getEscapedName(plausi.getPLName());
                filename = String.valueOf(this.outPutClassName) + ".java";
                this.programSetup();
                mappingMeta = new MappingMeta(101, rawMapping);
                this.createMapping(plausi, prefix, filename, mappingMeta, true);
            }
        }
    }

    private void programSetup() {
        this.segmentGiver = new SegmentCounterGiver();
        this.literalManager = new LiteralManager(true, this.context.getMaxElementsInSegment(0), new MappingSegmentGiver(this.outPutClassName, this.segmentGiver));
    }

    private void createMapping(MetaPlausibilisierung plausi, String prefix, String filename, Mapping mapping, boolean revert) {
        String program = new MappingProgramGenerator().createMappingProgram(mapping);
        MetaProgram metaprogram = Helper.metaStructureFor(program);
        this.createClass(plausi, prefix, metaprogram, filename, revert);
    }

    private void createClass(MetaPlausibilisierung plausi, String prefix, MetaProgram metaprogram, String filename, boolean revert) {
        this.writer = this.context.createWriter(filename);
        try {
            String tb_var = "target";
            String dat_var = "source";
            this.setOutput(this.writer);
            if (revert) {
                tb_var = "source";
                dat_var = "target";
            }
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.");
            this.out.print("*;");
            this.indentNewLine();
            this.out.print("import ");
            this.out.print(String.valueOf(this.context.getPlausiPackage()) + "." + this.context.getPlausiClassName() + ".*;");
            this.indentNewLine();
            this.out.print("import de.statspez.pleditor.generator.runtime.mapping.MappingBase;");
            this.indentNewLine();
            this.out.print("import ");
            this.out.print(this.context.getPlausiPackage());
            if (this.rawAvailible) {
                this.out.print(".RAW_");
            } else if (this.dsbAvailible) {
                this.out.print(".DSB_");
            }
            this.out.print(StringHelper.getEscapedName(this.context.getPlausiClassName()));
            this.out.print(".*;");
            this.indentNewLine();
            this.out.print("import java.util.Hashtable;");
            this.indentNewLine();
            this.defineClass(this.outPutClassName, "public", "MappingBase");
            this.indentNewLine();
            this.out.print(String.valueOf(prefix) + StringHelper.getEscapedName(plausi.getPLName()) + " " + dat_var + ";");
            this.indentNewLine();
            MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
            this.out.print("TB_" + StringHelper.getEscapedName(rootTb.getName()) + " " + tb_var + ";");
            this.defineMethod("public", "", this.outPutClassName, "");
            this.indentNewLine();
            this.out.print("this." + dat_var + "=new " + prefix + StringHelper.getEscapedName(plausi.getPLName()) + "(null,new FeldDeskriptorExt(new Hashtable(), \"\",null,7, null, \"\"),null);");
            this.indentNewLine();
            this.out.print("this." + tb_var + "=new " + "Plausi_" + StringHelper.getEscapedName(plausi.getPLName()) + "().themenbereich;");
            this.indentNewLine();
            this.closeBlock();
            this.indentNewLine();
            metaprogram.setName("map");
            this.program.setClassName(this.outPutClassName);
            this.program.setLiteralManager(this.literalManager);
            this.program.setSegmentCounterGiver(this.segmentGiver);
            this.program.setOutput(this.writer);
            this.program.generate(this.context, metaprogram, new ScopeImpl((Scope)this.context.getTopicScopes().get(((MetaCustomPlausibilisierung)plausi).rootThemenbereich().getName())), false);
            LiteralCodeGenerator generator = new LiteralCodeGenerator();
            generator.setOutput(this.writer);
            generator.generate(this.context, this.literalManager);
            this.closeBlock();
        }
        finally {
            this.context.destroyWriter(filename, this.writer);
        }
    }

    public void addScope(ScopeImpl scope, int type) {
        if (type == 1) {
            this.dsbScope = scope;
            this.program.setPrefix("DSB_");
            this.dsbAvailible = true;
            this.rawAvailible = false;
        } else if (type == 2) {
            this.rawScope = scope;
            this.program.setPrefix("RAW_");
            this.rawAvailible = true;
            this.dsbAvailible = false;
        }
    }
}

