/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Locale;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.util.Format;

class FormatFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Format", "Format(<Expression>, <String Expression>)", "Formats a number or date to a string.", new String[]{"fSmS", "fSnS", "fSDS"}, FormatFunDef.class);

    public FormatFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        final Calc calc = compiler.compileScalar(call.getArg(0), true);
        final Locale locale = compiler.getEvaluator().getConnectionLocale();
        if (args[1] instanceof Literal) {
            String formatString = (String)((Literal)args[1]).getValue();
            final Format format = new Format(formatString, locale);
            return new AbstractStringCalc(call, new Calc[]{calc}){

                @Override
                public String evaluateString(Evaluator evaluator) {
                    Object o = calc.evaluate(evaluator);
                    return format.format(o);
                }
            };
        }
        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
        return new AbstractStringCalc(call, new Calc[]{calc, stringCalc}){

            @Override
            public String evaluateString(Evaluator evaluator) {
                Object o = calc.evaluate(evaluator);
                String formatString = stringCalc.evaluateString(evaluator);
                Format format = new Format(formatString, locale);
                return format.format(o);
            }
        };
    }
}

