/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.util.MetaStoreUtil;

public class MemoryMetaStoreAttribute
implements IMetaStoreAttribute {
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    protected final Map<String, IMetaStoreAttribute> children;
    protected String id;
    protected Object value;

    public MemoryMetaStoreAttribute() {
        this(null, null);
    }

    public MemoryMetaStoreAttribute(String id, Object value) {
        this.id = id;
        this.value = value;
        this.children = new HashMap<String, IMetaStoreAttribute>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public MemoryMetaStoreAttribute(IMetaStoreAttribute attribute) {
        this(attribute.getId(), attribute.getValue());
        for (IMetaStoreAttribute childElement : attribute.getChildren()) {
            this.addChild(new MemoryMetaStoreAttribute(childElement));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public List<IMetaStoreAttribute> getChildren() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<List<IMetaStoreAttribute>>(){

            @Override
            public List<IMetaStoreAttribute> call() throws Exception {
                return new ArrayList<IMetaStoreAttribute>(MemoryMetaStoreAttribute.this.children.values());
            }
        });
    }

    public void setChildren(final List<IMetaStoreAttribute> childrenList) {
        MetaStoreUtil.executeLockedOperationQuietly(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreAttribute.this.children.clear();
                for (IMetaStoreAttribute child : childrenList) {
                    MemoryMetaStoreAttribute.this.children.put(child.getId(), child);
                }
                return null;
            }
        });
    }

    @Override
    public void addChild(final IMetaStoreAttribute attribute) {
        MetaStoreUtil.executeLockedOperationQuietly(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreAttribute.this.children.put(attribute.getId(), attribute);
                return null;
            }
        });
    }

    @Override
    public void deleteChild(final String attributeId) {
        MetaStoreUtil.executeLockedOperationQuietly(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Iterator<IMetaStoreAttribute> iterator = MemoryMetaStoreAttribute.this.children.values().iterator();
                while (iterator.hasNext()) {
                    IMetaStoreAttribute next = iterator.next();
                    if (!next.getId().equals(attributeId)) continue;
                    iterator.remove();
                    break;
                }
                return null;
            }
        });
    }

    @Override
    public void clearChildren() {
        MetaStoreUtil.executeLockedOperationQuietly(this.writeLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreAttribute.this.children.clear();
                return null;
            }
        });
    }

    @Override
    public IMetaStoreAttribute getChild(final String id) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<IMetaStoreAttribute>(){

            @Override
            public IMetaStoreAttribute call() throws Exception {
                return MemoryMetaStoreAttribute.this.children.get(id);
            }
        });
    }
}

