/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.persist;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.IMetaStoreObjectFactory;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.pentaho.metastore.persist.MetaStoreKeyMap;
import org.pentaho.metastore.util.MetaStoreUtil;

public class MetaStoreFactory<T> {
    private static final String OBJECT_FACTORY_CONTEXT = "_ObjectFactoryContext_";
    private static final String POJO_CHILD = "_POJO_";
    protected IMetaStore metaStore;
    protected final Class<T> clazz;
    protected String namespace;
    protected Map<String, List<?>> nameListMap;
    protected Map<String, MetaStoreFactory<?>> nameFactoryMap;
    protected Map<String, List<?>> filenameListMap;
    protected IMetaStoreObjectFactory objectFactory;
    private volatile SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public MetaStoreFactory(Class<T> clazz, IMetaStore metaStore, String namespace) {
        this.metaStore = metaStore;
        this.clazz = clazz;
        this.namespace = namespace;
        this.nameListMap = new HashMap();
        this.filenameListMap = new HashMap();
        this.nameFactoryMap = new HashMap();
    }

    public void addNameList(String nameListKey, List<?> nameList) {
        this.nameListMap.put(nameListKey, nameList);
    }

    public void addNameFactory(String nameFactoryKey, MetaStoreFactory<?> factory) {
        this.nameFactoryMap.put(nameFactoryKey, factory);
    }

    public void addFilenameList(String filenameListKey, List<?> filenameList) {
        this.filenameListMap.put(filenameListKey, filenameList);
    }

    public T loadElement(String name) throws MetaStoreException {
        if (name == null || name.length() == 0) {
            throw new MetaStoreException("You need to specify the name of an element to load");
        }
        MetaStoreElementType elementTypeAnnotation = this.getElementTypeAnnotation();
        IMetaStoreElementType elementType = this.metaStore.getElementTypeByName(this.namespace, elementTypeAnnotation.name());
        if (elementType == null) {
            return null;
        }
        IMetaStoreElement element = this.metaStore.getElementByName(this.namespace, elementType, name);
        if (element == null) {
            return null;
        }
        return this.loadElement(element);
    }

    private T loadElement(IMetaStoreElement element) throws MetaStoreException {
        T object;
        try {
            object = this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new MetaStoreException("Class " + this.clazz.getName() + " could not be instantiated. Make sure the empty constructor is present", e);
        }
        this.setAttributeValue(this.clazz, object, "name", "setName", String.class, element.getName());
        this.loadAttributes(object, element, this.clazz);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAttributes(Object parentObject, IMetaStoreAttribute parentElement, Class<?> parentClass) throws MetaStoreException {
        Field[] fields;
        Field[] arr$ = fields = parentClass.getDeclaredFields();
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            Field field = arr$[i$];
            MetaStoreAttribute attributeAnnotation = field.getAnnotation(MetaStoreAttribute.class);
            if (attributeAnnotation != null) {
                String key = attributeAnnotation.key();
                if (key == null || key.length() == 0) {
                    key = field.getName();
                }
                AttributeType type = this.determineAttributeType(field, attributeAnnotation);
                IMetaStoreAttribute child = parentElement.getChild(key);
                if (child == null) {
                    String mappedKey;
                    String[] arr$2 = MetaStoreKeyMap.get(key);
                    int len$2 = arr$2.length;
                    for (int i$2 = 0; i$2 < len$2 && (child = parentElement.getChild(mappedKey = arr$2[i$2])) == null; ++i$2) {
                    }
                }
                if (!(child == null || child.getValue() == null && child.getChildren().isEmpty())) {
                    String setterName = this.getSetterMethodName(field.getName());
                    String childValue = MetaStoreUtil.getAttributeString(child);
                    if (attributeAnnotation.password()) {
                        childValue = this.metaStore.getTwoWayPasswordEncoder().decode(childValue);
                    }
                    switch (type) {
                        case STRING: {
                            this.setAttributeValue(parentClass, parentObject, field.getName(), setterName, String.class, childValue);
                            break;
                        }
                        case INTEGER: {
                            this.setAttributeValue(parentClass, parentObject, field.getName(), setterName, Integer.TYPE, Integer.valueOf(childValue));
                            break;
                        }
                        case LONG: {
                            this.setAttributeValue(parentClass, parentObject, field.getName(), setterName, Long.TYPE, Long.valueOf(childValue));
                            break;
                        }
                        case BOOLEAN: {
                            this.setAttributeValue(parentClass, parentObject, field.getName(), setterName, Boolean.TYPE, "Y".equalsIgnoreCase(childValue));
                            break;
                        }
                        case ENUM: {
                            Object enumValue = null;
                            Class<?> enumClass = field.getType();
                            if (childValue != null && childValue.length() > 0) {
                                enumValue = Enum.valueOf(enumClass, childValue);
                            }
                            this.setAttributeValue(parentClass, parentObject, field.getName(), setterName, field.getType(), enumValue);
                            break;
                        }
                        case DATE: {
                            try {
                                SimpleDateFormat simpleDateFormat = this.DATE_FORMAT;
                                synchronized (simpleDateFormat) {
                                    Date date = childValue == null ? null : this.DATE_FORMAT.parse(childValue);
                                    this.setAttributeValue(parentClass, parentObject, field.getName(), setterName, Date.class, date);
                                    break;
                                }
                            }
                            catch (Exception e) {
                                throw new MetaStoreException("Unexpected date parsing problem with value: '" + childValue + "'", e);
                            }
                        }
                        case LIST: {
                            this.loadAttributesList(parentClass, parentObject, field, child);
                            break;
                        }
                        case NAME_REFERENCE: {
                            this.loadNameReference(parentClass, parentObject, field, child, attributeAnnotation);
                            break;
                        }
                        case FACTORY_NAME_REFERENCE: {
                            Object object = this.loadFactoryNameReference(parentClass, parentObject, field, child, attributeAnnotation);
                            this.setAttributeValue(parentClass, parentObject, field.getName(), this.getSetterMethodName(field.getName()), field.getType(), object);
                            break;
                        }
                        case FILENAME_REFERENCE: {
                            this.loadFilenameReference(parentClass, parentObject, field, child, attributeAnnotation);
                            break;
                        }
                        case POJO: {
                            Object pojo = this.loadPojo(parentClass, parentObject, field, child, attributeAnnotation);
                            this.setAttributeValue(parentClass, parentObject, field.getName(), setterName, field.getType(), pojo);
                            break;
                        }
                        default: {
                            throw new MetaStoreException("Only String values are supported at this time");
                        }
                    }
                }
            }
            ++i$;
        }
        return;
    }

    private Object loadPojo(Class<?> parentClass, Object parentObject, Field field, IMetaStoreAttribute child, MetaStoreAttribute attributeAnnotation) throws MetaStoreException {
        String pojoChildClassName;
        IMetaStoreAttribute pojoChild = child.getChild(POJO_CHILD);
        if (pojoChild == null) {
            pojoChildClassName = MetaStoreUtil.getAttributeString(child);
            pojoChild = child;
        } else {
            pojoChildClassName = pojoChild.getValue().toString();
        }
        if (pojoChildClassName == null) {
            return null;
        }
        try {
            Object pojoObject;
            Class<?> pojoClass;
            if (this.objectFactory == null) {
                pojoClass = this.clazz.getClassLoader().loadClass(pojoChildClassName);
                pojoObject = pojoClass.newInstance();
            } else {
                Map<String, String> objectFactoryContext = this.getObjectFactoryContext(child);
                pojoObject = this.objectFactory.instantiateClass(pojoChildClassName, objectFactoryContext);
                pojoClass = pojoObject.getClass();
            }
            this.loadAttributes(pojoObject, pojoChild, pojoClass);
            return pojoObject;
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to load POJO class " + pojoChildClassName + " in parent class: " + parentClass, e);
        }
    }

    private Map<String, String> getObjectFactoryContext(IMetaStoreAttribute parentElement) {
        IMetaStoreAttribute contextChild;
        HashMap<String, String> context = new HashMap<String, String>();
        if (parentElement != null && (contextChild = parentElement.getChild(OBJECT_FACTORY_CONTEXT)) != null) {
            for (IMetaStoreAttribute child : contextChild.getChildren()) {
                if (child.getId() == null || child.getValue() == null) continue;
                context.put(child.getId(), child.getValue().toString());
            }
        }
        return context;
    }

    private void saveObjectFactoryContext(IMetaStoreAttribute parentElement, Map<String, String> context) throws MetaStoreException {
        if (context == null || context.isEmpty()) {
            return;
        }
        IMetaStoreAttribute contextAttribute = this.metaStore.newAttribute(OBJECT_FACTORY_CONTEXT, null);
        parentElement.addChild(contextAttribute);
        for (String key : context.keySet()) {
            IMetaStoreAttribute attribute = this.metaStore.newAttribute(key, context.get(key));
            contextAttribute.addChild(attribute);
        }
    }

    private void loadAttributesList(Class<?> parentClass, Object parentObject, Field field, IMetaStoreAttribute parentElement) throws MetaStoreException {
        try {
            if (parentElement.getValue() == null) {
                return;
            }
            MetaStoreAttribute metaStoreAttribute = field.getAnnotation(MetaStoreAttribute.class);
            String listGetter = this.getGetterMethodName(field.getName(), false);
            Method listGetMethod = parentClass.getMethod(listGetter, new Class[0]);
            List list = (List)listGetMethod.invoke(parentObject, new Object[0]);
            String childClassName = parentElement.getValue().toString();
            List<IMetaStoreAttribute> children = parentElement.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Object childObject;
                Class<?> childClass;
                IMetaStoreAttribute child = parentElement.getChild(Integer.toString(i));
                if (child == null) continue;
                if (metaStoreAttribute != null && metaStoreAttribute.factoryNameReference()) {
                    Object object = this.loadFactoryNameReference(parentClass, parentObject, field, child, metaStoreAttribute);
                    if (object == null) continue;
                    list.add(object);
                    continue;
                }
                if (childClassName.equals(String.class.getName())) {
                    String value = (String)child.getValue();
                    if (value == null) continue;
                    list.add(value);
                    continue;
                }
                if (this.objectFactory == null) {
                    childClass = this.clazz.getClassLoader().loadClass(childClassName);
                    childObject = childClass.newInstance();
                } else {
                    Map<String, String> context = this.getObjectFactoryContext(child);
                    childObject = this.objectFactory.instantiateClass(childClassName, context);
                    childClass = childObject.getClass();
                }
                this.loadAttributes(childObject, child, childClass);
                list.add(childObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaStoreException("Unable to load list attribute for field '" + field.getName() + "'", e);
        }
    }

    private void loadNameReference(Class<?> parentClass, Object parentObject, Field field, IMetaStoreAttribute parentElement, MetaStoreAttribute attributeAnnotation) throws MetaStoreException {
        try {
            if (parentElement.getValue() == null) {
                return;
            }
            String name = parentElement.getValue().toString();
            if (name.length() == 0) {
                return;
            }
            List<?> list = this.nameListMap.get(attributeAnnotation.nameListKey());
            if (list == null) {
                throw new MetaStoreException("Unable to find reference list for named objects with key '" + attributeAnnotation.nameListKey() + "', name reference '" + name + "' can not be looked up");
            }
            for (Object object : list) {
                String verifyName = (String)object.getClass().getMethod("getName", new Class[0]).invoke(object, new Object[0]);
                if (!verifyName.equals(name)) continue;
                String setter = this.getSetterMethodName(field.getName());
                Method setterMethod = parentObject.getClass().getMethod(setter, object.getClass());
                setterMethod.invoke(parentObject, object);
                break;
            }
        }
        catch (Exception e) {
            throw new MetaStoreException("Error lookup up reference for field '" + field.getName() + "'", e);
        }
    }

    private Object loadFactoryNameReference(Class<?> parentClass, Object parentObject, Field field, IMetaStoreAttribute parentElement, MetaStoreAttribute attributeAnnotation) throws MetaStoreException {
        try {
            if (parentElement.getValue() == null) {
                return null;
            }
            String name = parentElement.getValue().toString();
            IMetaStoreAttribute pojoChild = parentElement.getChild(POJO_CHILD);
            if (pojoChild != null) {
                Object pojo = this.loadPojo(parentClass, parentObject, field, parentElement, attributeAnnotation);
                if (pojo != null) {
                    this.setAttributeValue(pojo.getClass(), pojo, "name", "setName", String.class, name);
                }
                return pojo;
            }
            if (name == null || name.length() == 0) {
                return null;
            }
            MetaStoreFactory<?> factory = this.nameFactoryMap.get(attributeAnnotation.factoryNameKey());
            if (factory == null) {
                throw new MetaStoreException("Unable to find factory to load attribute for factory key '" + attributeAnnotation.factoryNameKey() + "', name reference '" + name + "' can not be looked up");
            }
            Object object = factory.loadElement(name);
            return object;
        }
        catch (Exception e) {
            throw new MetaStoreException("Error lookup up reference for field '" + field.getName() + "'", e);
        }
    }

    private void loadFilenameReference(Class<?> parentClass, Object parentObject, Field field, IMetaStoreAttribute parentElement, MetaStoreAttribute attributeAnnotation) throws MetaStoreException {
        try {
            if (parentElement.getValue() == null) {
                return;
            }
            String filename = parentElement.getValue().toString();
            if (filename.length() == 0) {
                return;
            }
            List<?> list = this.filenameListMap.get(attributeAnnotation.filenameListKey());
            if (list == null) {
                throw new MetaStoreException("Unable to find reference list for named objects with key '" + attributeAnnotation.filenameListKey() + "', name reference '" + filename + "' can not be looked up");
            }
            for (Object object : list) {
                Method getNameMethod = object.getClass().getMethod("getFilename", new Class[0]);
                String verifyName = (String)getNameMethod.invoke(object, new Object[0]);
                if (!verifyName.equals(filename)) continue;
                String setter = this.getSetterMethodName(field.getName());
                Method setterMethod = parentObject.getClass().getMethod(setter, object.getClass());
                setterMethod.invoke(parentObject, object);
                break;
            }
        }
        catch (Exception e) {
            throw new MetaStoreException("Error lookup up reference for field '" + field.getName() + "'", e);
        }
    }

    public void saveElement(T t) throws MetaStoreException {
        String name;
        IMetaStoreElementType elementType;
        MetaStoreElementType elementTypeAnnotation = this.getElementTypeAnnotation();
        if (!this.metaStore.namespaceExists(this.namespace)) {
            this.metaStore.createNamespace(this.namespace);
        }
        if ((elementType = this.metaStore.getElementTypeByName(this.namespace, elementTypeAnnotation.name())) == null) {
            elementType = this.metaStore.newElementType(this.namespace);
            elementType.setName(elementTypeAnnotation.name());
            elementType.setDescription(elementTypeAnnotation.description());
            this.metaStore.createElementType(this.namespace, elementType);
        }
        if ((name = (String)this.getAttributeValue(this.clazz, t, "name", "getName")) == null || name.trim().length() == 0) {
            throw new MetaStoreException("Unable to find name of element class object '" + t.toString() + "'");
        }
        IMetaStoreElement element = this.metaStore.newElement();
        element.setName(name);
        element.setElementType(elementType);
        this.saveAttributes(element, this.clazz, t);
        IMetaStoreElement existingElement = this.metaStore.getElementByName(this.namespace, elementType, name);
        if (existingElement == null) {
            this.metaStore.createElement(this.namespace, elementType, element);
        } else {
            this.metaStore.updateElement(this.namespace, elementType, existingElement.getId(), element);
        }
    }

    private void saveAttributes(IMetaStoreAttribute parentElement, Class<?> parentClass, Object parentObject) throws MetaStoreException {
        try {
            Field[] fields;
            block15: for (Field field : fields = parentClass.getDeclaredFields()) {
                MetaStoreAttribute attributeAnnotation = field.getAnnotation(MetaStoreAttribute.class);
                if (attributeAnnotation == null) continue;
                String key = attributeAnnotation.key();
                if (key == null || key.length() == 0) {
                    key = field.getName();
                }
                AttributeType type = this.determineAttributeType(field, attributeAnnotation);
                switch (type) {
                    case STRING: {
                        String value = (String)this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
                        if (attributeAnnotation.password()) {
                            value = this.metaStore.getTwoWayPasswordEncoder().encode(value);
                        }
                        IMetaStoreAttribute child = this.metaStore.newAttribute(key, value);
                        parentElement.addChild(child);
                        continue block15;
                    }
                    case INTEGER: {
                        int intValue = (Integer)this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
                        IMetaStoreAttribute child = this.metaStore.newAttribute(key, Integer.toString(intValue));
                        parentElement.addChild(child);
                        continue block15;
                    }
                    case LONG: {
                        long longValue = (Long)this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
                        IMetaStoreAttribute child = this.metaStore.newAttribute(key, Long.toString(longValue));
                        parentElement.addChild(child);
                        continue block15;
                    }
                    case BOOLEAN: {
                        boolean boolValue = (Boolean)this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), true));
                        IMetaStoreAttribute child = this.metaStore.newAttribute(key, boolValue ? "Y" : "N");
                        parentElement.addChild(child);
                        continue block15;
                    }
                    case ENUM: {
                        Object enumValue = this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
                        String name = null;
                        if (enumValue != null) {
                            name = (String)this.getAttributeValue(Enum.class, enumValue, field.getName(), "name");
                        }
                        IMetaStoreAttribute child = this.metaStore.newAttribute(key, name);
                        parentElement.addChild(child);
                        continue block15;
                    }
                    case DATE: {
                        Date dateValue = (Date)this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
                        IMetaStoreAttribute child = this.metaStore.newAttribute(key, dateValue == null ? null : this.DATE_FORMAT.format(dateValue));
                        parentElement.addChild(child);
                        continue block15;
                    }
                    case LIST: {
                        this.saveListAttribute(parentClass, parentElement, parentObject, field, key);
                        continue block15;
                    }
                    case NAME_REFERENCE: {
                        this.saveNameReference(parentClass, parentElement, parentObject, field, key);
                        continue block15;
                    }
                    case FACTORY_NAME_REFERENCE: {
                        this.saveFactoryNameReference(parentClass, parentElement, parentObject, field, key);
                        continue block15;
                    }
                    case FILENAME_REFERENCE: {
                        this.saveFilenameReference(parentClass, parentElement, parentObject, field, key);
                        continue block15;
                    }
                    case POJO: {
                        IMetaStoreAttribute pojoChild = this.metaStore.newAttribute(key, null);
                        parentElement.addChild(pojoChild);
                        this.savePojo(parentClass, pojoChild, parentObject, field);
                        continue block15;
                    }
                    default: {
                        throw new MetaStoreException("Only String values are supported at this time");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to save attributes of element id '" + parentElement.getId() + "', class " + parentClass.getName(), e);
        }
    }

    private void saveListAttribute(Class<?> parentClass, IMetaStoreAttribute parentElement, Object parentObject, Field field, String key) throws MetaStoreException {
        List list = (List)this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
        IMetaStoreAttribute topChild = this.metaStore.newAttribute(key, null);
        parentElement.addChild(topChild);
        MetaStoreAttribute metaStoreAttribute = field.getAnnotation(MetaStoreAttribute.class);
        if (!list.isEmpty()) {
            Class<?> attributeClass = list.get(0).getClass();
            topChild.setValue(attributeClass.getName());
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                IMetaStoreAttribute childAttribute = this.metaStore.newAttribute(Integer.toString(i), null);
                topChild.addChild(childAttribute);
                if (metaStoreAttribute != null && metaStoreAttribute.factoryNameReference()) {
                    this.saveFactoryNameReference(parentClass, childAttribute, parentObject, field, object);
                    continue;
                }
                if (object instanceof String) {
                    childAttribute.setValue(object);
                    continue;
                }
                if (this.objectFactory != null) {
                    Map<String, String> context = this.objectFactory.getContext(object);
                    this.saveObjectFactoryContext(childAttribute, context);
                }
                this.saveAttributes(childAttribute, attributeClass, object);
            }
        }
    }

    private void saveNameReference(Class<?> parentClass, IMetaStoreAttribute parentElement, Object parentObject, Field field, String key) throws MetaStoreException {
        Object namedObject = this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
        String name = null;
        if (namedObject != null) {
            name = (String)this.getAttributeValue(namedObject.getClass(), namedObject, "name", "getName");
        }
        IMetaStoreAttribute nameChild = this.metaStore.newAttribute(key, name);
        parentElement.addChild(nameChild);
    }

    private void saveFactoryNameReference(Class<?> parentClass, IMetaStoreAttribute parentElement, Object parentObject, Field field, String key) throws MetaStoreException {
        Object namedObject = this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
        if (namedObject == null) {
            return;
        }
        IMetaStoreAttribute refChild = this.metaStore.newAttribute(key, null);
        parentElement.addChild(refChild);
        this.saveFactoryNameReference(parentClass, refChild, parentObject, field, namedObject);
    }

    private void saveFactoryNameReference(Class<?> parentClass, IMetaStoreAttribute targetElement, Object parentObject, Field field, Object namedObject) throws MetaStoreException {
        Class<?> namedObjectClass = namedObject.getClass();
        String name = (String)this.getAttributeValue(namedObject.getClass(), namedObject, "name", "getName");
        targetElement.setValue(name);
        String indicatorName = field.getAnnotation(MetaStoreAttribute.class).factorySharedIndicatorName();
        if (indicatorName != null && indicatorName.length() > 0) {
            String isSharedMethod = this.getGetterMethodName(indicatorName, true);
            Boolean shared = (Boolean)this.getAttributeValue(namedObjectClass, namedObject, indicatorName, isSharedMethod);
            if (shared == null) {
                throw new MetaStoreException("Shared indicator attribute is not available through '" + namedObjectClass.getName() + "." + isSharedMethod + "()'");
            }
            if (!shared.booleanValue()) {
                this.savePojo(parentClass, targetElement, parentObject, namedObject);
                return;
            }
        }
        String factoryNameKey = field.getAnnotation(MetaStoreAttribute.class).factoryNameKey();
        MetaStoreFactory<?> factory = this.nameFactoryMap.get(factoryNameKey);
        try {
            Method method = factory.getClass().getMethod("saveElement", Object.class);
            method.invoke(factory, namedObject);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to save attribute element of class " + namedObject.getClass() + " in metastore", e);
        }
    }

    private void savePojo(Class<?> parentClass, IMetaStoreAttribute pojoElement, Object parentObject, Field field) throws MetaStoreException {
        Object pojo = this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
        this.savePojo(parentClass, pojoElement, parentObject, pojo);
    }

    private void savePojo(Class<?> parentClass, IMetaStoreAttribute pojoElement, Object parentObject, Object pojo) throws MetaStoreException {
        if (pojo == null) {
            return;
        }
        if (this.objectFactory != null) {
            Map<String, String> context = this.objectFactory.getContext(pojo);
            this.saveObjectFactoryContext(pojoElement, context);
        }
        IMetaStoreAttribute pojoChild = this.metaStore.newAttribute(POJO_CHILD, pojo.getClass().getName());
        pojoElement.addChild(pojoChild);
        this.saveAttributes(pojoChild, pojo.getClass(), pojo);
    }

    private void saveFilenameReference(Class<?> parentClass, IMetaStoreAttribute parentElement, Object parentObject, Field field, String key) throws MetaStoreException {
        Object namedObject = this.getAttributeValue(parentClass, parentObject, field.getName(), this.getGetterMethodName(field.getName(), false));
        String name = null;
        if (namedObject != null) {
            name = (String)this.getAttributeValue(namedObject.getClass(), namedObject, "filename", "getFilename");
        }
        IMetaStoreAttribute nameChild = this.metaStore.newAttribute(key, name);
        parentElement.addChild(nameChild);
    }

    public List<T> getElements() throws MetaStoreException {
        MetaStoreElementType elementTypeAnnotation = this.getElementTypeAnnotation();
        IMetaStoreElementType elementType = this.metaStore.getElementTypeByName(this.namespace, elementTypeAnnotation.name());
        if (elementType == null) {
            return Collections.emptyList();
        }
        List<IMetaStoreElement> elements = this.metaStore.getElements(this.namespace, elementType);
        ArrayList<T> list = new ArrayList<T>(elements.size());
        for (IMetaStoreElement metaStoreElement : elements) {
            list.add(this.loadElement(metaStoreElement));
        }
        return list;
    }

    public void deleteElement(String name) throws MetaStoreException {
        MetaStoreElementType elementTypeAnnotation = this.getElementTypeAnnotation();
        IMetaStoreElementType elementType = this.metaStore.getElementTypeByName(this.namespace, elementTypeAnnotation.name());
        if (elementType == null) {
            throw new MetaStoreException("The element type '" + elementTypeAnnotation.name() + "' does not exist so the element with name '" + name + "' can not be deleted");
        }
        IMetaStoreElement element = this.metaStore.getElementByName(this.namespace, elementType, name);
        if (element == null) {
            throw new MetaStoreException("The element with name '" + name + "' does not exists so it can not be deleted");
        }
        this.metaStore.deleteElement(this.namespace, elementType, element.getId());
    }

    public List<String> getElementNames() throws MetaStoreException {
        ArrayList<String> names = new ArrayList<String>();
        MetaStoreElementType elementTypeAnnotation = this.getElementTypeAnnotation();
        IMetaStoreElementType elementType = this.metaStore.getElementTypeByName(this.namespace, elementTypeAnnotation.name());
        if (elementType == null) {
            return names;
        }
        List<IMetaStoreElement> elements = this.metaStore.getElements(this.namespace, elementType);
        for (IMetaStoreElement element : elements) {
            names.add(element.getName());
        }
        return names;
    }

    public IMetaStoreElementType getElementType() throws MetaStoreException {
        MetaStoreElementType elementTypeAnnotation = this.getElementTypeAnnotation();
        return this.metaStore.getElementTypeByName(this.namespace, elementTypeAnnotation.name());
    }

    private AttributeType determineAttributeType(Field field, MetaStoreAttribute annotation) throws MetaStoreException {
        Class<?> fieldClass = field.getType();
        if (List.class.equals(fieldClass)) {
            return AttributeType.LIST;
        }
        if (annotation.nameReference()) {
            return AttributeType.NAME_REFERENCE;
        }
        if (annotation.filenameReference()) {
            return AttributeType.FILENAME_REFERENCE;
        }
        if (annotation.factoryNameReference()) {
            return AttributeType.FACTORY_NAME_REFERENCE;
        }
        if (String.class.equals(fieldClass)) {
            return AttributeType.STRING;
        }
        if (Integer.TYPE.equals(fieldClass)) {
            return AttributeType.INTEGER;
        }
        if (Long.TYPE.equals(fieldClass)) {
            return AttributeType.LONG;
        }
        if (Date.class.equals(fieldClass)) {
            return AttributeType.DATE;
        }
        if (Boolean.TYPE.equals(fieldClass)) {
            return AttributeType.BOOLEAN;
        }
        if (fieldClass.isEnum()) {
            return AttributeType.ENUM;
        }
        return AttributeType.POJO;
    }

    private MetaStoreElementType getElementTypeAnnotation() throws MetaStoreException {
        MetaStoreElementType elementTypeAnnotation = this.clazz.getAnnotation(MetaStoreElementType.class);
        if (elementTypeAnnotation == null) {
            throw new MetaStoreException("The class you want to serialize needs to have the @MetaStoreElementType annotation");
        }
        return elementTypeAnnotation;
    }

    private void setAttributeValue(Class<?> parentClass, Object object, String fieldName, String setterName, Class<?> valueClass, Object value) throws MetaStoreException {
        Method method;
        try {
            method = parentClass.getDeclaredMethod(setterName, valueClass);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to find setter for attribute field : " + fieldName + ". Expected '" + setterName + "'", e);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to set value '" + value + "' using method '" + setterName + "'", e);
        }
    }

    private Object getAttributeValue(Class<?> parentClass, Object object, String fieldName, String getterName) throws MetaStoreException {
        Method method;
        try {
            method = parentClass.getDeclaredMethod(getterName, new Class[0]);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to find getter for attribute field : " + fieldName + ". Expected '" + getterName + "'", e);
        }
        try {
            Object value = method.invoke(object, new Object[0]);
            return value;
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get value using method '" + getterName + "' on class " + parentClass.getName(), e);
        }
    }

    private String getSetterMethodName(String name) {
        StringBuilder setter = new StringBuilder();
        setter.append("set");
        setter.append(name.substring(0, 1).toUpperCase());
        setter.append(name.substring(1));
        return setter.toString();
    }

    private String getGetterMethodName(String name, boolean isBoolean) {
        StringBuilder setter = new StringBuilder();
        setter.append(isBoolean ? "is" : "get");
        setter.append(name.substring(0, 1).toUpperCase());
        setter.append(name.substring(1));
        return setter.toString();
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, List<?>> getNamedListMap() {
        return this.nameListMap;
    }

    public void setNamedListMap(Map<String, List<?>> namedListMap) {
        this.nameListMap = namedListMap;
    }

    public Map<String, List<?>> getNameListMap() {
        return this.nameListMap;
    }

    public void setNameListMap(Map<String, List<?>> nameListMap) {
        this.nameListMap = nameListMap;
    }

    public Map<String, List<?>> getFilenameListMap() {
        return this.filenameListMap;
    }

    public void setFilenameListMap(Map<String, List<?>> filenameListMap) {
        this.filenameListMap = filenameListMap;
    }

    public IMetaStoreObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(IMetaStoreObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    private static enum AttributeType {
        STRING,
        INTEGER,
        LONG,
        DATE,
        BOOLEAN,
        LIST,
        NAME_REFERENCE,
        FILENAME_REFERENCE,
        FACTORY_NAME_REFERENCE,
        ENUM,
        POJO;

    }
}

