/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmloutput;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmloutput.XMLField;
import org.pentaho.di.trans.steps.xmloutput.XMLOutput;
import org.pentaho.di.trans.steps.xmloutput.XMLOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class XMLOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = XMLOutputMeta.class;
    private String fileName;
    private String extension;
    private boolean servletOutput;
    private int splitEvery;
    private boolean stepNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean zipped;
    private String encoding;
    private String nameSpace;
    private String mainElement;
    private String repeatElement;
    private boolean addToResultFilenames;
    private XMLField[] outputFields;
    private boolean doNotOpenNewFileInit;
    private boolean omitNullValues;
    private boolean SpecifyFormat;
    private String date_time_format;

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean zipped) {
        this.zipped = zipped;
    }

    public XMLField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(XMLField[] outputFields) {
        this.outputFields = outputFields;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new XMLField[nrfields];
    }

    @Override
    public Object clone() {
        XMLOutputMeta retval = (XMLOutputMeta)super.clone();
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (XMLField)this.outputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.nameSpace = XMLHandler.getTagValue((Node)stepnode, (String)"name_space");
            this.mainElement = XMLHandler.getTagValue((Node)stepnode, (String)"xml_main_element");
            this.repeatElement = XMLHandler.getTagValue((Node)stepnode, (String)"xml_repeat_element");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.servletOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"servlet_output"));
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"do_not_open_newfile_init"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"SpecifyFormat"));
            this.omitNullValues = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"omit_null_values"));
            this.date_time_format = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"date_time_format");
            this.addToResultFilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_to_result_filenames"));
            this.zipped = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"zipped"));
            this.splitEvery = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"splitevery"), (int)0);
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new XMLField();
                String contentTypeString = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"content_type"), (String)XMLField.ContentType.Element.name());
                this.outputFields[i].setContentType(XMLField.ContentType.valueOf(contentTypeString));
                String fieldName = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.outputFields[i].setFieldName(fieldName);
                String elementName = XMLHandler.getTagValue((Node)fnode, (String)"element");
                this.outputFields[i].setElementName(elementName == null ? "" : elementName);
                this.outputFields[i].setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.outputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.outputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.outputFields[i].setGroupingSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                this.outputFields[i].setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullif"));
                this.outputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            }
        }
        return nl;
    }

    @Override
    public void setDefault() {
        this.fileName = "file";
        this.extension = "xml";
        this.stepNrInFilename = false;
        this.doNotOpenNewFileInit = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.addToResultFilenames = false;
        this.zipped = false;
        this.splitEvery = 0;
        this.encoding = "UTF-8";
        this.nameSpace = "";
        this.date_time_format = null;
        this.SpecifyFormat = false;
        this.omitNullValues = false;
        this.mainElement = "Rows";
        this.repeatElement = "Row";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new XMLField();
            this.outputFields[i].setContentType(XMLField.ContentType.Element);
            this.outputFields[i].setFieldName("field" + i);
            this.outputFields[i].setElementName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
        }
    }

    public String[] getFiles(VariableSpace space) {
        int nr;
        int copies = 1;
        int splits = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int split = 0; split < splits; ++split) {
                retval[i] = this.buildFilename(space, copy, split, false);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(VariableSpace space, int stepnr, int splitnr, boolean ziparchive) {
        SimpleDateFormat daf = new SimpleDateFormat();
        DecimalFormat df = new DecimalFormat("00000");
        String retval = space.environmentSubstitute(this.fileName);
        String realextension = space.environmentSubstitute(this.extension);
        Date now = new Date();
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.dateInFilename) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.timeInFilename) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.splitEvery > 0) {
            retval = retval + "_" + df.format(splitnr + 1);
        }
        if (this.zipped) {
            if (ziparchive) {
                retval = retval + ".zip";
            } else if (realextension != null && realextension.length() != 0) {
                retval = retval + "." + realextension;
            }
        } else if (realextension != null && realextension.length() != 0) {
            retval = retval + "." + realextension;
        }
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        for (int i = 0; i < this.outputFields.length; ++i) {
            XMLField field = this.outputFields[i];
            ValueMetaInterface v = row.searchValueMeta(field.getFieldName());
            if (v == null) continue;
            v.setLength(field.getLength(), field.getPrecision());
        }
    }

    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        RowMeta row = new RowMeta();
        for (int i = 0; i < this.outputFields.length; ++i) {
            XMLField field = this.outputFields[i];
            row.addValueMeta((ValueMetaInterface)new ValueMeta(field.getFieldName(), field.getType(), field.getLength(), field.getPrecision()));
        }
        return row;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(600);
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"name_space", (String)this.nameSpace));
        retval.append("    ").append(XMLHandler.addTagValue((String)"xml_main_element", (String)this.mainElement));
        retval.append("    ").append(XMLHandler.addTagValue((String)"xml_repeat_element", (String)this.repeatElement));
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servlet_output", (boolean)this.servletOutput));
        retval.append("      ").append(XMLHandler.addTagValue((String)"do_not_open_newfile_init", (boolean)this.doNotOpenNewFileInit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"omit_null_values", (boolean)this.omitNullValues));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("      ").append(XMLHandler.addTagValue((String)"zipped", (boolean)this.zipped));
        retval.append("      ").append(XMLHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            XMLField field = this.outputFields[i];
            if (field.getFieldName() == null || field.getFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"content_type", (String)field.getContentType().name()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"element", (String)field.getElementName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.nameSpace = rep.getStepAttributeString(id_step, "name_space");
            this.mainElement = rep.getStepAttributeString(id_step, "xml_main_element");
            this.repeatElement = rep.getStepAttributeString(id_step, "xml_repeat_element");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.servletOutput = rep.getStepAttributeBoolean(id_step, "file_servlet_output");
            this.doNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, "do_not_open_newfile_init");
            this.splitEvery = (int)rep.getStepAttributeInteger(id_step, "file_split");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.SpecifyFormat = rep.getStepAttributeBoolean(id_step, "SpecifyFormat");
            this.omitNullValues = rep.getStepAttributeBoolean(id_step, "omit_null_values");
            this.date_time_format = rep.getStepAttributeString(id_step, "date_time_format");
            this.addToResultFilenames = rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.zipped = rep.getStepAttributeBoolean(id_step, "file_zipped");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new XMLField();
                this.outputFields[i].setContentType(XMLField.ContentType.valueOf(Const.NVL((String)rep.getStepAttributeString(id_step, i, "field_content_type"), (String)XMLField.ContentType.Element.name())));
                this.outputFields[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setElementName(rep.getStepAttributeString(id_step, i, "field_element"));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.outputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.outputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.outputFields[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                this.outputFields[i].setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                this.outputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.outputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "name_space", this.nameSpace);
            rep.saveStepAttribute(id_transformation, id_step, "xml_main_element", this.mainElement);
            rep.saveStepAttribute(id_transformation, id_step, "xml_repeat_element", this.repeatElement);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_servlet_output", this.servletOutput);
            rep.saveStepAttribute(id_transformation, id_step, "do_not_open_newfile_init", this.doNotOpenNewFileInit);
            rep.saveStepAttribute(id_transformation, id_step, "file_split", this.splitEvery);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "SpecifyFormat", this.SpecifyFormat);
            rep.saveStepAttribute(id_transformation, id_step, "omit_null_values", this.omitNullValues);
            rep.saveStepAttribute(id_transformation, id_step, "date_time_format", this.date_time_format);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.addToResultFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "file_zipped", this.zipped);
            for (int i = 0; i < this.outputFields.length; ++i) {
                XMLField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_content_type", field.getContentType().name());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_element", field.getElementName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getFieldName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getFieldName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new XMLOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XMLOutputData();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMainElement() {
        return this.mainElement;
    }

    public void setMainElement(String mainElement) {
        this.mainElement = mainElement;
    }

    public String getRepeatElement() {
        return this.repeatElement;
    }

    public void setRepeatElement(String repeatElement) {
        this.repeatElement = repeatElement;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setOmitNullValues(boolean omitNullValues) {
        this.omitNullValues = omitNullValues;
    }

    public boolean isOmitNullValues() {
        return this.omitNullValues;
    }

    public boolean isServletOutput() {
        return this.servletOutput;
    }

    public void setServletOutput(boolean servletOutput) {
        this.servletOutput = servletOutput;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!Const.isEmpty((String)this.fileName)) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName), (VariableSpace)space);
                this.fileName = resourceNamingInterface.nameResource(fileObject, space, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

